package com.ejianc.business.equipment.service.impl;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementFeeEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseSettlementService")
public class PurchaseSettlementServiceImpl extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";
    private static final String EQUIPMENT_PURCHASE_SETTLE = "EQUIPMENT_PURCHASE_SETTLE";
    private static final String EQUIPMENT_PURCHASE_SETTLE_DETAIL = "EQUIPMENT_PURCHASE_SETTLE_DETAIL";
    private static final String EQUIPMENT_PURCHASE_SETTLE_FEE = "EQUIPMENT_PURCHASE_SETTLE_FEE";
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";
    @Autowired
    private IPurchaseContractService purchaseContractService;


    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IInvoiceApi invoiceApi;


    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId, purchaseSettlementVo.getContractId());
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, purchaseSettlementVo.getOrgId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0) {
            lambdachange.ne(PurchaseSettlementEntity::getId, purchaseSettlementVo.getId());
        }
        lambdachange.ne(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }

        //保存时校验合同version是否一致
        if (purchaseSettlementVo.getContractVersion() != null && purchaseSettlementVo.getContractVersion() != 0) {
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock(jedis, String.valueOf(purchaseSettlementVo.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------" + locked);
                if (locked) {
                    PurchaseContractEntity contractEntity = purchaseContractService.selectById(purchaseSettlementVo.getContractId());
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    Integer conVersion = purchaseSettlementVo.getContractVersion();
                    if (version != conVersion) {
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                } else {
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(purchaseSettlementVo.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }

        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange2.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId, purchaseSettlementVo.getContractId());
        lambdachange2.eq(PurchaseSettlementEntity::getOrgId, purchaseSettlementVo.getOrgId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0) {
            lambdachange2.ne(PurchaseSettlementEntity::getId, purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(PurchaseSettlementEntity::getSettlementDate, purchaseSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = purchaseSettlementVo.getSymny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSymny();//剩余冲抵金额
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if (offsetMny.compareTo(settlementTaxMny) > 0 && settlementTaxMny.compareTo(BigDecimal.ZERO) >= 0) {
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if (StringUtils.isEmpty(purchaseSettlementVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //成本改造
        //设置是否关联
        purchaseSettlementVo.setRelationFlag("0");
        purchaseSettlementVo.setProportionFlag("0");
        entity = BeanMapper.map(purchaseSettlementVo, PurchaseSettlementEntity.class);

        //获取已收票金额
        CommonResponse<BigDecimal> invoiceReceiceMnyRes = invoiceApi.getInvoiceReceiceMny(entity.getContractId(), entity.getOrgId());
        if(invoiceReceiceMnyRes.isSuccess()){
            entity.setSumInvoiceTaxMny(ComputeUtil.nullToZero(invoiceReceiceMnyRes.getData()));
        }

        super.saveOrUpdate(entity, false);
        PurchaseSettlementVO vo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success(vo);
    }

    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        PurchaseSettlementEntity entity = super.selectById(id);
        PurchaseSettlementVO purchaseSettlementVo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        purchaseSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return purchaseSettlementVo;
    }

    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseSettlementVO purchaseSettlementVO = BeanMapper.map(entity, PurchaseSettlementVO.class);
        //新增逻辑处理
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);
        purchaseSettlementVO.setMemo(null);
        purchaseSettlementVO.setContractVersion(entity.getVersion());
        purchaseSettlementVO.setSettlementType("0");
        purchaseSettlementVO.setSumInvoiceTaxMny(null);

        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id, entity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        purchaseSettlementVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        purchaseSettlementVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId, id);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, entity.getOrgId());
        lambdachange.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> list = super.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP), new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            //累计结算金额
            purchaseSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            purchaseSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }else{
            //累计结算金额
            purchaseSettlementVO.setSumSettlementTaxMny(BigDecimal.ZERO);
            //累计冲抵金额
            purchaseSettlementVO.setSumOffsetMny(BigDecimal.ZERO);
        }
        BigDecimal sumOffsetMnys = purchaseSettlementVO.getSumOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumOffsetMny();
        if (purchaseSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            purchaseSettlementVO.setSymny(purchaseSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = purchaseSettlementVO.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, ROUND_HALF_DOWN)));
        }
        return purchaseSettlementVO;
    }

    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseSettlementVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public CommonResponse<PurchaseSettlementVO> pushCost(PurchaseSettlementVO purchaseSettlementVO) {
        PurchaseSettlementEntity purchaseSettlementEntity = baseMapper.selectById(purchaseSettlementVO.getId());
        if (ListUtil.isNotEmpty(purchaseSettlementVO.getPurchasedetail())) {
            List<PurchaseSettlementDetailEntity> purchaseSettleDetail = BeanMapper.mapList(purchaseSettlementVO.getPurchasedetail(), PurchaseSettlementDetailEntity.class);
            purchaseSettlementEntity.setPurchasedetail(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty(purchaseSettlementVO.getPurchasefee())) {
            List<PurchaseSettlementFeeEntity> purchaseSettleFee = BeanMapper.mapList(purchaseSettlementVO.getPurchasefee(), PurchaseSettlementFeeEntity.class);
            purchaseSettlementEntity.setPurchasefee(purchaseSettleFee);
        }
        super.saveOrUpdate(purchaseSettlementEntity, false);
        //推送数据
        costPush(purchaseSettlementEntity);
        return CommonResponse.success(BeanMapper.map(purchaseSettlementEntity, PurchaseSettlementVO.class));
    }

    @Override
    public void costPush(PurchaseSettlementEntity settlementEntity) {
        logger.info("推送成本开始");
        boolean newRelationFlag = true;
        //1.判断结算单所有子表是否全部关联科目
        List<PurchaseSettlementDetailEntity> purchasedetail = settlementEntity.getPurchasedetail();
        //查询费用表是否全部关联费用科目
        List<PurchaseSettlementFeeEntity> purchasefee = settlementEntity.getPurchasefee();
//        if (ListUtil.isEmpty(purchasedetail) && ListUtil.isEmpty(purchasefee)) {
//            newRelationFlag = false;
//        }
        for (PurchaseSettlementDetailEntity detailVO : purchasedetail) {
            if (detailVO.getSubjectId() == null || detailVO.getSubjectId() <= 0) {
                newRelationFlag = false;
            }
        }
        for (PurchaseSettlementFeeEntity otherVO : purchasefee) {
            if (otherVO.getSubjectId() == null || otherVO.getSubjectId() <= 0) {
                newRelationFlag = false;
            }
        }
        //更新是否关联
        LambdaUpdateWrapper<PurchaseSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PurchaseSettlementEntity::getId, settlementEntity.getId());
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, newRelationFlag ? "1" : "0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = settlementEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                saveCost(settlementEntity);
            }
            if (!newRelationFlag) {
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")) {
                //税率
                saveCost(settlementEntity);
        }
        logger.info("推送成本结束");

    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId, id);
        lambda.in(PurchaseSettlementEntity::getOrgId, commonOrgIds);
        lambda.orderByDesc(PurchaseSettlementEntity::getCreateTime);
        List<PurchaseSettlementEntity> entitiesAllState = super.list(lambda);
        lambda.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            entities.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = vo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getSumSettlementTaxMny();//累计结算金额
            if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) != 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, ROUND_HALF_DOWN)));
            } else {
                vo.setSumScale(BigDecimal.ZERO);
            }
        }
        vo.setSettlementRecord(BeanMapper.mapList(entitiesAllState, PurchaseSettlementVO.class));
        return vo;
    }

    private void saveCost(PurchaseSettlementEntity entity) {
        //税率
        BigDecimal rate = entity.getTaxRate() == null ? BigDecimal.ZERO : entity.getTaxRate();
        BigDecimal taxRate = rate.divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PurchaseSettlementDetailEntity> pushPurchaseDetail = entity.getPurchasedetail();
        if (ListUtil.isNotEmpty(pushPurchaseDetail)) {
            for (PurchaseSettlementDetailEntity detail : pushPurchaseDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(detail.getSettlementId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setHappenTaxMny(detail.getSettlementMny());
                //无税值计算
                BigDecimal pushSettlementMny = detail.getSettlementMny() == null ? BigDecimal.ZERO : detail.getSettlementMny();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_DETAIL);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("设备采购合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                costDetailVO.setNum(detail.getNum() == null ? BigDecimal.ZERO : detail.getNum()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量
                // 以下信息物资、设备、周转材档案类传
                costDetailVO.setMaterialId(detail.getEquipmentId()); // 物资主键
                costDetailVO.setMaterialName(detail.getName()); // 物资名称
                costDetailVO.setUnit(detail.getUnitName()); // 单位名称
                costDetailVOList.add(costDetailVO);

            }
        }
        //费用
        List<PurchaseSettlementFeeEntity> pushPurchaseFee = entity.getPurchasefee();
        if (ListUtil.isNotEmpty(pushPurchaseFee)) {
            for (PurchaseSettlementFeeEntity detail : pushPurchaseFee) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(detail.getSettlementId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setHappenTaxMny(detail.getMoney());
                //无税值计算
                BigDecimal pushSettlementMny = detail.getMoney() == null ? BigDecimal.ZERO : detail.getMoney();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_FEE);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("设备采购合同结算"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                costDetailVOList.add(costDetailVO);
            }
        }

        if (CollectionUtils.isEmpty(pushPurchaseDetail) && CollectionUtils.isEmpty(pushPurchaseFee)) {
            CostDetailVO costDetailVO = new CostDetailVO();
//            costDetailVO.setSubjectId(detail.getSubjectId());
            costDetailVO.setSourceId(entity.getId());
//            costDetailVO.setSourceDetailId(detail.getId());
            costDetailVO.setHappenTaxMny(entity.getSettlementTaxMny());
            //无税值计算
            BigDecimal pushSettlementMny = entity.getSettlementTaxMny() == null ? BigDecimal.ZERO : entity.getSettlementTaxMny();
            BigDecimal happenMny = pushSettlementMny.divide(number, 2, BigDecimal.ROUND_HALF_UP);
            costDetailVO.setHappenMny(happenMny);
            costDetailVO.setHappenDate(entity.getSettlementDate());
            costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
//            costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_FEE);
            costDetailVO.setProjectId(entity.getProjectId());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
            LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
            costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
            costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
            costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
            costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
            costDetailVO.setSourceBillName("设备采购合同结算"); // 来源单据名称 说明：材料验收单
            costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
            costDetailVOList.add(costDetailVO);
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()) {
                logger.info("推送成本返回:{}",JSONObject.toJSONString(stringCommonResponse));

            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PurchaseSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PurchaseSettlementEntity::getId, id);
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny, Long projectId, Long orgId) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        logger.info("sumPayMny:{},payMny:{},contractMny:{} ",
                JSONObject.toJSONString(sumPayMny),
                JSONObject.toJSONString(payMny),
                JSONObject.toJSONString(contractMny)
        );
        CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (!response.isSuccess()) {
            logger.info(response.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> billParamVOS = response.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS)){
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
                    BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100)));
                    if (sumPayWithThisMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：")
                                .append(payMny.setScale(2, RoundingMode.HALF_UP)).append("元，含本次累计金额")
                                .append(sumPayWithThisMny.setScale(2, RoundingMode.HALF_UP)).append("元,合同金额*")
                                .append(roleValue).append("%:").append(comMny.setScale(2, RoundingMode.HALF_UP))
                                .append("元。超出金额：")
                                .append(sumPayWithThisMny.subtract(comMny).setScale(2, RoundingMode.HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
/**
 * 更新参数控制结果
 *
 * @param paramsArray      参数数组
 * @param paramsCheckVOMap 预警结果map
 * @param billParamVO      控制参数
 * @param paramsCheckDsVO  预警信息
 */
public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
        List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
        alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
        List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
        warn.add(paramsCheckDsVO);
        }
        }
}
