package com.ejianc.business.equipment.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.utils.ListSplitUtil;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.othprice.api.IPicketageApi;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】
    private static final String PARAM_TOTAL_UNTAX_MNY = "P-4Qavg0101"; // 【预算机械费无税总金额】控 【设备合同无税总金额】
    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89"; // 【项目预算总金额】控【项目总支出金额】

    //    @Autowired
//    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private PurchaseContractMapper purchaseContractMapper;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private IPicketageApi picketageApi;

    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = BeanMapper.map(rentContractVo, RentContractEntity.class);
        List<RentContractEntity> entities = null;
        List<RentChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(rentContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,rentContractVo.getId()));
            entitiesc = rentChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            entitiesc = rentChangeService.queryList(queryParam,false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if(CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
        boolean b = super.saveOrUpdate(entity, false);
        if (b) {
            this.countContractNumAndMnyByEnquiry(entity.getEnquiryPriceBillId());
        }
        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = super.selectById(id);
        entity.setRentdetail(null);
        RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);
        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId,id);
        lambda.ne(RentContractDetailEntity::getChangeType,"3");
        details = rentContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            rentContractVo.setRentdetail(BeanMapper.mapList(details,RentContractDetailVO.class));
        }
        return rentContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(RentContractVO::getId).collect(Collectors.toList());
            //删除后如果是定标新增的则更新定标的签订合同金额
            LambdaQueryWrapper<RentContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(RentContractEntity::getId, ids);
            queryWrapper.isNotNull(RentContractEntity::getEnquiryPriceBillId);
            List<RentContractEntity> contractEntities = this.list(queryWrapper);
            boolean b = this.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty(contractEntities)) {
                List<Long> enquiryPriceBillIds = contractEntities.stream().filter(t -> t.getEnquiryPriceBillId() != null).map(RentContractEntity::getEnquiryPriceBillId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(enquiryPriceBillIds)) {
                    this.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
                }
            }
        }
       // super.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.querySettleWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryPayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryPrePayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryTaxWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }
    @Override
    public BigDecimal totalContractMny(RentContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<RentContractEntity> rentQuery = new QueryWrapper<>();
        rentQuery.eq("project_Id", vo.getProjectId());
        rentQuery.in("change_status",Arrays.asList(1,3));
//        rentQuery.in("bill_state", Arrays.asList(
//                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
//                BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
//                BillStateEnum.PASSED_STATE.getBillStateCode()));
//        rentQuery.eq("contract_status",2);
        if (vo.getId()!=null){
            rentQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        rentQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentContractEntity rentContract = super.getOne(rentQuery);
        if(rentContract!=null &&null != rentContract.getContractTaxMny()&&!"0".equals(rentContract.getContractTaxMny())) {
             contractTaxMny = contractTaxMny.add(rentContract.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<RentChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentChangeEntity changeEntity = rentChangeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }

    public BigDecimal totalContractMnyUnTax(RentContractVO vo){
        BigDecimal contractMny = BigDecimal.ZERO;
        QueryWrapper<RentContractEntity> rentQuery = new QueryWrapper<>();
        rentQuery.eq("project_Id", vo.getProjectId());
        rentQuery.in("change_status",Arrays.asList(1,3));
//        rentQuery.in("bill_state", Arrays.asList(
//                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
//                BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
//                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
//                BillStateEnum.PASSED_STATE.getBillStateCode()));
//        rentQuery.eq("contract_status",2);
        if (vo.getId()!=null){
            rentQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractMny =contractMny.add(vo.getContractMny());
        }
        rentQuery.select("sum(contract_mny) as contractMny");
        RentContractEntity rentContract = super.getOne(rentQuery);
        if(rentContract!=null &&null != rentContract.getContractMny()&&!"0".equals(rentContract.getContractMny())) {
            contractMny = contractMny.add(rentContract.getContractMny());
        }
        //统计变更中的金额
        QueryWrapper<RentChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_mny) as contractMny");
        RentChangeEntity changeEntity = rentChangeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractMny()&&!"0".equals(changeEntity.getContractMny())) {
            contractMny = contractMny.add(changeEntity.getContractMny());
        }
        return  contractMny;
    }


    /**
     * 参数控制
     *
     * @param vo 预算机械费总金额  设备租赁总金额
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(RentContractVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            BigDecimal budgetMny =  data.getMechanicalMny()==null ? BigDecimal.ZERO : data.getMechanicalMny();

            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal  rentContractTaxMny= totalContractMny(vo);
            //设备租赁总金额
            PurchaseContractVO purchaseContract = new PurchaseContractVO();
            purchaseContract.setProjectId(vo.getProjectId());
            BigDecimal purchaseContractTaxMny = purchaseContractService.totalContractMny(purchaseContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
            //【预算机械费无税总金额】控 【设备合同无税总金额】
            CommonResponse<List<BillParamVO>> response3 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_UNTAX_MNY, curOrgId);
            if (!response3.isSuccess()) {
                throw new BusinessException("【预算机械费无税总金额】控 【设备合同无税总金额】，获取控制参数失败，失败原因：" + response3.getMsg());
            }
            //设备采购总金额
            BigDecimal  rentContractMny= totalContractMnyUnTax(vo);
            //设备租赁总金额
            PurchaseContractVO purchaseContract1 = new PurchaseContractVO();
            purchaseContract1.setProjectId(vo.getProjectId());
            BigDecimal purchaseContractMny = purchaseContractService.totalContractMnyUnTax(purchaseContract1);
            BigDecimal totalContractMnyUntax = purchaseContractMny.add(rentContractMny);
            List<BillParamVO> billParamVOS3 = response3.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS3)) {
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetMnyResult = budgetMny.multiply(scale);
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMnyUntax.compareTo(budgetMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMnyUntax.subtract(budgetMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同无税总金额超预算机械费无税总金额");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnName("设备合同无税总金额大于预算机械费无税总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目设备合同无税总金额：")
                                    .append(totalContractMnyUntax.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费无税总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
            // 【项目预算总金额】控【项目总支出金额】
            //项目总预算金额
            BigDecimal allBudgetTaxMny = res.getData().getBudgetTaxMny() == null ? BigDecimal.ZERO : res.getData().getBudgetTaxMny();
            CommonResponse<List<BillParamVO>> responseBudge = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BUDGE_MNY, InvocationInfoProxy.getOrgId());

            if (!responseBudge.isSuccess()) {
                throw new BusinessException(" 项目总支出金额超项目总预算金额，获取控制参数失败，失败原因：" + responseBudge.getMsg());
            }
            List<BillParamVO> billParamVOSBudge = responseBudge.getData();
            if (CollectionUtils.isNotEmpty(billParamVOSBudge)) {
                //获取项目总支出金额
                BigDecimal totalOutMny = vo.getContractTaxMny();
                CommonResponse<Map<String, BigDecimal>> proOutMnyCommonResponse = budgetProjectProApi.getProOutMny(vo.getProjectId(), vo.getId(), BillTypeCodeEnum.设备租赁合同.getBillTypeCode());
                logger.info(" 项目总支出金额不含本次 返回内容:{}", JSONObject.toJSONString(proOutMnyCommonResponse));
                if (!proOutMnyCommonResponse.isSuccess()) {
                    throw new BusinessException(proOutMnyCommonResponse.getMsg());
                }
                totalOutMny = totalOutMny.add(proOutMnyCommonResponse.getData().get("TaxMny"));
                for (BillParamVO billParamVO : billParamVOSBudge) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = allBudgetTaxMny.multiply(scale);
                        // 项目总支出金额超项目总预算金额
                        logger.info("项目总支出金额:{},项目总预算金额:{}", JSONObject.toJSONString(totalOutMny), JSONObject.toJSONString(budgetTaxMnyResult));

                        if (totalOutMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 项目总支出金额 - 项目预算总金额 * X%
                            BigDecimal over = totalOutMny.subtract(budgetTaxMnyResult);

                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

                            paramsCheckDsVO.setWarnItem("项目总支出金额超项目总预算金额");
                            paramsCheckDsVO.setWarnName("项目总支出金额超项目总预算金额");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("项目总支出金额：")
                                    .append(totalOutMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 项目预算总金额 * ")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(roleValue, 8)).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(null, vo.getId(), vo.getProjectId(), vo.getContractTaxMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目支出汇总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("支出汇总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("支出汇总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        BigDecimal sbcg = purchaseContractMapper.fetchSjzcje(projectId, null, null);
        BigDecimal sbzl = baseMapper.fetchSjzcje(projectId, changeId, contractId);
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    @Override
    public BigDecimal fetchSjzcjeRent(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null, null);
    }

    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     * @param enquiryPriceBillIds
     */
    @Override
    public PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        if(enquiryPriceBillIds != null && enquiryPriceBillIds.length > 0){
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper<RentContractEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("count(1) as num, IFNULL(sum(contract_tax_mny),0) as money")
                        .eq("enquiry_price_bill_id", enquiryPriceBillId);
                Map<String, Object> map = this.getMap(queryWrapper);
                PicketageVO picketageVO = new PicketageVO();
                if(MapUtils.isNotEmpty(map)){
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(num);
                    picketageVO.setContractSignMny(money);
                } else {
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(0);
                    picketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                picketageApi.updateContractSignMny(picketageVO);
            }
        }
        return null;
    }
}
