package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

/**
 * <p>
 * 设备使用申请明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@TableName("ejc_equipment_apply_detail")
public class ApplyDetailEntity extends BaseEntity{

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 设备使用申请主键
     */
    @TableField("apply_id")
    private Long applyId;

    /**
     * 机械设备名称
     */
    @TableField("name")
    private String name;

    /**
     * 设备档案主键
     */
    @TableField("equipment_id")
    private Long equipmentId;

    /**
     * 机械设备编码
     */
    @TableField("code")
    private String code;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计量单位
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 计划使用数量
     */
    @TableField("plan_num")
    private BigDecimal planNum;

    /**
     * 计划进场日期
     */
    @TableField("start_date")
    private Date startDate;

    /**
     * 计划出场日期
     */
    @TableField("end_date")
    private Date endDate;

    /**
     * 计划使用天数
     */
    @TableField("plan_day")
    private BigDecimal planDay;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }



    @Override
    public String toString() {
        return "ApplyDetailEntity{" +
            "applyId=" + applyId +
            ", name=" + name +
            ", equipmentId=" + equipmentId +
            ", code=" + code +
            ", spec=" + spec +
            ", unitName=" + unitName +
            ", planNum=" + planNum +
            ", startDate=" + startDate +
            ", endDate=" + endDate +
            ", planDay=" + planDay +
            ", memo=" + memo +
        "}";
    }
}
