package com.ejianc.business.equipment.controller.openapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IRentSettlementDetailService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping(value = "/equipment")
public class EquipmentOpenApi {

    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;

    @PostMapping(value = "/queryRentSettlementPage")
    public CommonResponse<IPage<RentSettlementEntity>> queryRentSettlementPage(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<RentSettlementEntity> page = rentSettlementService.queryPage(param, false);
        for (RentSettlementEntity entity : page.getRecords()) {
            try {
                if (entity.getContractId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getContractId()), "equipment-rent-contract");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setContractCode(json.getString("code"));
                    }
                }
                if (entity.getProjectId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getProjectId()), "market-project");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setProjectCode(json.getString("code"));
                    }
                }
                if (entity.getEmployeeId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getEmployeeId()), "idm-user");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setEmployeeCode(json.getString("code"));
                    }
                }
                if (entity.getSupplierId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getSupplierId()), "support-supplier");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setSupplierCode(json.getString("code"));
                    }
                }
                if (entity.getOrgId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getOrgId()), "idm-org");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setOrgCode(json.getString("code"));
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success("查询租赁合同结算列表数据成功！", page);
    }

    @GetMapping(value = "/queryRentSettlementDetail")
    public CommonResponse<RentSettlementEntity> queryRentSettlementDetail(Long id) {
        RentSettlementEntity entity = rentSettlementService.selectById(id);
        if (entity != null) {
            try {
                if (entity.getContractId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getContractId()), "equipment-rent-contract");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setContractCode(json.getString("code"));
                    }
                }
                if (entity.getProjectId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getProjectId()), "market-project");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setProjectCode(json.getString("code"));
                    }
                }
                if (entity.getEmployeeId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getEmployeeId()), "idm-user");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setEmployeeCode(json.getString("code"));
                    }
                }
                if (entity.getSupplierId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getSupplierId()), "support-supplier");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setSupplierCode(json.getString("code"));
                    }
                }
                if (entity.getOrgId() != null) {
                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(entity.getOrgId()), "idm-org");
                    if (jArray != null && jArray.size() > 0) {
                        JSONObject json = (JSONObject) jArray.get(0);
                        entity.setOrgCode(json.getString("code"));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success("查询租赁合同结算详情数据成功！", entity);
    }


}
