/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller.openapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IRentSettlementDetailService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/equipment"})
public class EquipmentOpenApi {
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;

    @PostMapping(value={"/queryRentSettlementPage"})
    public CommonResponse<IPage<RentSettlementEntity>> queryRentSettlementPage(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.rentSettlementService.queryPage(param, false);
        for (RentSettlementEntity entity : page.getRecords()) {
            try {
                JSONObject json;
                JSONArray jArray;
                if (entity.getContractId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getContractId()), (String)"equipment-rent-contract")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setContractCode(json.getString("code"));
                }
                if (entity.getProjectId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getProjectId()), (String)"market-project")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setProjectCode(json.getString("code"));
                }
                if (entity.getEmployeeId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getEmployeeId()), (String)"idm-user")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setEmployeeCode(json.getString("code"));
                }
                if (entity.getSupplierId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getSupplierId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setSupplierCode(json.getString("code"));
                }
                if (entity.getOrgId() == null || (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getOrgId()), (String)"idm-org")) == null || jArray.size() <= 0) continue;
                json = (JSONObject)jArray.get(0);
                entity.setOrgCode(json.getString("code"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/queryRentSettlementDetail"})
    public CommonResponse<RentSettlementEntity> queryRentSettlementDetail(Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.rentSettlementService.selectById(id));
        if (entity != null) {
            try {
                JSONObject json;
                JSONArray jArray;
                if (entity.getContractId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getContractId()), (String)"equipment-rent-contract")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setContractCode(json.getString("code"));
                }
                if (entity.getProjectId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getProjectId()), (String)"market-project")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setProjectCode(json.getString("code"));
                }
                if (entity.getEmployeeId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getEmployeeId()), (String)"idm-user")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setEmployeeCode(json.getString("code"));
                }
                if (entity.getSupplierId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getSupplierId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setSupplierCode(json.getString("code"));
                }
                if (entity.getOrgId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(entity.getOrgId()), (String)"idm-org")) != null && jArray.size() > 0) {
                    json = (JSONObject)jArray.get(0);
                    entity.setOrgCode(json.getString("code"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)entity));
    }
}

