package com.ejianc.foundation.file.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import io.minio.MinioClient;

@Configuration
@ConfigurationProperties(prefix = "ejc.minio")
public class MinioConfiguration {

	public static Logger logger = LoggerFactory.getLogger(MinioConfiguration.class);

	private String endPoint; // 服务端点

	private String accessKey;

	private String secretAccessKey;

	private String bucketName;

	private String blackFileExt;

	// 上传文件大小限制
	private Integer sizeLimit = 1048576000;

	@Bean
	public MinioClient getMinioClient() {
			MinioClient minioClient = MinioClient.builder().endpoint(endPoint).credentials(accessKey, secretAccessKey).build();
			return minioClient;
	}

	@Bean(name = "multipartResolver")
	public CommonsMultipartResolver getCommonsMultipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxInMemorySize(1048576);
		return multipartResolver;
	}

	public String getEndPoint() {
		return endPoint;
	}

	public void setEndPoint(String endPoint) {
		this.endPoint = endPoint;
	}

	public String getAccessKey() {
		return accessKey;
	}

	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}

	public String getSecretAccessKey() {
		return secretAccessKey;
	}

	public void setSecretAccessKey(String secretAccessKey) {
		this.secretAccessKey = secretAccessKey;
	}

	public String getBucketName() {
		return bucketName;
	}

	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}

	public String getBlackFileExt() {
		return blackFileExt;
	}

	public void setBlackFileExt(String blackFileExt) {
		this.blackFileExt = blackFileExt;
	}

	public Integer getSizeLimit() {
		return sizeLimit;
	}

	public void setSizeLimit(Integer sizeLimit) {
		this.sizeLimit = sizeLimit;
	}

}
