package com.ejianc.foundation.file.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.foundation.file.config.MinioCommonConts;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.bean.MyFavoriteEntity;
import com.ejianc.foundation.file.bean.NetStoreCategoryEntity;
import com.ejianc.foundation.file.bean.ViewLogEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.service.IMyFavoriteService;
import com.ejianc.foundation.file.service.INetStoreCategoryService;
import com.ejianc.foundation.file.service.IViewLogService;
import com.ejianc.foundation.file.util.FolderParam;
import com.ejianc.foundation.file.util.NetStoreAsTree;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;

@Controller
@RequestMapping("netstore")
public class NetStoreController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Value("${common.env.base-host}")
	private String baseHost;
	
	@Autowired
	private INetStoreCategoryService netStoreCategoryService;
	@Autowired
	private IModuleApi moduleApi;
	@Autowired
	private IAttachmentService attachmentService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Autowired
	private MinioClient minioClient;
	@Autowired
	private IEmployeeApi employeeApi;
	@Autowired
	private IMyFavoriteService myFavoriteService;
	@Autowired
	private IViewLogService viewLogService;

	@RequestMapping(value = "/folders", method = RequestMethod.GET)
	@ResponseBody
	public List<FolderParam> folders() {
		CommonResponse<List<ModuleVO>> moduleResponse = moduleApi.queryModuleTree();
		List<FolderParam> folderParams = new ArrayList<FolderParam>();
		if(moduleResponse.isSuccess()) {
			List<ModuleVO> moduleVoList = moduleResponse.getData();
			List<FolderParam> moduleParams = NetStoreAsTree.createModuleTreeDataVO(moduleVoList);
			
			FolderParam folderParam = new FolderParam();
			folderParam.setId(20230109L);
			folderParam.setType("folder");
			folderParam.setValue("业务文档");
			folderParam.setLabel(2);
			folderParam.setData(moduleParams);
			
			folderParams.add(folderParam);
		}
		
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<NetStoreCategoryEntity> categoryEntities = netStoreCategoryService.queryStoreCategoryList(tenantId);
		List<FolderParam> storeCategories = NetStoreAsTree.createTreeDataVO(categoryEntities);
		if(storeCategories != null && storeCategories.size() > 0) {
			folderParams.addAll(storeCategories);
		}
		return folderParams;
	}
	
	@RequestMapping(value = "/makedir", method = RequestMethod.POST)
	@ResponseBody
	public FolderParam makedir(@RequestParam(value = "id") String id, @RequestParam(value="name") String name) {
		NetStoreCategoryEntity categoryEntity = new NetStoreCategoryEntity();
		Long pkId = IdWorker.getId();
		categoryEntity.setId(pkId);
		categoryEntity.setCategoryName(name);
		if("/".equals(id)) {
			categoryEntity.setInnerCode(pkId+"");
		}else{
			categoryEntity.setParentId(Long.parseLong(id));
			
			NetStoreCategoryEntity parentBean = netStoreCategoryService.getById(id);
			categoryEntity.setInnerCode(parentBean.getInnerCode()+"|"+pkId);
		}
		categoryEntity.setCreateTime(new Date());
		netStoreCategoryService.save(categoryEntity);
		
		FolderParam folderParam = new FolderParam();
		folderParam.setId(pkId);
		folderParam.setParentId(categoryEntity.getParentId());
		folderParam.setType("folder");
		folderParam.setValue(name);
		folderParam.setLabel(1);
		return folderParam;
	}
	
	@RequestMapping(value = "/rename", method = RequestMethod.POST)
	@ResponseBody
	public FolderParam rename(@RequestParam(value = "id") String id, @RequestParam(value="name") String name) {
		NetStoreCategoryEntity categoryEntity = netStoreCategoryService.getById(id);
		FolderParam folderParam = new FolderParam();
		if(categoryEntity != null) {
			categoryEntity.setCategoryName(name);
			netStoreCategoryService.saveOrUpdate(categoryEntity);
			
			folderParam.setId(categoryEntity.getId());
			folderParam.setParentId(categoryEntity.getParentId());
			folderParam.setType("folder");
			folderParam.setValue(name);
			folderParam.setLabel(1);
		}else{
			AttachmentEntity attachmentEntity = attachmentService.getById(id);
			String suffix = attachmentEntity.getFileName().substring(attachmentEntity.getFileName().lastIndexOf("."));
			if(StringUtils.isNotBlank(name)) {
				if(name.lastIndexOf(".") != -1) {
					name = name.substring(0, name.lastIndexOf("."))+suffix;
				}else{
					name = name+suffix;
				}
				attachmentEntity.setFileName(name);
				attachmentService.updateById(attachmentEntity);
			}
			
			folderParam.setId(attachmentEntity.getId());
			folderParam.setType("file");
			folderParam.setValue(attachmentEntity.getFileName());
			folderParam.setLabel(1);
		}
		return folderParam;
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public boolean delete(@RequestParam(value = "id") String id) {
		NetStoreCategoryEntity categoryEntity = netStoreCategoryService.getById(id);
		if(categoryEntity != null) {
			QueryWrapper<NetStoreCategoryEntity> categoryWrapper = new QueryWrapper<>();
			categoryWrapper.eq("parent_id", categoryEntity.getId());
			List<NetStoreCategoryEntity> childrenCategory = netStoreCategoryService.list(categoryWrapper);
			if(childrenCategory != null && childrenCategory.size() > 0) {
				return false;
			}else{
				QueryWrapper<AttachmentEntity> attachWrapper = new QueryWrapper<>();
				attachWrapper.eq("bill_type", id);
				List<AttachmentEntity> attachList = attachmentService.list(attachWrapper);
				if(attachList != null && attachList.size() > 0) {
					return false;
				}else{
					netStoreCategoryService.removeById(id);
					return true;
				}
			}
		}else{
			attachmentService.removeById(id);
			return true;
		}
	}
	
	@RequestMapping(value = "/files", method = RequestMethod.GET)
	@ResponseBody
	public List<FolderParam> files(@RequestParam(required = false,value = "id") String id,
			@RequestParam(required = false,value = "source") String source,
			@RequestParam(required = false,value = "search") String search) {
		
		List<FolderParam> folderParams = new ArrayList<FolderParam>();
		if(StringUtils.isNotBlank(search)) {
			Long tenantId = InvocationInfoProxy.getTenantid();
			List<AttachmentVO> attachmentVos = attachmentService.queryListByBillType(null, tenantId, search);
			if(attachmentVos != null && attachmentVos.size() > 0) {
				for(AttachmentVO attachmentVo:attachmentVos) {
					FolderParam folderParam = new FolderParam();
					folderParam.setId(attachmentVo.getId());
					folderParam.setValue(attachmentVo.getFileName());
					folderParam.setFileId(attachmentVo.getId());
					String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+attachmentVo.getId();
					folderParam.setFilePath(filePath);
					folderParam.setSize(attachmentVo.getFileSize());
					folderParam.setLabel(1);
					folderParam.setQueryFrom("recent");
					folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVo.getCreateTime()));
					String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".")+1);
					folderParam.setType(getType(fileType));
					folderParam.setStar(attachmentVo.getStar());
					folderParams.add(folderParam);
				}
			}
		}else{
			if(("/".equals(id) && "favorite".equals(source)) || "favorite".equals(id)) { //收藏夹
				//查询收藏的文件夹
				String userCode = InvocationInfoProxy.getUsercode();
				List<AttachmentVO> attachmentList = attachmentService.queryMyFavoriteList(userCode, null);
				if(attachmentList != null && attachmentList.size() > 0) {
					for(AttachmentVO attachmentVo:attachmentList) {
						FolderParam folderParam = new FolderParam();
						folderParam.setId(attachmentVo.getId());
						folderParam.setValue(attachmentVo.getFileName());
						folderParam.setFileId(attachmentVo.getId());
						String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+attachmentVo.getId();
						folderParam.setFilePath(filePath);
						folderParam.setSize(attachmentVo.getFileSize());
						folderParam.setLabel(1);
						folderParam.setQueryFrom("favorite");
						folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVo.getCreateTime()));
						String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".")+1);
						folderParam.setType(getType(fileType));
						folderParam.setStar(attachmentVo.getStar());
						folderParams.add(folderParam);
					}
				}
			}else if(("/".equals(id) && "recent".equals(source)) || "recent".equals(id)){ //浏览历史
				String userCode = InvocationInfoProxy.getUsercode();
				List<AttachmentVO> attachmentList = attachmentService.queryRecentList(userCode, null);
				if(attachmentList != null && attachmentList.size() > 0) {
					for(AttachmentVO attachmentVo:attachmentList) {
						FolderParam folderParam = new FolderParam();
						folderParam.setId(attachmentVo.getId());
						folderParam.setValue(attachmentVo.getFileName());
						folderParam.setFileId(attachmentVo.getId());
						String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+attachmentVo.getId();
						folderParam.setFilePath(filePath);
						folderParam.setSize(attachmentVo.getFileSize());
						folderParam.setLabel(1);
						folderParam.setQueryFrom("recent");
						folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVo.getCreateTime()));
						String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".")+1);
						folderParam.setType(getType(fileType));
						folderParam.setStar(attachmentVo.getStar());
						folderParams.add(folderParam);
					}
				}
			}else if("/".equals(id)){ //根目录
				CommonResponse<List<ModuleVO>> moduleResponse = moduleApi.queryModuleTree();
				if(moduleResponse.isSuccess()) {
					List<ModuleVO> moduleVoList = moduleResponse.getData();
					List<FolderParam> moduleParams = NetStoreAsTree.createModuleTreeDataVO(moduleVoList);
					
					FolderParam folderParam = new FolderParam();
					folderParam.setId(20230109L);
					folderParam.setType("folder");
					folderParam.setValue("业务文档");
					folderParam.setLabel(2);
					folderParam.setData(moduleParams);
					
					folderParams.add(folderParam);
				}
				
				Long tenantId = InvocationInfoProxy.getTenantid();
				List<NetStoreCategoryEntity> categoryEntities = netStoreCategoryService.queryStoreCategoryList(tenantId);
				List<FolderParam> storeCategories = NetStoreAsTree.createTreeDataVO(categoryEntities);
				if(storeCategories != null && storeCategories.size() > 0) {
					folderParams.addAll(storeCategories);
				}
			}else{
				if("20230109".equals(id)) {
					CommonResponse<List<ModuleVO>> moduleResponse = moduleApi.queryAllTopModuleList();
					if(moduleResponse.isSuccess()) {
						List<ModuleVO> moduleVoList = moduleResponse.getData();
						if(moduleVoList != null && moduleVoList.size() > 0) {
							for(ModuleVO moduleVo:moduleVoList) {
								FolderParam folderParam = new FolderParam();
								folderParam.setId(moduleVo.getId());
								folderParam.setType("folder");
								folderParam.setValue(moduleVo.getModuleName());
								folderParam.setLabel(2);
								folderParams.add(folderParam);
							}
						}
					}
				}else{
					NetStoreCategoryEntity categoryEntity = netStoreCategoryService.getById(id);
					if(categoryEntity != null) { //企业文档
						QueryWrapper<NetStoreCategoryEntity> categoryWrapper = new QueryWrapper<>();
						categoryWrapper.eq("parent_id", categoryEntity.getId());
						List<NetStoreCategoryEntity> childCategoryList = netStoreCategoryService.list(categoryWrapper);
						if(childCategoryList != null && childCategoryList.size() > 0) {
							for(NetStoreCategoryEntity entity:childCategoryList) {
								FolderParam folderParam = new FolderParam();
								folderParam.setId(entity.getId());
								folderParam.setParentId(entity.getParentId());
								folderParam.setType("folder");
								folderParam.setValue(entity.getCategoryName());
								folderParam.setLabel(1);
								folderParams.add(folderParam);
							}
						}
						
						Long tenantId = InvocationInfoProxy.getTenantid();
						List<AttachmentVO> attachmentVos = attachmentService.queryListByBillType(id, tenantId, null);
						if(attachmentVos != null && attachmentVos.size() > 0) {
							for(AttachmentVO attachmentVo:attachmentVos) {
								FolderParam folderParam = new FolderParam();
								folderParam.setId(attachmentVo.getId());
								folderParam.setValue(attachmentVo.getFileName());
								folderParam.setFileId(attachmentVo.getId());
								String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+attachmentVo.getId();
								folderParam.setFilePath(filePath);
								folderParam.setSize(Long.parseLong(attachmentVo.getFileSize()+""));
								folderParam.setLabel(1);
								folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVo.getCreateTime()));
								String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".")+1);
								folderParam.setType(getType(fileType));
								folderParam.setStar(attachmentVo.getStar());
								folderParams.add(folderParam);
							}
						}
					}else{ //业务文档
						CommonResponse<ModuleVO> moduleResponse = moduleApi.getModuleById(Long.parseLong(id));
						if(moduleResponse.isSuccess()) {
							ModuleVO moduleVo = moduleResponse.getData();
							if(moduleVo != null && moduleVo.getId() != null) { // 所属模块，不需要查询文件
								CommonResponse<List<ModuleVO>> childModuleResponse = moduleApi.queryModuleListByPid(moduleVo.getId());
								if(childModuleResponse.isSuccess()) {
									List<ModuleVO> moduleList = childModuleResponse.getData();
									if(moduleList != null && moduleList.size() > 0) {
										for(ModuleVO childModule:moduleList) {
											if(moduleVo.getId().equals(childModule.getId())) {
												continue;
											}
											FolderParam folderParam = new FolderParam();
											folderParam.setId(childModule.getId());
											folderParam.setParentId(childModule.getParentId());
											folderParam.setType("folder");
											folderParam.setValue(childModule.getModuleName());
											folderParam.setLabel(2);
											folderParams.add(folderParam);
										}
									}
								}
								
								CommonResponse<List<BillTypeVO>> billTypeResponse = billTypeApi.queryBillTypeByModuleId(moduleVo.getId());
								if(billTypeResponse.isSuccess()) {
									List<BillTypeVO> billTypeVoList = billTypeResponse.getData();
									if(billTypeVoList != null && billTypeVoList.size() > 0) {
										for(BillTypeVO billTypeVo:billTypeVoList) {
											FolderParam folderParam = new FolderParam();
											folderParam.setId(billTypeVo.getId());
											folderParam.setParentId(billTypeVo.getModuleId());
											folderParam.setType("folder");
											folderParam.setValue(billTypeVo.getBillName());
											folderParam.setLabel(2);
											folderParams.add(folderParam);
										}
									}
								}
							}else{
								CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getById(Long.parseLong(id));
								if(billTypeResponse.isSuccess()) {
									BillTypeVO billTypeVo = billTypeResponse.getData();
									if(billTypeVo != null) {
										Long tenantId = InvocationInfoProxy.getTenantid();
										List<AttachmentVO> attachmentVos = attachmentService.queryListByBillType(billTypeVo.getBillCode(), tenantId, null);
										if(attachmentVos != null && attachmentVos.size() > 0) {
											for(AttachmentVO attachmentVo:attachmentVos) {
												FolderParam folderParam = new FolderParam();
												folderParam.setId(attachmentVo.getId());
												folderParam.setValue(attachmentVo.getFileName());
												folderParam.setFileId(attachmentVo.getId());
												String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+attachmentVo.getId();
												folderParam.setFilePath(filePath);
												folderParam.setSize(Long.parseLong(attachmentVo.getFileSize()+""));
												folderParam.setLabel(2);
												folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",attachmentVo.getCreateTime()));
												String fileType = attachmentVo.getFileName().substring(attachmentVo.getFileName().lastIndexOf(".")+1);
												folderParam.setType(getType(fileType));
												folderParam.setStar(attachmentVo.getStar());
												folderParams.add(folderParam);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return folderParams;
	}
	
	@RequestMapping(value = "info",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject info(){
		JSONObject info = new JSONObject();
		JSONObject features = new JSONObject();
		JSONObject meta = new JSONObject();
		meta.putIfAbsent("audio",true);
		meta.putIfAbsent("image",true);
		features.putIfAbsent("meta",meta);
		JSONObject preview = new JSONObject();
		preview.putIfAbsent("code",true);
		preview.putIfAbsent("document",true);
		preview.putIfAbsent("image",true);
		features.putIfAbsent("preview",preview);
		info.putIfAbsent("features",features);
		return info;
	}
	
	@RequestMapping(value = "meta",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject meta(@RequestParam("id") String id){
		AttachmentEntity attachmentEntity = attachmentService.getById(id);
		JSONObject info = new JSONObject();
		info.putIfAbsent("创建人",attachmentEntity.getCreateUserCode());
		info.putIfAbsent("创建时间",attachmentEntity.getCreateTime());
		return info;
	}
	
	@RequestMapping(value = "comments",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray comments(@RequestParam("id") String id){
		return new JSONArray();
	}

	@RequestMapping(value = "tags",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray tags(@RequestParam("id") String id){
		return new JSONArray();
	}
	
	@RequestMapping(value = "upload",method = RequestMethod.POST)
	@ResponseBody
	public FolderParam upload(@RequestParam("id") String id, HttpServletRequest request) {
		FolderParam folderParam = new FolderParam();
		String billType = id;
		String sourceId = id;
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		// 文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		// 文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if (mf.getSize() > sizeLimit) {
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		InputStream mfInputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				String bucketName = minioConfiguration.getBucketName();
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				
				mfInputStream = mf.getInputStream();
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if (StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType("netstore");
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					Long userId = InvocationInfoProxy.getUserid();
					CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
					if (employeeResponse.isSuccess()) {
						attachment.setUploadUserName(employeeResponse.getData().getName());
					}
					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					attachmentService.saveOrUpdate(entity, false);
					resultEntity.add(entity);
					
					folderParam.setId(entity.getId());
					folderParam.setValue(entity.getFileName());
					folderParam.setFileId(entity.getId());
					String filePath = baseHost + "ejc-file-web/attachment/no_auth/download?fileId="+entity.getId();
					folderParam.setFilePath(filePath);
					folderParam.setSize(Long.parseLong(entity.getFileSize()+""));
					folderParam.setDate(DateFormatUtil.formatDate("yyyy-MM-dd hh:mm:ss",entity.getCreateTime()));
					String fileType = entity.getFileName().substring(entity.getFileName().lastIndexOf(".")+1);
					folderParam.setType(getType(fileType));
					
					return folderParam;
				}
				
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}finally {
			if(mfInputStream != null) {
				try {
					mfInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return null;
	}
	
	@RequestMapping(value = "favorite",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject AddFavorite(@RequestParam("id") String id,@RequestParam("type") String type){
		QueryWrapper<MyFavoriteEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("file_id", id);
		queryWrapper.eq("create_user_code", InvocationInfoProxy.getUsercode());
		List<MyFavoriteEntity> myFavoriteEntities = myFavoriteService.list(queryWrapper);
		if(myFavoriteEntities != null && myFavoriteEntities.size() > 0) {
			JSONObject jsonObject = new JSONObject();
			jsonObject.putIfAbsent("id",id);
			jsonObject.putIfAbsent("error","");
			jsonObject.putIfAbsent("invalid",false);
			return jsonObject;
		}
		MyFavoriteEntity entity = new MyFavoriteEntity();
		entity.setFileId(Long.parseLong(id));
		entity.setFileType(type);
		myFavoriteService.saveOrUpdate(entity,false);
		JSONObject jsonObject = new JSONObject();
		jsonObject.putIfAbsent("id",id);
		jsonObject.putIfAbsent("error","");
		jsonObject.putIfAbsent("invalid",false);
		return jsonObject;
	}

	@RequestMapping(value = "delfavorite",method = RequestMethod.GET)
	@ResponseBody
	public JSONObject delFavorite(@RequestParam("id") String id){
		QueryParam param = new QueryParam();
		param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
		param.getParams().put("fileId",new Parameter(QueryParam.EQ,id));
		List<MyFavoriteEntity> favoriteEntities = myFavoriteService.queryList(param,false);
		if(ListUtil.isNotEmpty(favoriteEntities)){
			favoriteEntities.forEach(f->{
				myFavoriteService.removeById(f.getId());
			});
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.putIfAbsent("id",id);
		jsonObject.putIfAbsent("error","");
		jsonObject.putIfAbsent("invalid",false);
		return jsonObject;
	}
	
	@RequestMapping(value = "addRecent",method = RequestMethod.POST)
	@ResponseBody
	public boolean addRecent(@RequestParam("fileId") String fileId) {
		QueryWrapper<ViewLogEntity> viewLogWrapper = new QueryWrapper<>();
		viewLogWrapper.eq("file_id", fileId);
		viewLogWrapper.eq("create_user_code", InvocationInfoProxy.getUsercode());
		List<ViewLogEntity> viewLogEntities = viewLogService.list(viewLogWrapper);
		if(viewLogEntities != null && viewLogEntities.size() > 0) {
			return true;
		}else{
			ViewLogEntity viewLogEntity = new ViewLogEntity();
			viewLogEntity.setFileId(Long.parseLong(fileId));
			
			AttachmentEntity attachmentEntity = attachmentService.getById(fileId);
			String fileType = attachmentEntity.getFileName().substring(attachmentEntity.getFileName().lastIndexOf(".")+1);
			viewLogEntity.setFileType(getType(fileType));
			
			viewLogService.save(viewLogEntity);
			return true;
		}
	}
	
	@RequestMapping(value = "users/all",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray usersAll(){
		return new JSONArray();
	}

	@RequestMapping(value = "tags/all",method = RequestMethod.GET)
	@ResponseBody
	public JSONArray tagsAll(){
		return new JSONArray();
	}
	
	private boolean fileExtInBlackList(String fileExt) {
		String blackFileExt = minioConfiguration.getBlackFileExt();
		if (StringUtils.isNotEmpty(blackFileExt) && fileExt != null) {
			String[] blackFileExtArr = blackFileExt.split(",");
			for (String blackExt : blackFileExtArr) {
				if (fileExt.equals(blackExt)) {
					return true;
				}
			}
		}
		return false;
	}
	
	private String getType(String fileName){
		String type ;
		if("txt".equals(fileName.toLowerCase())){
			type = "code";
		}else if("xls".equals(fileName.toLowerCase()) ||
				"xlsx".equals(fileName.toLowerCase()) ||
				"bat".equals(fileName.toLowerCase()) ||
				"doc".equals(fileName.toLowerCase())  ||
				"docx".equals(fileName.toLowerCase()) ||
				"zip".equals(fileName.toLowerCase()) ||
				"csv".equals(fileName.toLowerCase())  ||
				"exe".equals(fileName.toLowerCase())  ||
				"jar".equals(fileName.toLowerCase())  ||
				"log".equals(fileName.toLowerCase())  ||
				"msi".equals(fileName.toLowerCase())  ||
				"iso".equals(fileName.toLowerCase())  ||
				"pdf".equals(fileName.toLowerCase())  ||
				"rar".equals(fileName.toLowerCase())  ||
				"swf".equals(fileName.toLowerCase())  ||
				"ppt".equals(fileName.toLowerCase())  ||
				"pptx".equals(fileName.toLowerCase())
		){
			type = "document";
		}else if(
				"mp3".equals(fileName.toLowerCase()) ||
				"wma".equals(fileName.toLowerCase())  ||
				"aac".equals(fileName.toLowerCase())
		){
			type = "audio";
		}else if(
				"3gp".equals(fileName.toLowerCase()) ||
				"mp4".equals(fileName.toLowerCase()) ||
				"avi".equals(fileName.toLowerCase()) ||
				"mkv".equals(fileName.toLowerCase())  ||
				"rm".equals(fileName.toLowerCase())  ||
				"rmvb".equals(fileName.toLowerCase())  ||
				"mov".equals(fileName.toLowerCase())  ||
				"mod".equals(fileName.toLowerCase())  ||
				"wmv".equals(fileName.toLowerCase())  ||
				"ogg".equals(fileName.toLowerCase())
		){
			type = "video";
		}else if(
				"jpg".equals(fileName.toLowerCase()) ||
				"png".equals(fileName.toLowerCase()) ||
				"gif".equals(fileName.toLowerCase()) ||
				"jpeg".equals(fileName.toLowerCase())||
				"bmp".equals(fileName.toLowerCase())
		){
			type = "image";
		}else {
			type = "unknown";
		}
		return type;
	}
}
