package com.ejianc.foundation.file.controller;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.service.FilePreviewFactory;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;


@Controller
public class OnlinePreviewController {

    @Autowired
    FilePreviewFactory previewFactory;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    FileUtils fileUtils;
    @Value("${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value = "onlinePreview", method = RequestMethod.GET)
    public String onlinePreview(String fileId, Model model, HttpServletRequest req) {
    	AttachmentVO attachmentVo = attachmentService.selectById(fileId);
    	if(attachmentVo != null) {
    		FilePreview filePreview = previewFactory.get(attachmentVo.getFilePath());
    		String fileExt = null;
    		try {
    			fileExt = filePreview.filePreviewHandle(req,attachmentVo, model);
    		}catch(Exception e) {
    			return "fileNotSupported";
    		}
    		return fileExt;
    	} else {
    		return "fileNotSupported";
    	}
    }

    /**
     * 支持上下切换的图片预览
     *
     * @param sourceId
     * @param billType
     * @param sourceType
     * @param orderType
     * @param fileId 当前图片Id，缺省则取图片列表第一个
     * @param fileIdsStr 查询的文件Id列表,多个以逗号分隔, 传递该参数时
     * @param model
     * @return
     */
    @GetMapping(value = "imgsOnlinePreview")
    public String imgsOnlinePreview(@RequestParam(name = "sourceId", required = false) Long sourceId,
                                    @RequestParam(name = "billType", required = false) String billType,
                                    @RequestParam(name = "sourceType", required = false) String sourceType,
                                    @RequestParam(name = "orderType", required = false) String orderType,
                                    @RequestParam(name = "fileId", required = false) Long fileId,
                                    @RequestParam(name = "fileIdsStr", required = false) String fileIdsStr,
                                    Model model) {
        QueryParam queryParam = new QueryParam();
        AttachmentVO curImageFile = null;
        if(StringUtils.isBlank(orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        Map<String, Parameter> params = queryParam.getParams();
        if(null != sourceId ) {
            params.put("sourceId", new Parameter("eq",sourceId));
        }
        if(StringUtils.isNotBlank(fileIdsStr)) {
            params.put("id", new Parameter(QueryParam.IN, Arrays.asList(fileIdsStr.split(","))));
        }
        if(StringUtils.isNotBlank(sourceType)){
            params.put("sourceType", new Parameter("eq",sourceType));
        }
        if(StringUtils.isNotBlank(billType)){
            params.put("billType", new Parameter("eq",billType));
        }
        List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);

        if(CollectionUtils.isEmpty(list)) {
            model.addAttribute("backMsg", "没有发现可预览的图片.");
            return "fileNotSupported";
        } else {
            List<String> imgUrls = new ArrayList<>();
            for(AttachmentVO attach : list) {
            	imgUrls.add(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + attach.getFilePath());
                if((null != fileId) && (fileId.longValue() == attach.getId().longValue())) {
                    curImageFile = attach;
                }
            }
            if(null == curImageFile) {
                curImageFile = list.get(0);
            }
            model.addAttribute("imgurls", imgUrls);
            String imageFilePath = curImageFile.getFilePath();
            if(StringUtils.isNotBlank(imageFilePath) && imageFilePath.indexOf("http") == -1) {
            	imageFilePath = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + imageFilePath;
			}
            model.addAttribute("currentUrl", imageFilePath);
            return "picture";
        }
    }


    @RequestMapping(value = "/getCorsFile", method = RequestMethod.GET)
    public void getCorsFile(String urlPath,String OSSAccessKeyId,String Signature, HttpServletResponse resp) {
    	BufferedInputStream inputStream = null;
        OutputStream outputStream = null;
        
        CloseableHttpResponse httpResponse = null;
        try {
        	String strUrl = urlPath = URLDecoder.decode(URLDecoder.decode(urlPath, "utf-8"), "utf-8");
            CloseableHttpClient client = HttpTookit.client;
            URIBuilder urlBuilder = new URIBuilder(strUrl);
            HttpGet httpGet = new HttpGet(urlBuilder.build());
            httpResponse = client.execute(httpGet);
            int status = httpResponse.getStatusLine().getStatusCode();
            if(200 == status) {
            	inputStream = new BufferedInputStream(httpResponse.getEntity().getContent());
            	outputStream = resp.getOutputStream();
            	IOUtils.copy(inputStream, outputStream);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
        	if(httpResponse!=null){
				try { 
					httpResponse.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
        	if (outputStream != null) {
				try {
					outputStream.flush();
					outputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
        }
    }
    
}
