package com.ejianc.foundation.file.define;

import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

import java.io.*;

public class BASE64MultipartFile implements MultipartFile {
    private final byte[] imgContent;
    private final String header;
    private final String name;


    public BASE64MultipartFile(String fileStr) throws IOException {
        String[] baseStrs = fileStr.split(",");
        String base64 = baseStrs[1].split("&")[0];
        String name = baseStrs[1].split("&")[1];
        BASE64Decoder decoder = new BASE64Decoder();
        byte[]  b = decoder.decodeBuffer(base64);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 0) {
                b[i] += 256;
            }
        }
        this.imgContent = b;
        this.header = baseStrs[0];
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalFilename() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return header.split(":")[1];
    }

    @Override
    public boolean isEmpty() {
        return imgContent == null || imgContent.length == 0;
    }

    @Override
    public long getSize() {
        return imgContent.length;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return imgContent;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(imgContent);
    }

    @Override
    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(imgContent);
    }
}
