package com.ejianc.foundation.file.service.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.foundation.file.config.MinioCommonConts;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

import com.aspose.cells.License;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.Workbook;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.support.idworker.util.IdWorker;

import io.minio.MinioClient;
import io.minio.PutObjectArgs;

@Service
public class PoiExcelToHtmlImpl implements FilePreview {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	FileUtils fileUtils;
	@Autowired
	private AttachmentMapper attachmentMapper;
	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Value("${common.env.base-host}")
	private String baseHost;

	@Override
	public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
		FileAttribute fileAttribute = fileUtils.getFileAttribute(attach.getFilePath());
		String fileName = fileAttribute.getName();
		String newFileSuffix = "pdf";
		String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
		String newUrl = "";
		try {
			if (StringUtils.isNotBlank(attach.getOnlinePath())) {
				if (attach.getOnlinePath().indexOf("http") != -1) {
					newUrl = attach.getOnlinePath() + "?attachid="+attach.getId();
				} else {
					newUrl = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + attach.getOnlinePath();
				}
			} else {
				InputStream in = null;
				BufferedInputStream bufferedInputStream = null;
				ByteArrayOutputStream bos = null;
				ByteArrayInputStream bis = null;
				InputStream fileInputStream = null;
				try {
					bos = new ByteArrayOutputStream();
					if(attach.getFilePath().contains("http")) {
						// 从远程URL下载文件
						URL url = new URL(attach.getFilePath());
						in = url.openStream(); // 打开输入流
					}else {
						in = fileUtils.downloadFileByKeyName(attach.getFilePath());
					}
					bufferedInputStream = new BufferedInputStream(in);
					
					boolean auth = authrolizeLicense();
	    		    if (!auth) {
	    		        System.out.println("aspose 许可无效！");
	    		    }
	    		    Workbook workbook = new Workbook(bufferedInputStream);
	    		    
	    		    PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
	    		    //pdfSaveOptions.setOnePagePerSheet(true);//把内容放在一张PDF页面上；
	                pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
	                workbook.acceptAllRevisions();
	    			workbook.save(bos, pdfSaveOptions);
					bis = new ByteArrayInputStream(bos.toByteArray());
					MultipartFile multipartFile = new MockMultipartFile(pdfName, bis);
					SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
					String objectName = attach.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + newFileSuffix;
					
					fileInputStream = multipartFile.getInputStream();
					minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(fileInputStream, fileInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
					attachmentMapper.updateOnlinePath(attach.getFilePath(), objectName);
					
					newUrl = baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName;
					if (StringUtils.isBlank(newUrl)) {
						return "fileNotSupported";
					}
				} catch (Exception e) {
					logger.info("文件转换失败："+e.getMessage());
    				return "fileNotSupported";
				} finally {
					if (in != null) {
						in.close();
					}
					if (bufferedInputStream != null) {
						bufferedInputStream.close();
					}
					if (bos != null) {
						bos.flush();
						bos.close();
					}
					if (bis != null) {
						bis.close();
					}
					if(fileInputStream != null) {
						fileInputStream.close();
					}
				}
			}
			model.addAttribute("pdfUrl", newUrl);
		} catch (Exception e) {
			logger.info("文件转换失败："+e.getMessage());
			return "fileNotSupported";
		}

		return "mobilepdf";
	}

	public static boolean authrolizeLicense() {
		boolean result = false;
		try {
			InputStream is = com.aspose.cells.License.class.getResourceAsStream("/com.aspose.cells.lic_2999.xml");
			License asposeLicense = new License();
			asposeLicense.setLicense(is);
			is.close();
			result = true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

}
