package com.ejianc.foundation.file.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 附件
 * 
 * @author guominga
 *
 */
@TableName("ejc_attachment")
public class AttachmentEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "bill_type")
	private String billType; // 业务类型

	@TableField(value = "source_id")
	private Long sourceId; // 对应业务ID

	@TableField(value = "source_type")
	private String sourceType; // 对应单据的类型

	@TableField(value = "file_name")
	private String fileName; // 文件名称

	@TableField(value = "file_path")
	private String filePath; // 文件路径

	@TableField(value = "file_size")
	private Integer fileSize; // 文件大小

	@TableField(value = "online_path")
	private String onlinePath;// 预览地址

	@TableField(value = "upload_user_name")
	private String uploadUserName;// 上传人

	@TableField(value = "mark")
	private String mark;// 文件标签内容

	/**
	 * 图片文件格式处理后的访问路径
	 */
	@TableField(value = "file_format_path")
	private String fileFormatPathStr;

	/**
	 * 归档状态：0-未归档，1-已归档
	 */
	@TableField(value = "archive_status")
	private String archiveStatus;

	/**
	 * 文件扩展css
	 */
	@TableField(value = "ext_css")
	private String extCss;

	@TableField(value = "org_id")
	private Long orgId; // 组织ID

	public String getArchiveStatus() {
		return archiveStatus;
	}

	public void setArchiveStatus(String archiveStatus) {
		this.archiveStatus = archiveStatus;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public Integer getFileSize() {
		return fileSize;
	}

	public void setFileSize(Integer fileSize) {
		this.fileSize = fileSize;
	}

	public String getOnlinePath() {
		return onlinePath;
	}

	public void setOnlinePath(String onlinePath) {
		this.onlinePath = onlinePath;
	}

	public String getUploadUserName() {
		return uploadUserName;
	}

	public void setUploadUserName(String uploadUserName) {
		this.uploadUserName = uploadUserName;
	}

	public String getFileFormatPathStr() {
		return fileFormatPathStr;
	}

	public void setFileFormatPathStr(String fileFormatPathStr) {
		this.fileFormatPathStr = fileFormatPathStr;
	}

	public String getExtCss() {
		return extCss;
	}

	public void setExtCss(String extCss) {
		this.extCss = extCss;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getMark() {
		return mark;
	}

	public void setMark(String mark) {
		this.mark = mark;
	}
}
