package com.ejianc.foundation.file.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.file.config.MinioCommonConts;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.SaveFormat;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BASE64MultipartFile;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.service.impl.PoiExcelToHtmlImpl;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.util.MyX509TrustManager;
import com.ejianc.foundation.file.util.OfficeToPdf;
import com.ejianc.foundation.file.util.ZipCompress;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;

/**
 * 附件controller
 * 
 * @author guominga
 *
 */
@Controller
@RequestMapping("attachment")
public class AttachmentController {
	private static Logger logger = LoggerFactory.getLogger(AttachmentController.class);

	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Autowired
	private IAttachmentService attachmentService;
	@Autowired
	private IEmployeeApi employeeApi;
	@Autowired
	private FileUtils fileUtils;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private OfficeToPdf officeToPdf;
	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 根据sourceId查询列表
	 * 
	 * @param sourceId
	 * @param
	 * @return
	 */
	@RequestMapping(value = "queryListBySourceId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryListBySourceId(
			@RequestParam(name = "sourceId", required = false) Long sourceId,
			@RequestParam(name = "billType", required = false) String billType,
			@RequestParam(name = "sourceType", required = false) String sourceType,
			@RequestParam(name = "orderType", required = false) String orderType) {
		JSONObject jsonObject = new JSONObject();
		QueryParam queryParam = new QueryParam();
		if (null == sourceId) {
			jsonObject.put("data", new ArrayList<>());
			return CommonResponse.success("sourceId为空，查询不到匹配的文件信息！", jsonObject);
		}

		if (StringUtils.isBlank(orderType)) {
			orderType = "desc";
		}
		queryParam.getOrderMap().put("createTime", orderType);
		queryParam.getOrderMap().put("id", "desc");
		Map<String, Parameter> params = queryParam.getParams();
		params.put("sourceId", new Parameter("eq", sourceId));
		if (StringUtils.isNotBlank(sourceType)) {
			params.put("sourceType", new Parameter(QueryParam.IN, sourceType));
		}
		if (StringUtils.isNotBlank(billType)) {
			params.put("billType", new Parameter("eq", billType));
		}
		List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);
		setFileTruePath(list);
		jsonObject.put("data", list);
		return CommonResponse.success(jsonObject);
	}

	@SuppressWarnings("unchecked")
	public void setFileTruePath(List<AttachmentVO> list) {
		if (!ListUtil.isEmpty(list)) {
			list.forEach(f -> {
				String filePath = f.getFilePath();
	            if(StringUtils.isNotBlank(filePath) && filePath.indexOf("http") != -1) {
	            	f.setTruePath(filePath);
				}else{
					f.setTruePath(baseHost+"ejc-file-web/attachment/filePreview?fileId="+f.getId());
				}
				if (StringUtils.isNotBlank(f.getFileFormatPathStr())) {
					f.setFileFormatPath((List<Map<String, String>>) JSONArray.parse(f.getFileFormatPathStr()));
				}
				f.setImgServerPath(baseHost + "ejc-file-web/attachment/filePreview?filePath=");
				f.setOnlinePath(baseHost+"ejc-file-web/attachment/filePreview?fileId="+f.getId());
			});
		}
	}

	/**
	 * 根据fileIds查询文件列表
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "getFileListByFileIds", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> getFileListByFileIds(HttpServletRequest request) {
		JSONObject jsonObject = new JSONObject();
		String ids = request.getParameter("ids");
		if (StringUtils.isEmpty(ids)) {
			return CommonResponse.error("查询失败");
		}
		List<AttachmentVO> list = attachmentService.queryListByIds(ids);
		setFileTruePath(list);
		jsonObject.put("data", list);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam(name = "ids") String ids) {
		return attachmentService.delete(ids);
	}

	/**
	 * 获取访问地址
	 * 
	 * @throws UnsupportedEncodingException
	 */
	@RequestMapping(value = "filePreview", method = RequestMethod.GET)
	@ResponseBody
	public void filePreview(@RequestParam(name = "fileId", required = false) String fileId,@RequestParam(name = "thumbnail", required = false) String thumbnail,
			@RequestParam(name = "filePath", required = false) String filePath, HttpServletResponse response)
			throws UnsupportedEncodingException {
		InputStream inputStream = null;
		if (StringUtils.isNotBlank(filePath)) {
			filePath = URLDecoder.decode(filePath, "utf-8");
		} else {
			if (StringUtils.isBlank(fileId)) {
				return;
			}
			AttachmentEntity attachmentVo = attachmentService.getById(fileId);
			if(attachmentVo == null) {
				return;
			}
			if(StringUtils.isNotEmpty(thumbnail)){
				inputStream = attachmentService.getThumbnailPath(attachmentVo);
			}
			filePath = attachmentVo.getFilePath();
		}
		if(inputStream == null){
			inputStream = fileUtils.downloadFileByKeyName(filePath);
		}
		OutputStream os = null;
		try {
			os = response.getOutputStream();
			IOUtils.copy(inputStream, os);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if(inputStream != null) {
					inputStream.close();
				}
				os.flush();
				os.close();
			} catch (IOException e) {}
		}
	}

	private boolean fileExtInBlackList(String fileExt) {
		String blackFileExt = minioConfiguration.getBlackFileExt();
		if (StringUtils.isNotEmpty(blackFileExt) && fileExt != null) {
			String[] blackFileExtArr = blackFileExt.split(",");
			for (String blackExt : blackFileExtArr) {
				if (fileExt.equals(blackExt)) {
					return true;
				}
			}
		}
		return false;
	}

	@RequestMapping(value = "weixinee/upload", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<AttachmentVO> weixinEEUpload(HttpServletRequest request) {
		String mediaId = request.getParameter("mediaId");
		String systemCode = request.getParameter("systemCode");
		String billType = request.getParameter("billType");
		String sourceId = request.getParameter("sourceId");
		String sourceType = request.getParameter("sourceType");
		String mark = request.getParameter("mark");
		String orgIdStr = request.getParameter("orgId");

		SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
		if (StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}

		CommonResponse<ThirdSystemVO> thirdSystemResponse = thirdSystemApi.getOneByCode(systemCode);
		if (thirdSystemResponse.isSuccess()) {
			ThirdSystemVO thirdSystemVo = thirdSystemResponse.getData();
			String configInfo = thirdSystemVo.getConfigInfo();
			JSONObject configJson = JSON.parseObject(configInfo);
			String corpAppId = configJson.getString("corp_appId");
			String corpSecret = configJson.getString("corp_secret");
			String accessToken = getWeixineeAccessToken(corpAppId, corpSecret);
			String weixinurl = "https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=" + accessToken + "&media_id=" + mediaId;

			InputStream inputStream = null;
			HttpsURLConnection conn = null;
			try {
				// 创建SSLContext对象，并使用我们指定的信任管理器初始化
				TrustManager[] tm = { new MyX509TrustManager() };
				SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
				sslContext.init(null, tm, new java.security.SecureRandom());
				// 从上述SSLContext对象中得到SSLSocketFactory对象
				SSLSocketFactory ssf = sslContext.getSocketFactory();

				URL url = new URL(weixinurl);
				conn = (HttpsURLConnection) url.openConnection();
				conn.setSSLSocketFactory(ssf);

				conn.setDoOutput(true);
				conn.setDoInput(true);
				conn.setUseCaches(false);
				// 设置请求方式（GET/POST）
				conn.setRequestMethod("GET");
				// 从输入流读取返回内容
				inputStream = conn.getInputStream();

				String fileName = IdWorker.getId() + ".jpg";
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + fileName;
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(inputStream, inputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if (StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setMark(mark);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(0L);
					Long orgId = null;
					if (StringUtils.isBlank(orgIdStr)) {
						orgId = InvocationInfoProxy.getOrgId();
					} else {
						orgId = Long.parseLong(orgIdStr);
					}
					attachment.setOrgId(orgId);
					Long userId = InvocationInfoProxy.getUserid();
					CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
					if (employeeResponse.isSuccess()) {
						attachment.setUploadUserName(employeeResponse.getData().getName());
					}
					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					attachmentService.saveOrUpdate(entity, false);
					InputStream is = attachmentService.getThumbnailPath(entity);
					if(is!=null){
						try {
							is.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					AttachmentVO attachmentVo = BeanMapper.map(entity, AttachmentVO.class);

					return CommonResponse.success(attachmentVo);
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (inputStream != null) {
					try {
						inputStream.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
				if (conn != null) {
					conn.disconnect();
				}
			}
		}
		return CommonResponse.error("上传失败");
	}

	private String getWeixineeAccessToken(String corpAppId, String corpSecret) {
		String key = corpAppId + "_" + corpSecret;
		String accessToken = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----accessToken=" + accessToken);
		System.out.println("redis----accessToken=" + accessToken);
		if (StringUtils.isBlank(accessToken)) {
			Map<String, String> param = new HashMap<>();
			String accessResult = null;
			param.put("corpid", corpAppId);
			param.put("corpsecret", corpSecret);
			try {
				accessResult = ReferHttpClientUtils.get("https://qyapi.weixin.qq.com/cgi-bin/gettoken", param, new HashMap<>());
			} catch (GeneralSecurityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			logger.info("accessResult=" + accessResult);
			System.out.println("accessResult=" + accessResult);
			if (StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				String errmsg = accessJson.getString("errmsg");
				if ("ok".equals(errmsg) && StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

	@PostMapping(value = "no_auth/upload")
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> uploadNoAuth(HttpServletRequest request) throws Exception {
		String billType = request.getParameter("billType");
		String sourceId = request.getParameter("sourceId");
		String sourceType = request.getParameter("sourceType");
		String mark = request.getParameter("mark");
		String tenantId = request.getParameter("tenantId");
		String userCode = request.getParameter("userCode");
		String orgIdStr = request.getParameter("orgId");
		final String originalFileNameStr = request.getParameter("originalFileName");
		boolean fromWxMiniPm = StringUtils.isNotBlank(request.getParameter("fromWxMiniPm")) ? Boolean.valueOf(request.getParameter("fromWxMiniPm")) : false;
		if (StringUtils.isBlank(billType)) {
			return CommonResponse.error("单据类型编号不能为空！");
		}
		if (StringUtils.isBlank(sourceType)) {
			return CommonResponse.error("业务类型(图片类型)不能为空！");
		}
		if (StringUtils.isBlank(tenantId)) {
			tenantId = "999999";
		}

		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		// 文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		// 文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (originalFilename.indexOf(".") < 0) {
				originalFilename = originalFileNameStr;
			}
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if (mf.getSize() > sizeLimit) {
				logger.error("限定大小为：" + sizeLimit + "，文件大小为：" + mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}
		InputStream mfInputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				if (fileName.indexOf(".") < 0) {
					fileName = originalFileNameStr;
				}
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = tenantId + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				mfInputStream = mf.getInputStream();
				if (fromWxMiniPm) {
					// 微信小程序上传的文件获取的名称不是文件原名且比较长，故覆盖之
					fileName = "WXMiniPm-" + objectName;
				}
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if (StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setMark(mark);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					attachment.setTenantId(Long.valueOf(tenantId));
					attachment.setCreateUserCode(userCode);
					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					attachmentService.saveOrUpdate(entity, false);
					InputStream is = attachmentService.getThumbnailPath(entity);
					if(is!=null){
						try {
							is.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					resultEntity.add(entity);
				}
			}
			List<AttachmentVO> resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
			setFileTruePath(resultList);
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			throw new BusinessException("文件上传失败，Msg：" + ex.getMessage());
		}finally {
			if(mfInputStream != null) {
				mfInputStream.close();
			}
		}
	}
	
	/**
	 * 拷贝附件到业务中
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "copyFileToBusiness", method = RequestMethod.POST)
    @ResponseBody
	public CommonResponse<List<AttachmentVO>> copyFileToBusiness(@RequestBody JSONObject jsonStr) {
		List<AttachmentVO> attachVos = new ArrayList<>();
        String attachIds = jsonStr.getString("attachIds");
        if(StringUtils.isBlank(attachIds)) {
        	return CommonResponse.error("原文件ID不能为空！");
        }
        
        String billType = jsonStr.getString("billType");
		String sourceId = jsonStr.getString("sourceId");
		String sourceType = jsonStr.getString("sourceType");
		
		if(StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}
		
		QueryWrapper<AttachmentEntity> attachWrapper = new QueryWrapper<>();
		attachWrapper.in("id", attachIds);
		List<AttachmentEntity> attachEntities = attachmentService.list(attachWrapper);
		if(attachEntities != null && attachEntities.size() > 0) {
			for(AttachmentEntity attachmentEntity:attachEntities) {
				attachmentEntity.setId(IdWorker.getId());
				attachmentEntity.setBillType(billType);
        		if(StringUtils.isNotBlank(sourceId)) {
        			attachmentEntity.setSourceId(Long.parseLong(sourceId));
        		}
        		attachmentEntity.setSourceType(sourceType);

        		attachmentService.saveOrUpdate(attachmentEntity);
        		attachmentEntity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + attachmentEntity.getFilePath());
        		attachVos.add(BeanMapper.map(attachmentEntity, AttachmentVO.class));
			}
		}
		return CommonResponse.success(attachVos);
	}

	/**
	 * 文件合并
	 *
	 * @param request
	 * @return
	 */
	@PostMapping(value = "uploadAndMerge2Pdf")
	@ResponseBody
	public CommonResponse<AttachmentVO> uploadAndMerge2Pdf(HttpServletRequest request) {
		AttachmentVO resp = null;
		String billType = request.getParameter("billType");
		String sourceId = request.getParameter("sourceId");
		String sourceType = request.getParameter("sourceType");
		String mark = request.getParameter("mark");
		String replace = request.getParameter("replace");
		String mainFileId = request.getParameter("mainFileId");
		String mergeSequenceStr = request.getParameter("mergeSequence");
		final Map<String, Integer> mergeSequence = new HashMap<>();
		if(StringUtils.isNotBlank(mergeSequenceStr)) {
			mergeSequence.putAll(JSONObject.parseObject(mergeSequenceStr, Map.class));
		}
		final String originalFileNameStr = request.getParameter("originalFileName");
		if (StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		// 文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		// 文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (originalFilename.indexOf(".") < 0) {
				originalFilename = originalFileNameStr;
			}
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if (mf.getSize() > sizeLimit) {
				logger.error("限定大小为：" + sizeLimit + "，文件大小为：" + mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		Boolean onlyOneFile = true;
		String bucketName = minioConfiguration.getBucketName();
		com.aspose.pdf.Document mainFile = null; //主合并文件
		String mainFileName = null; //合并主文件名称
		String extName = null; //待处理文件后缀
		File mergeFile = null; //最终PDF文件
		File tempPdfFile = null; //最终PDF文件
		File mainTempPdfFile = null; //最终PDF文件
//		OutputStream outs = null;
//		InputStream in = null;

		ByteArrayInputStream bis = null;
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		List<com.aspose.pdf.Document> docList = new ArrayList<>();

		List<com.aspose.pdf.Document> tmpDocs = new ArrayList<>();
		com.aspose.pdf.Document tmpDoc = null;
		SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
		List<File> pdfFiles = new ArrayList<>();
		try {
			if(StringUtils.isNotBlank(mainFileId)) {
				AttachmentVO attachmentVo = attachmentService.selectById(mainFileId);
				if (attachmentVo != null) {
					// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
					InputStream in = fileUtils.downloadFileByKeyName(attachmentVo.getFilePath());
					mainFileName = attachmentVo.getFileName();
					extName = com.ejianc.framework.core.util.FileUtils.getFileExt(mainFileName, false);
					bos.reset();
					change2Pdf(in, bos, extName);
					bis = new ByteArrayInputStream(bos.toByteArray());
					mainFile = new com.aspose.pdf.Document(bis);

					bos.flush();
					bos.close();
					bis.close();
				}
			}

			//对上传文件列表进行排序
			if(null != mergeSequence) {
				fileList.sort(new Comparator<MultipartFile>() {
					@Override
					public int compare(MultipartFile o1, MultipartFile o2) {
						return (null != mergeSequence.get(o1.getName()) ? mergeSequence.get(o1.getName()) : 0) - (null != mergeSequence.get(o2.getName()) ? mergeSequence.get(o2.getName()) : 0);
					}
				});
			}

			for(MultipartFile mf : fileList) {
				extName = com.ejianc.framework.core.util.FileUtils.getFileExt(mf.getOriginalFilename(), false);
				bos.reset();
				change2Pdf(mf.getInputStream(), bos, extName);
				bis = new ByteArrayInputStream(bos.toByteArray());
				if(null == mainFile) {
					mainFileName = mf.getOriginalFilename();
					mainFileName = mainFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
					mainFile = new com.aspose.pdf.Document(bis);
				} else {
					docList.add(new com.aspose.pdf.Document(bis));
				}
				if(fileList.size() > 1) {
					bos.flush();
					bos.close();
					bis.close();
				}
			}

			logger.info("待合并文件列表数量：{}", docList.size());
			if(CollectionUtils.isNotEmpty(docList)) {
				for(com.aspose.pdf.Document doc : docList) {
					mainFile.getPages().add(doc.getPages());
				}
				bos.reset();
				mainFile.save(bos);
				onlyOneFile = false;
			}

			if(null == bos || bos.size() == 0) {
				return CommonResponse.error("文件合并失败，合并后文件内容为空");
			}
			String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/"
					+ IdWorker.getId() + ".pdf";
//			in = new FileInputStream(mergeFile);
			bis = new ByteArrayInputStream(bos.toByteArray());
			ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(bis, bis.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());

			if (StringUtils.isNotBlank(objectResponse.etag())) {
				AttachmentVO attachment = null;

				if ("true".equals(replace) && StringUtils.isNotBlank(sourceId)) {
					List<AttachmentVO> list = attachmentService.findFileList(InvocationInfoProxy.getTenantid(),
							sourceId, sourceType, billType);
					if (CollectionUtils.isEmpty(list)) {
						logger.info("未匹配到要更新的附件sourceId-{},sourceType-{},billType-{}，创建新的附件信息！", sourceId,
								sourceType, billType);
						attachment = new AttachmentVO();
					} else {
						attachment = list.get(0);
						attachment.setOnlinePath(null);
					}
				} else {
					attachment = new AttachmentVO();
				}
				attachment.setBillType(billType);
				if (StringUtils.isNotBlank(sourceId)) {
					attachment.setSourceId(Long.parseLong(sourceId));
				}
				attachment.setSourceType(sourceType);
				attachment.setMark(mark);
				attachment.setFileName(mainFileName.substring(0, mainFileName.lastIndexOf(".")+1) + "pdf");
				attachment.setFilePath(objectName);
				attachment.setOrgId(InvocationInfoProxy.getOrgId());
//				attachment.setFileSize(mergeFile.length());
				Long userId = InvocationInfoProxy.getUserid();
				CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
				if (employeeResponse.isSuccess()) {
					attachment.setUploadUserName(employeeResponse.getData().getName());
				}

				AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
				logger.info("待保存文件信息：{}", JSONObject.toJSONString(entity));
				attachmentService.saveOrUpdate(entity, false);
				entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);

				return CommonResponse.success("文件合并成功！", BeanMapper.map(entity, AttachmentVO.class));
			}

		} catch (Exception e) {
			logger.error("文件合并转PDF异常：", e);
			return CommonResponse.error("文件合并失败！");
		} finally {
			try {
				if(null != mainFile) {
					mainFile.close();
				}
				for(com.aspose.pdf.Document doc : docList) {
					doc.close();
				}
				if(bos != null) {
					bos.flush();
					bos.close();
				}
				if(bis != null) {
					bis.close();
				}
			} catch (IOException ex) {
				logger.error("输出流关闭异常：", ex);
			}
		}

		return CommonResponse.success(resp);
	}


	private void change2Pdf(InputStream in, ByteArrayOutputStream bos, String suffix) {
		boolean changFlag = false;
		BufferedInputStream bufferedInputStream = null;
		try {
			boolean auth = PoiExcelToHtmlImpl.authrolizeLicense();
			if (!auth) {
				logger.info("aspose 许可无效！");
			}

			if("doc".equals(suffix) || "docx".equals(suffix)) {
				FontSettings fontSetting = FontSettings.getDefaultInstance();
				fontSetting.setFontsFolder("/usr/share/fonts/", false);
				bufferedInputStream = new BufferedInputStream(in);
				Document document = new Document(bufferedInputStream);
				//接受所有修订
				document.acceptAllRevisions();
				document.setFontSettings(fontSetting);
				document.save(bos, SaveFormat.PDF);
				changFlag = true;
			} else if("xls".equals(suffix) || "xlsx".equals(suffix)){
				com.aspose.cells.Workbook cellBook = new com.aspose.cells.Workbook(in);
				com.aspose.cells.Style style = cellBook.createStyle();
				style.setTextWrapped(true);
				//缩放比例
				int[] autoDrawSheets={1};
				autoDraw(cellBook, autoDrawSheets);
				com.aspose.cells.PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
//				pdfSaveOptions.setOnePagePerSheet(true);
				pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
				cellBook.save(bos, pdfSaveOptions);
				changFlag = true;
			} else {
				changFlag = officeToPdf.converterFile(in, suffix, bos, "pdf");
			}
			logger.info("单个非doc/docx文件转PDF结果：{}", changFlag);
		} catch (Exception e) {
			logger.error("change2Pdf-文件合并异常：", e);
		} finally {
			if (bufferedInputStream != null) {
				try {
					bufferedInputStream.close();
				} catch (IOException ignored) {
					System.out.println("关闭流异常" + ignored);
				}
			}
			if(bos != null) {
				if(bos != null) {
					try {
						bos.close();
					} catch (IOException ex2) {
						logger.error("关闭流异常", ex2);
					}
				}
			}
		}

		if(!changFlag) {
			throw new BusinessException("文件合并失败");
		}
	}

	/**
	 * @param wb 设置打印的sheet自动拉伸比例
	 * @param page 自动拉伸的页的sheet数组
	 */
	public static void autoDraw(com.aspose.cells.Workbook wb, int[] page){
		if (null!=page&&page.length>0){
			for (int i = 0; i < page.length; i++) {
				wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
				wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
			}
		}
	}

	/**
	 * 文件上传， 必须传对应的业务ID
	 * 
	 * @return
	 */
	@RequestMapping(value = "upload", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> upload(HttpServletRequest request) {
		String billType = request.getParameter("billType");
		String sourceId = request.getParameter("sourceId");
		String sourceType = request.getParameter("sourceType");
		String mark = request.getParameter("mark");
		String replace = request.getParameter("replace");
		String orgIdStr = request.getParameter("orgId");
		final String originalFileNameStr = request.getParameter("originalFileName");
		boolean fromWxMiniPm = StringUtils.isNotBlank(request.getParameter("fromWxMiniPm"))
				? Boolean.valueOf(request.getParameter("fromWxMiniPm")) : false;
		if (StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		// 文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		// 文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (originalFilename.indexOf(".") < 0) {
				originalFilename = originalFileNameStr;
			}
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if (mf.getSize() > sizeLimit) {
				logger.error("限定大小为：" + sizeLimit + "，文件大小为：" + mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}
		InputStream mfInputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				if (fileName.indexOf(".") < 0) {
					fileName = originalFileNameStr;
				}
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				if (fromWxMiniPm) {
					// 微信小程序上传的文件获取的名称不是文件原名且比较长，故覆盖之
					fileName = "WXMiniPm-" + objectName;
				}
				mfInputStream = mf.getInputStream();
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = null;

					if ("true".equals(replace) && StringUtils.isNotBlank(sourceId)) {
						List<AttachmentVO> list = attachmentService.findFileList(InvocationInfoProxy.getTenantid(),
								sourceId, sourceType, billType);
						if (CollectionUtils.isEmpty(list)) {
							logger.info("未匹配到要更新的附件sourceId-{},sourceType-{},billType-{}，创建新的附件信息！", sourceId,
									sourceType, billType);
							attachment = new AttachmentVO();
						} else {
							attachment = list.get(0);
							attachment.setOnlinePath(null);
						}
					} else {
						attachment = new AttachmentVO();
					}
					attachment.setBillType(billType);
					if (StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setMark(mark);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					Long orgId = null;
					if (StringUtils.isBlank(orgIdStr)) {
						orgId = InvocationInfoProxy.getOrgId();
					} else {
						orgId = Long.parseLong(orgIdStr);
					}
					attachment.setOrgId(orgId);
					Long userId = InvocationInfoProxy.getUserid();
					CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
					if (employeeResponse.isSuccess()) {
						attachment.setUploadUserName(employeeResponse.getData().getName());
					}

					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					logger.info("待保存文件信息：{}", JSONObject.toJSONString(entity));
					attachmentService.saveOrUpdate(entity, false);
					InputStream is = attachmentService.getThumbnailPath(entity);
					if(is!=null){
						try {
							is.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					resultEntity.add(entity);
				}
			}
			List<AttachmentVO> resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
			setFileTruePath(resultList);
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			return CommonResponse.error("文件上传失败，Msg：" + ex.getMessage());
		}finally {
			if(mfInputStream != null) {
				try {
					mfInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 文件上传， 不需要保存到数据库，直接上传到服务器
	 * 
	 * @return
	 */
	@RequestMapping(value = "upload2", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> upload2(HttpServletRequest request) {

		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		// 获取file框的
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		// 文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		// 文件类型判断
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			MultipartFile mf = entity.getValue();
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if (mf.getSize() > sizeLimit) {
				logger.error("限定大小为：" + sizeLimit + "，文件大小为：" + mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		InputStream mfInputStream = null;
		try {
			List<AttachmentVO> resultList = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				mfInputStream = mf.getInputStream();
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO vo = new AttachmentVO();
					vo.setFilePath(objectName);
					vo.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					vo.setFileName(fileName);
					resultList.add(vo);
				}
			}
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			throw new BusinessException("文件上传失败，Msg：" + ex.getMessage());
		} finally {
			if(mfInputStream != null) {
				try {
					mfInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 下載单个文件
	 * 
	 * @param fileId
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "download", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> download(@RequestParam(name = "fileId", required = true) String fileId, HttpServletResponse response) {

		AttachmentVO attachmentVo = attachmentService.selectById(fileId);
		if (attachmentVo != null) {
			// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
			String bucketName = minioConfiguration.getBucketName();
			BufferedOutputStream out = null;
			// 读取文件内容。
			GetObjectResponse getObjectResponse = null;
			try {
				response.reset();
				response.setContentType("application/octet-stream");
				
				response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attachmentVo.getFileName(), "UTF-8"));
				response.setHeader("Content-Length", String.valueOf(attachmentVo.getFileSize()));
				response.setHeader("Access-Control-Allow-Origin", "*");
				out = new BufferedOutputStream(response.getOutputStream());
				if(attachmentVo.getFilePath().contains("http")) {
					// 从远程URL下载文件
					URL url = new URL(attachmentVo.getFilePath());
					IOUtils.copy(url.openStream(), out);
				}else {
					getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachmentVo.getFilePath()).build());
					IOUtils.copy(getObjectResponse, out);
				}
			} catch (Exception e) {
				logger.error("文件上传失败", e);
				throw new BusinessException("文件上传失败，Msg：" + e.getMessage());
			} finally {
				if (out != null) {
					try {
						out.flush();
						out.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
				if(getObjectResponse != null) {
					try {
						getObjectResponse.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
			return CommonResponse.success("下載成功");
		} else {
			return CommonResponse.error("参数fileId不合法，未查询到对应的附件信息");
		}
	}
	
	@RequestMapping(value = "no_auth/getattachById", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<AttachmentEntity> getattachById(@RequestParam(name = "attachid", required = true) String attachid) {
		AttachmentEntity attachmentEntity = attachmentService.getById(attachid);
		return CommonResponse.success(attachmentEntity);
	}

	/**
	 * 下載单个文件
	 *
	 * @param fileId
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "no_auth/download")
	public void noAuthDownload(@RequestParam(name = "fileId", required = true) String fileId, HttpServletResponse response) {
		download(fileId, response);
	}
	
	/**
     * 扩展css记录
     */
	@RequestMapping(value = "no_auth/updateFileCss")
	@ResponseBody
	public CommonResponse<String> updateFileCss(@RequestParam(name = "fileId", required = true) String fileId, @RequestParam(name = "extcss", required = true) String extcss) {
		attachmentService.updateFileCss(fileId, extcss);
		return CommonResponse.success();
	}
	
	 /**
     * 查询文件css记录
     */
	@RequestMapping(value = "no_auth/queryFileCss")
	@ResponseBody
	public CommonResponse<String> queryFileCss(@RequestParam(name = "fileId", required = true) String fileId) {
		String extcss = attachmentService.queryFileCss(fileId);
		return CommonResponse.success("success", extcss);
	}


	@RequestMapping(value = "batchdownflow", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Map<String, byte[]>> batchDownFlow(@RequestParam(name = "fileIds", required = true) String fileIds) {
		List<AttachmentVO> attachmentList = attachmentService.queryListByIds(fileIds);
		try {
			Map<String, byte[]> fileBytes = new TreeMap<>();
			ByteArrayOutputStream out = null;
			Map<String, Integer> fileNames = new HashMap<>();
			for (int i = 0; i < attachmentList.size(); i++) {
				AttachmentVO attachmentVo = attachmentList.get(i);
				// 处理文件名相同情况
				String filName = "";
				if (fileNames.get(attachmentVo.getFileName()) != null) {
					filName = attachmentVo.getFileName().replace(".",
							"(" + fileNames.get(attachmentVo.getFileName()) + ").");
					fileNames.put(attachmentVo.getFileName(), (fileNames.get(attachmentVo.getFileName()) + 1));
				} else {
					filName = attachmentVo.getFileName();
					fileNames.put(attachmentVo.getFileName(), 1);
				}
				GetObjectResponse getObjectResponse = null;
				try {
					// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
					String bucketName = minioConfiguration.getBucketName();
					getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachmentVo.getFilePath()).build());
					out = new ByteArrayOutputStream();
					IOUtils.copy(getObjectResponse, out);
					fileBytes.put(filName, out.toByteArray());
				} catch (Exception e) {
					throw new BusinessException(attachmentVo.getFileName() + "下载失败");
				} finally {
					if (out != null) {
						try {
							out.flush();
							out.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					if(getObjectResponse != null) {
						getObjectResponse.close();
					}
				}
			}
			return CommonResponse.success(fileBytes);
		} catch (Exception e) {
			logger.error("批量文件下載失败", e);
			throw new BusinessException("批量文件下載失败，Msg：" + e.getMessage());
		}
	}
	@RequestMapping(value = "no_auth/batchdownflow", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<Map<String, byte[]>> noAuthBatchDownFlow(@RequestParam(name = "fileIds", required = true) String fileIds) {
		List<AttachmentVO> attachmentList = attachmentService.queryListByIds(fileIds);
		try {
			Map<String, byte[]> fileBytes = new TreeMap<>();
			ByteArrayOutputStream out = null;
			Map<String, Integer> fileNames = new HashMap<>();
			for (int i = 0; i < attachmentList.size(); i++) {
				AttachmentVO attachmentVo = attachmentList.get(i);
				// 处理文件名相同情况
				String filName = "";
				if (fileNames.get(attachmentVo.getFileName()) != null) {
					filName = attachmentVo.getFileName().replace(".",
							"(" + fileNames.get(attachmentVo.getFileName()) + ").");
					fileNames.put(attachmentVo.getFileName(), (fileNames.get(attachmentVo.getFileName()) + 1));
				} else {
					filName = attachmentVo.getFileName();
					fileNames.put(attachmentVo.getFileName(), 1);
				}
				GetObjectResponse getObjectResponse = null;
				try {
					// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
					String bucketName = minioConfiguration.getBucketName();
					getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachmentVo.getFilePath()).build());
					out = new ByteArrayOutputStream();
					IOUtils.copy(getObjectResponse, out);
					fileBytes.put(filName, out.toByteArray());
				} catch (Exception e) {
					throw new BusinessException(attachmentVo.getFileName() + "下载失败");
				} finally {
					if (out != null) {
						try {
							out.flush();
							out.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					if(getObjectResponse != null) {
						getObjectResponse.close();
					}
				}
			}
			return CommonResponse.success(fileBytes);
		} catch (Exception e) {
			logger.error("批量文件下載失败", e);
			throw new BusinessException("批量文件下載失败，Msg：" + e.getMessage());
		}
	}
	@RequestMapping(value = "no_auth/batch-download", method = RequestMethod.GET)
    @ResponseBody
    public void noAuthBatchDownload(@RequestParam(name = "fileIds",required = false) String fileIds,
									@RequestParam(name = "sourceIds",required = false) String sourceIds,
									@RequestParam(name = "billType",required = false) String billType,
									@RequestParam(name = "sourceTypes",required = false) String sourceTypes,
									HttpServletResponse response) {
		batchDownload(fileIds, sourceIds,billType,sourceTypes,response);
	}

	/**
	 * 批量下載文件
	 *
	 * @param fileIds
	 * @param response
	 */
	@RequestMapping(value = "batch-download", method = RequestMethod.GET)
	@ResponseBody
	public void batchDownload(@RequestParam(name = "fileIds", required = false) String fileIds,
							  @RequestParam(name = "sourceIds",required = false) String sourceIds,
							  @RequestParam(name = "billType",required = false) String billType,
							  @RequestParam(name = "sourceTypes",required = false) String sourceTypes,
							  HttpServletResponse response) {
		List<AttachmentVO> attachmentList = null;
		if (StringUtils.isNotBlank(fileIds)) {
			attachmentList = attachmentService.queryListByIds(fileIds);
		}else {
			QueryParam queryParam = new QueryParam();
			if (StringUtils.isBlank(sourceIds)) {
				throw new BusinessException("批量文件下載失败，Msg：sourceIds为空，查询不到匹配的文件信息！");
			}
			queryParam.getOrderMap().put("createTime", "desc");
			Map<String, Parameter> params = queryParam.getParams();
			params.put("sourceId", new Parameter(QueryParam.IN, sourceIds));
			if (StringUtils.isNotBlank(billType)) {
				params.put("billType", new Parameter(QueryParam.EQ, billType));
			}
			if (StringUtils.isNotBlank(sourceTypes)) {
				params.put("sourceType", new Parameter(QueryParam.IN, sourceTypes));
			}
			attachmentList = attachmentService.queryListByParams(queryParam);
		}

		String fileName = StringUtils.defaultString("附件包") + ".zip";

		try {
			Map<String, byte[]> fileBytes = new TreeMap<>();
			ByteArrayOutputStream out = null;
			Map<String, Integer> fileNames = new HashMap<>();
			for (int i = 0; i < attachmentList.size(); i++) {
				AttachmentVO attachmentVo = attachmentList.get(i);
				// 处理文件名相同情况
				String filName = "";
				if (fileNames.get(attachmentVo.getFileName()) != null) {
					filName = attachmentVo.getFileName().replace(".",
							"(" + fileNames.get(attachmentVo.getFileName()) + ").");
					fileNames.put(attachmentVo.getFileName(), (fileNames.get(attachmentVo.getFileName()) + 1));
				} else {
					filName = attachmentVo.getFileName();
					fileNames.put(attachmentVo.getFileName(), 1);
				}
				GetObjectResponse getObjectResponse = null;
				try {
					// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
					String bucketName = minioConfiguration.getBucketName();
					getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachmentVo.getFilePath()).build());

					out = new ByteArrayOutputStream();
					IOUtils.copy(getObjectResponse, out);
					fileBytes.put(filName, out.toByteArray());
				} catch (Exception e) {
					logger.info(attachmentVo.getFileName() + "下载失败:"+e.getMessage());
				} finally {
					if (out != null) {
						try {
							out.flush();
							out.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					if(getObjectResponse != null) {
						getObjectResponse.close();
					}
				}
			}
			response.reset();
			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));

			ServletOutputStream outputStream = response.getOutputStream();
			ZipCompress zipCompress = new ZipCompress(outputStream);
			zipCompress.compress(fileBytes);
		} catch (Exception e) {
			logger.error("批量文件下載失败", e);
			throw new BusinessException("批量文件下載失败，Msg：" + e.getMessage());
		}
	}



	/**
	 * base64上传
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/uploadForBase64", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> uploadForBase64(@RequestBody AttachmentRequestVO request) {
		String billType = request.getBillType();
		String sourceId = request.getSourceId();
		String sourceType = request.getSourceType();
		String mark = request.getMark();
		Long tenantId = request.getTenantId();
		Long orgId = request.getOrgId();
		if (StringUtils.isBlank(billType)) {
			return CommonResponse.error("单据类型编号不能为空！");
		}
		if (StringUtils.isBlank(sourceType)) {
			return CommonResponse.error("业务类型(图片类型)不能为空！");
		}
		if (tenantId==null) {
			tenantId = InvocationInfoProxy.getTenantid();
			if (tenantId==null) {
				tenantId = 999999L;
			}
		}
		if (orgId==null) {
			orgId = InvocationInfoProxy.getOrgId();
		}
		//文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		//文件类型判断
		for (String fileStr : request.getFileList()) {
			MultipartFile mf = null;
			try {
				mf = new BASE64MultipartFile(fileStr);
			} catch (IOException e) {
				e.printStackTrace();
				throw new BusinessException("上传失败");
			}
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if(mf.getSize()>sizeLimit){
				logger.error("限定大小为："+sizeLimit+"，文件大小为："+mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		InputStream mfInputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = tenantId + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				
				mfInputStream = mf.getInputStream();
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if(StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if(StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setMark(mark);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					attachment.setOrgId(orgId);
					Long userId = InvocationInfoProxy.getUserid();
					if(userId!=null) {
						CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
						if(employeeResponse.isSuccess()) {
							attachment.setUploadUserName(employeeResponse.getData().getName());
						}
					}
					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					attachmentService.saveOrUpdate(entity, false);
					InputStream is = attachmentService.getThumbnailPath(entity);
					if(is!=null){
						try {
							is.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					resultEntity.add(entity);
				}
			}

			if(CollectionUtils.isNotEmpty(resultEntity)) {
				attachmentService.saveOrUpdateFileList(resultEntity, request.getClearBeforeSave());
			}

			List<AttachmentVO> resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
			setFileTruePath(resultList);
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			throw new BusinessException("文件上传失败，Msg："+ex.getMessage());
		}finally {
			if(mfInputStream != null) {
				try {
					mfInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	@RequestMapping(value = "/updateFileName", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> updateFileName(@RequestParam("id") Long id,@RequestParam("name") String name){
		AttachmentEntity file = attachmentService.selectById(id);
		if(file == null){
			return CommonResponse.error("文件不存在");
		}
		file.setFileName(name);
		attachmentService.saveOrUpdate(file);
		return CommonResponse.success("修改成功！");
	}
}
