package com.ejianc.foundation.file.controller;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.file.config.MinioCommonConts;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BaseState;
import com.ejianc.foundation.file.define.MultiState;
import com.ejianc.foundation.file.define.State;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;

@RequestMapping("file")
@Controller
public class FileBaiduController {

    static Logger logger = LoggerFactory.getLogger(FileBaiduController.class);

	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
    @Resource
    private IAttachmentService attachmentService;
    @Value("${common.env.base-host}")
	private String fileServer;
    @Value("${blackFileExtList}")
    private String blackFileExtList;

    @RequestMapping(value = "/config")
    @ResponseBody
    public Object config(HttpServletRequest request,HttpServletResponse response,@RequestParam(value = "action") String action) throws Exception {
    	request.setCharacterEncoding( "utf-8" );
        response.setHeader("Content-Type" , "text/html");
    	String callback =request.getParameter("callback");
    	if("config".equals(action))
    		if ( callback != null ) {
    			return  callback + "(" + getConfig() + ");";
    		}
    		else{
    			return getConfig();
    		}
    	else if("uploadvideo".equals(action)){
    		if (request instanceof MultipartHttpServletRequest) {
				MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest) request;
				MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
				if (multipartFile == null) {
					return "文件为空";
				} else {
					return images(multipartFile, request);
				}
			}else{
				return "文件为空";
			}
//    		return "文件处理方法";
    	}else if("uploadimage".equals(action)){
    		if (request instanceof MultipartHttpServletRequest) {
				MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest) request;
				MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
				if (multipartFile == null) {
					return "文件为空";
				} else {
					return images(multipartFile, request);
				}
			}else{
				return "文件为空";
			}
    	}else if("listimage".equals(action)){
    		Integer start = Integer.parseInt(request.getParameter("start"));
    		Integer size = Integer.parseInt(request.getParameter("size"));
    		if ( callback != null ) {
    			return  callback + "(" + this.listimg(start,size) + ");";
    		}
    		else{
    			return this.listimg(start,size);
    		}
    	}else{
//    		return "文件处理方法";
    		if (request instanceof MultipartHttpServletRequest) {
				MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest) request;
				MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
				if (multipartFile == null) {
					return "文件为空";
				} else {
					return images(multipartFile, request);
				}
			}else{
				return "文件为空";
			}
    	}

    }
    public String images(MultipartFile upfile, HttpServletRequest request) {
    	State state=null;
    	
    	InputStream upfileInputStream = null;
    	try {
            if (upfile.getSize() == 0L) {
                logger.error(upfile.getOriginalFilename() + "大小不能为0");
                throw new RuntimeException("上传了空文件");
            }
            String extName1 = FileUtils.getFileExt(upfile.getOriginalFilename(), false);
            if (fileExtInBlackList(extName1)) {
                logger.error("不允许上传" + extName1 + "格式文件");
                throw new RuntimeException("不允许上传" + extName1 + "格式文件");
            }
            
        	SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        	String fileName = upfile.getOriginalFilename();
        	String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
        	String objectName = "ejc-platform/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
        	
        	upfileInputStream = upfile.getInputStream();
			ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(upfileInputStream, upfileInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
        	if(StringUtils.isBlank(objectResponse.etag())) {
        		throw new BusinessException("上传文件失败");
        	}
    		/*
    		 * AttachmentEntity entity = new AttachmentEntity();
	        	if(StringUtils.isNotBlank(pubObjectResult.getETag())) {
	        		AttachmentVO attachment = new AttachmentVO();
	        		attachment.setSourceType("baidu");
	        		attachment.setBillType("baidu");
	        		attachment.setFileName(fileName);
	        		attachment.setFilePath(objectName);
	        		attachment.setFileSize(upfile.getSize());
	        		attachment.setUploadUserName(InvocationInfoProxy.getUsercode());
	        		entity = BeanMapper.map(attachment, AttachmentEntity.class);
	        		attachmentService.saveOrUpdate(entity, false);
        		}
        	*/
            
            state= new BaseState(true);
            
    		String filePath = fileServer + "ejc-file-web/attachment/filePreview?filePath="+URLEncoder.encode(objectName, "utf-8");
//    		state.putInfo( "id", entity.getId());
//    		state.putInfo( "title", entity.getFileName());
            state.putInfo("url", filePath);
            state.putInfo("size", upfile.getSize());
            state.putInfo("fileName", fileName);
//            state.putInfo("original", entity.getFileName());
            state.putInfo("type", upfile.getContentType());

    	} catch (Exception e) {
    		state= new BaseState(false);
    	}finally{
    		if(upfileInputStream != null) {
    			try {
					upfileInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
    		}
    	}
    	return state.toJSONString();
    }
    private String getConfig() throws Exception {
//    	File file = ResourceUtils.getFile("classpath:ueditor_config.json");
    	ClassPathResource resource = new ClassPathResource("ueditor_config.json");
//		InputStream inputStream = resource.getInputStream();
    	InputStreamReader reader = new InputStreamReader(resource.getInputStream(),"UTF-8");
    	StringBuilder responseStrBuilder = new StringBuilder();
    	BufferedReader bfReader = new BufferedReader(reader);
        String inputStr;
        while ((inputStr = bfReader.readLine()) != null)
            responseStrBuilder.append(inputStr);

        String config = filter(responseStrBuilder.toString());
        config = config.replaceAll("filePathUrl", fileServer);
        JSONObject json = JSONObject.parseObject(config);
    	return json.toString();
    }
    private static String filter ( String input ) {
		
		return input.replaceAll( "/\\*[\\s\\S]*?\\*/", "" );
		
	}
    public String listimg(Integer start,Integer size) {
    	
    	State state=null;
    	try {
            try {
        		QueryParam queryParam = new QueryParam();
        		queryParam.getOrderMap().put("createTime", "desc");
        		Map<String, Parameter> params = queryParam.getParams();
        		params.put("sourceType", new Parameter("eq","baidu"));
        		List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);
        		
        	    if ( start < 0 || start > list.size() ) {
        			state = new MultiState( true );
        		} else {
        			Object[] fileList = Arrays.copyOfRange( list.toArray(), start, start + size );
        			state = this.getState( fileList );
        		}
        	    state.putInfo( "start", start);
        		state.putInfo( "total", list.size());
            } catch (Exception ex) {
                logger.error("文件上传失败", ex);
                throw new RuntimeException("文件上传失败");
            }
  
    	} catch (Exception e) {
    		e.printStackTrace();
    	}
    	return state.toJSONString();
    }
    private State getState ( Object[] files ) {
		
		MultiState state = new MultiState( true );
		BaseState fileState = null;
		
		AttachmentVO file = null;
		for ( Object obj : files ) {
			if ( obj == null ) {
				break;
			}
			file = (AttachmentVO)obj;
			if(file.getFilePath()!=null){
				fileState = new BaseState( true );
				fileState.putInfo( "url",file.getFilePath().replace( "\\", "/" ));
				state.addState( fileState );
			}
		}
		
		return state;
		
	}

   @RequestMapping(value = "/getUploadImg/{photoName:.+}")
   @ResponseBody
   public void getUploadImg(@PathVariable String photoName, HttpServletRequest request, HttpServletResponse response) {
	   FileInputStream in;
	   response.setContentType("application/octet-stream;charset=UTF-8");
	   try { //图片读取路径
		   String picUrl = "";
		   in = new FileInputStream(picUrl + photoName);
		   int i = in.available();
		   byte[] data = new byte[i];
		   in.read(data);
		   in.close();
		   //写图片
		   OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
		   outputStream.write(data);
		   outputStream.flush();
		   outputStream.close();
	   } catch (Exception e) {
		   e.printStackTrace();
	   }
   }
   private boolean fileExtInBlackList(String fileExt) {
       if (StringUtils.isNotEmpty(blackFileExtList) && fileExt != null) {
           String[] blackFileExtArr = blackFileExtList.split(",");
           for (String blackExt : blackFileExtArr) {
               if (fileExt.equals(blackExt)) {
                   return true;
               }
           }
       }
       return false;
   }
	
	/**
	 * 获取访问地址
	 * @throws UnsupportedEncodingException 
	 */
	@RequestMapping(value = "onLineImagePreview", method = RequestMethod.GET)
	@ResponseBody
	public void onLineImagePreview(@RequestParam(name="filePath",required=false) String filePath, HttpServletResponse response) throws UnsupportedEncodingException {
		try {
			URL urls = new URL(filePath);
			String host = urls.getHost();
			
			HttpURLConnection conn = (HttpURLConnection)urls.openConnection();
			conn.setRequestMethod("GET");  
            conn.setConnectTimeout(50 * 1000);  
            conn.setReadTimeout(50 * 1000);
            InputStream inStream = conn.getInputStream();//通过输入流获取图片数据  
	        byte data[] = readInputStream(inStream); 
	        response.setContentType("image/jpg"); //设置返回的文件类型   
	        OutputStream os = response.getOutputStream();  
	        os.write(data); 
	        os.flush();  
	        os.close();
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	public static byte[] readInputStream(InputStream inStream) throws Exception{  
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();  
        byte[] buffer = new byte[2048];  
        int len = 0;  
        while( (len=inStream.read(buffer)) != -1 ){  
            outStream.write(buffer, 0, len);  
        }  
        inStream.close();  
        return outStream.toByteArray();  
	}
}
