package com.ejianc.foundation.file.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.Shape;
import com.aspose.words.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioCommonConts;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.enums.WaterWayEnum;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.util.HandleDocumentWarnings;
import com.ejianc.foundation.file.util.PdfProcessor;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ImgUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

import java.awt.*;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class AttachmentServiceImpl extends BaseServiceImpl<AttachmentMapper, AttachmentEntity>
		implements IAttachmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private AttachmentMapper attachmentMapper;
	@Autowired
    FileUtils fileUtils;
	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Autowired
	private EnvironmentTools environmentTools;

	@Value("${common.env.base-host:#{null}}")
	private String baseHost;
	@Value("${fileUrl}")
	private String fileUrl;
	@Autowired
	private PdfProcessor pdfProcessor;

	@Override
	public void updateAttachRef(Long sourceId, List<Long> attachIds) {
		for(Long attachId:attachIds) {
			attachmentMapper.updateAttachRef(sourceId,attachId);
		}
	}

	@Override
	public AttachmentVO selectById(String fileId) {
		AttachmentEntity entity = super.getById(fileId);
		if(entity != null) {
			return BeanMapper.map(entity, AttachmentVO.class);
		}
		return null;
	}

	/**
	 * 保存缩略图
	 *
	 * @param entity
	 */
	@Override
	public InputStream getThumbnailPath(AttachmentEntity entity) {
		String  thumbnailPath = entity.getFilePath();
		InputStream is = null;
		if(StringUtils.isNotEmpty(thumbnailPath) && thumbnailPath.contains(".") && isImage(thumbnailPath.split("\\.")[1])){//图片
			if(entity.getFileSize()>512000){//图片大小大于512k
				/** 判断是否压缩过 */
				thumbnailPath = thumbnailPath.split("\\.")[0]+"/thumbnail.jpg";
				try {
					is = fileUtils.downloadFileByKeyName(thumbnailPath);
				}catch (Exception e){
					e.printStackTrace();
					logger.info(e.getMessage());
				}
				if(is == null){//没有上传压缩图片
					byte[] imgBytes = ImgUtils.compressPic(null,fileUtils.downloadFileByKeyName(entity.getFilePath()),250,250,1);
					try {
						is = new ByteArrayInputStream(imgBytes);
						minioClient.putObject(PutObjectArgs.builder()
								.bucket(minioConfiguration.getBucketName())
								.object(thumbnailPath)
								.stream(is, is.available(), MinioCommonConts.DEFAULT_PART_SIZE)
								.build());
					} catch (Exception e) {
						e.printStackTrace();
						logger.error("保存缩略图片失败！",e);
					}
				}
			}
		}
		return is;
	}

	private boolean isImage(String ex){
		boolean res = false;
		switch (ex.toLowerCase()){
			case "jpg":
			case "jpeg":
			case "png":
			case "bpm":
			case "gif":
				res = true;
				break;
			default:
				break;
		}
		return res;
	}

	@Override
	public List<AttachmentVO> queryListByIds(String fileIds) {
		List<AttachmentVO> attachmentVos = new ArrayList<>();
		String[] fileIdArr = fileIds.split(",");
		for(String fileId:fileIdArr) {
			AttachmentEntity entity = super.getById(fileId);
			if(entity != null) {
				attachmentVos.add(BeanMapper.map(entity, AttachmentVO.class));
			}
		}
		return attachmentVos;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(String ids) {
		try{
			attachmentMapper.deleteIds(ids);

			List<Long> idList = Arrays.asList(ids.split(",")).stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());

			QueryWrapper<AttachmentEntity> query = new QueryWrapper<>();
			query.eq("dr", BaseVO.DR_UNDELETE);
			query.in("id", idList);
			query.eq("archive_status", AttachmentVO.ARCHIVED);

			List<AttachmentEntity> list = baseMapper.selectList(query);

			if(CollectionUtils.isNotEmpty(list)) {
				String url = environmentTools.getBaseHost() + "ejc-doc-web/api/projectDoc/delByFileIds";
				List<Long> fileIds = list.stream().map(file -> file.getId()).collect(Collectors.toList());
				//删除附件对应的归档信息
				String resp = HttpTookit.postByJson(url, JSONObject.toJSONString(fileIds));

				logger.info("根据附件Id列表-{},删除其对应归档信息请求结果：{},", JSONObject.toJSONString(fileIds) ,resp);
				CommonResponse<String> result = JSONObject.parseObject(resp, CommonResponse.class);
				if(!result.isSuccess()) {
					logger.error("根据附件Id列表-{},删除其对应归档信息失败，原因：{}", JSONObject.toJSONString(fileIds), result.getMsg());
					throw new BusinessException("删除失败，删除附件归档信息失败!");
				}
			}

			return CommonResponse.success("删除成功");
		}catch(Exception e){
			logger.error("----------删除文件失败--------",e);
			return CommonResponse.error("删除失败");
		}
		
	}

	@Override
	public List<AttachmentVO> queryListByParams(QueryParam queryParam) {
		List<AttachmentEntity> list = this.queryList(queryParam, false);
		return BeanMapper.mapList(list, AttachmentVO.class);
	}

	@Override
	public void updateAttachArchiveStatus(List<Long> attachIds, String status) {
		attachmentMapper.updateAttachArchiveStatus(attachIds, status);
	}

	@Override
	public List<AttachmentVO> findFileList(Long tenantId, String sourceId, String sourceType, String billType) {
		List<AttachmentVO> resp = new ArrayList<>();
		QueryWrapper<AttachmentEntity> query = new QueryWrapper<AttachmentEntity>();
		query.eq("tenant_id", tenantId);
		query.eq("source_id", sourceId);
		query.eq("bill_type", billType);
		if(StringUtils.isNotBlank(sourceType)) {
			query.eq("source_type", sourceType);
		}
		List<AttachmentEntity> list = super.list(query);
		if(CollectionUtils.isNotEmpty(list)) {
			resp = BeanMapper.mapList(list, AttachmentVO.class);
		}
		return resp;
	}

	@Override
	public void deleteFileByParams(Long sourceId, String billType, String sourceType, List<String> fileNames) {
		if(fileNames != null && fileNames.size() > 0) {
			for(String fileName:fileNames) {
				attachmentMapper.deleteFileByParams(sourceId, billType, sourceType, fileName);
			}
		}
	}

	@Override
	public void deleteFileByParam(Long sourceId, String billType, String sourceType) {
		attachmentMapper.deleteFileByParam(sourceId, billType, sourceType);
	}

	@Override
	public void saveOrUpdateFileList(List<AttachmentEntity> resultEntity, Boolean clearBeforeSave) {
		if(clearBeforeSave) {
			AttachmentEntity tmp = resultEntity.get(0);
			attachmentMapper.deleteFileByParam(tmp.getSourceId(), tmp.getBillType(), tmp.getSourceType());
		}

		super.saveOrUpdateBatch(resultEntity, resultEntity.size(), false);
	}
	
	@Override
	public String makeWatermarkToFile(Long fileId, String watermarkText, String waterWay) {
		InputStream in = null;
		ByteArrayOutputStream bos = null;
		ByteArrayInputStream bis = null;
		InputStream fileInputStream = null;
		AttachmentEntity entity = attachmentMapper.selectById(fileId);
		String suffix = entity.getFileName().substring(entity.getFileName().lastIndexOf(".") + 1);
		if("docx".equals(suffix) || "doc".equals(suffix)) {
			try {
				in = fileUtils.downloadFileByKeyName(entity.getFilePath());
				bos = new ByteArrayOutputStream();
				
				BufferedInputStream bufferedInputStream = null;
				try {
					FontSettings fontSetting = FontSettings.getDefaultInstance();
					fontSetting.setFontsFolder("/usr/share/fonts/", false);
					bufferedInputStream = new BufferedInputStream(in);
					Document document = new Document(bufferedInputStream);
					document.setFontSettings(fontSetting);
					if (StringUtils.isNotBlank(watermarkText)) {
						if("single".equals(waterWay)){
							insertWatermarkText(document, watermarkText);
						}else if("more".equals(waterWay)) {
							insertWaterMarks(document, watermarkText);
						}
					}
					HandleDocumentWarnings warningsHandler = new HandleDocumentWarnings();
					document.setWarningCallback(warningsHandler);
					document.save(bos, SaveFormat.PDF);

					//打印缺失字体信息
					warningsHandler.printMissingFontDetails();
				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					if (bufferedInputStream != null) {
						try {
							bufferedInputStream.close();
						} catch (IOException ignored) {
							System.out.println("关闭流异常" + ignored);
						}
					}
				}
				
				bis = new ByteArrayInputStream(bos.toByteArray());
				String pdfName = entity.getFileName().substring(0, entity.getFileName().lastIndexOf(".") + 1) + "pdf";
				MultipartFile multipartFile = new MockMultipartFile(pdfName, bis);
				
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String objectName = entity.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + ".pdf";
				fileInputStream = multipartFile.getInputStream();
				minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(fileInputStream, fileInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				
				entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
				attachmentMapper.insert(entity);
				
				return baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName;
			} catch (Exception e) {
				e.printStackTrace();
				logger.error("word转pdf保错-------{}", e);
			} finally {
				try {
					if (in != null) {
						in.close();
					}
					if (bos != null) {
						bos.flush();
						bos.close();
					}
					if (bis != null) {
						bis.close();
					}
					if (fileInputStream != null) {
						fileInputStream.close();
					}
				} catch (Exception e) {
                    logger.error("文件加水印资源释放失败", e);
				}
			}
		}else{
			throw new BusinessException("文件格式错误，必须是word");
		}
		
		return null;
	}

	@Override
	public AttachmentVO addWaterMarket(WaterMarketConfigVO waterMarketConfigVO) {
		InputStream in = null;
		ByteArrayOutputStream bos = null;
		ByteArrayInputStream bis = null;
		InputStream fileInputStream = null;
		AttachmentEntity entity = attachmentMapper.selectById(waterMarketConfigVO.getSourceFileId());
		String suffix = entity.getFileName().substring(entity.getFileName().lastIndexOf(".") + 1);
		if("docx".equals(suffix) || "doc".equals(suffix)) {
			try {
				in = fileUtils.downloadFileByKeyName(entity.getFilePath());
				bos = new ByteArrayOutputStream();

				BufferedInputStream bufferedInputStream = null;
				try {
					FontSettings fontSetting = FontSettings.getDefaultInstance();
					fontSetting.setFontsFolder("/usr/share/fonts/", false);
					bufferedInputStream = new BufferedInputStream(in);
					Document document = new Document(bufferedInputStream);
					document.setFontSettings(fontSetting);
					if (StringUtils.isNotBlank(waterMarketConfigVO.getTextContent())) {
						if(WaterWayEnum.单一水印.getWaterWayCode().equals(waterMarketConfigVO.getWaterWay())){
							insertWatermarkText(document, waterMarketConfigVO);
						}else if(WaterWayEnum.重复水印.getWaterWayCode().equals(waterMarketConfigVO.getWaterWay())) {
							insertWaterMarks(document, waterMarketConfigVO);
						}
					}

					HandleDocumentWarnings warningsHandler = new HandleDocumentWarnings();
					document.setWarningCallback(warningsHandler);
					document.save(bos, SaveFormat.PDF);

					//打印缺失字体信息
					warningsHandler.printMissingFontDetails();
				} catch (Exception e) {
					logger.error("添加水印失败：", e);
//					e.printStackTrace();
				} finally {
					if (bufferedInputStream != null) {
						try {
							bufferedInputStream.close();
						} catch (IOException ignored) {
							System.out.println("关闭流异常" + ignored);
						}
					}
				}

				bis = new ByteArrayInputStream(bos.toByteArray());
				String pdfName = entity.getFileName().substring(0, entity.getFileName().lastIndexOf(".") + 1) + "pdf";
				MultipartFile multipartFile = new MockMultipartFile(pdfName, bis);

				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String objectName = entity.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + ".pdf";
				fileInputStream = multipartFile.getInputStream();
				minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(fileInputStream, fileInputStream.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());

				//保存新的PDF水印文件
				AttachmentEntity pdfEntity = new AttachmentEntity();
				pdfEntity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
				pdfEntity.setSourceId(null != waterMarketConfigVO.getBillId() ? waterMarketConfigVO.getBillId() : entity.getSourceId());
				pdfEntity.setSourceType(StringUtils.isNotBlank(waterMarketConfigVO.getSourceType()) ? waterMarketConfigVO.getSourceType() : (entity.getSourceType() + "Pdf"));
				pdfEntity.setBillType(StringUtils.isNotBlank(waterMarketConfigVO.getBillType()) ? waterMarketConfigVO.getBillType() : entity.getBillType());
				pdfEntity.setFilePath(objectName);
				pdfEntity.setFileSize(Integer.valueOf(multipartFile.getSize()+""));
				pdfEntity.setFileName(pdfName);

				super.saveOrUpdate(pdfEntity, false);

				return BeanMapper.map(pdfEntity, AttachmentVO.class);
			} catch (Exception e) {
				e.printStackTrace();
				logger.error("word转pdf保错-------{}", e);
			} finally {
				try {
					if (in != null) {
						in.close();
					}
					if (bos != null) {
						bos.flush();
						bos.close();
					}
					if (bis != null) {
						bis.close();
					}
					if (fileInputStream != null) {
						fileInputStream.close();
					}
				} catch (Exception e) {
					logger.error("文件加水印资源释放失败", e);
				}
			}
		}else{
			throw new BusinessException("文件格式错误，必须是word");
		}

		return null;
	}

	@Override
	public List<AttachmentVO> queryAllByIds(List<Long> fileIds) {
		List<AttachmentVO> resp = new ArrayList<>();
		QueryWrapper<AttachmentEntity> query = new QueryWrapper<>();
		query.in("id", fileIds);

		List<AttachmentEntity> dbList = super.list(query);
		if(CollectionUtils.isNotEmpty(dbList)) {
			resp = BeanMapper.mapList(dbList, AttachmentVO.class);
		}

		return resp;
	}

	private void insertWatermarkText(Document doc, String watermarkText) throws Exception {
		WaterMarketConfigVO waterMarketConfig = new WaterMarketConfigVO();
		waterMarketConfig.setTextContent(watermarkText);
		insertWatermarkText(doc, waterMarketConfig);
	}

	private void insertWatermarkText(Document doc, WaterMarketConfigVO waterMarketConfig) throws Exception {
		System.out.println("开始添加水印...");
		Shape watermark = new Shape(doc, ShapeType.TEXT_PLAIN_TEXT);
		// 水印内容
		watermark.getTextPath().setText(waterMarketConfig.getTextContent());
		// 水印字体
		watermark.getTextPath().setFontFamily(StringUtils.isNotBlank(waterMarketConfig.getFontFamily()) ? waterMarketConfig.getFontFamily() : "宋体");
		// 水印宽度
		watermark.setWidth(500);
		// 水印高度
		watermark.setHeight(100);
		// 旋转水印
		watermark.setRotation(null !=  waterMarketConfig.getRotation() ? waterMarketConfig.getRotation().doubleValue() : -40);
		// 水印颜色
		watermark.getFill().setColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
		watermark.setStrokeColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);

		watermark.setRelativeHorizontalPosition(RelativeHorizontalPosition.PAGE);
		watermark.setRelativeVerticalPosition(RelativeVerticalPosition.PAGE);
		watermark.setWrapType(WrapType.NONE);
		watermark.setVerticalAlignment(VerticalAlignment.CENTER);
		watermark.setHorizontalAlignment(HorizontalAlignment.CENTER);

		Paragraph watermarkPara = new Paragraph(doc);
		watermarkPara.appendChild(watermark);

		for (Section sect : doc.getSections()) {
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_PRIMARY);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_FIRST);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_EVEN);
		}
		System.out.println("结束添加水印...");
	}


	private void insertWatermarkIntoHeader(Paragraph watermarkPara, Section sect, int headerType)
			throws Exception {
		HeaderFooter header = sect.getHeadersFooters().getByHeaderFooterType(headerType);
		if (header == null) {
			header = new HeaderFooter(sect.getDocument(), headerType);
			sect.getHeadersFooters().add(header);
		}
		header.appendChild(watermarkPara.deepClone(true));
	}

	/**
	 * 插入多个水印
	 *
	 * @param doc
	 * @param waterMark
	 * @throws Exception
	 */
	private void insertWaterMarks(Document doc, String waterMark) throws Exception {
		WaterMarketConfigVO waterMarkConfig = new WaterMarketConfigVO();
		waterMarkConfig.setTextContent(waterMark);
		insertWaterMarks(doc, waterMarkConfig);
	}

	private void insertWaterMarks(Document doc, WaterMarketConfigVO waterMarketConfig) throws Exception {
		Paragraph watermarkPara = new Paragraph(doc);
		for (int j = 0; j < 500; j = j + 200) {
			for (int i = 0; i < 700; i = i + 200) {
				Shape waterShape = ShapeMore(doc, waterMarketConfig, j-100, i);
				watermarkPara.appendChild(waterShape);
			}
		}
		String text = watermarkPara.getText();
		System.out.println("++++++++++" + text);
		System.out.println("______________" + watermarkPara);
		NodeCollection<?> childNodes = watermarkPara.getChildNodes();
		String text1 = childNodes.get(0).getText();
		System.out.println("111111" + text1);
		/*
		 * Shape waterShape = ShapeMore(mdoc, wmText, 155, 300);
		 * watermarkPara.appendChild(waterShape);
		 */
		for (Section sect : doc.getSections()) {
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_PRIMARY);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_FIRST);
			insertWatermarkIntoHeader(watermarkPara, sect, HeaderFooterType.HEADER_EVEN);
		}
	}

	/**
	 * 设置水印属性
	 *
	 * @param doc
	 * @param waterMark
	 * @param left
	 * @param top
	 * @return
	 * @throws Exception
	 */
	private Shape ShapeMore(Document doc, String waterMark, double left, double top) throws Exception {
		WaterMarketConfigVO waterMarketConfigVO = new WaterMarketConfigVO();
		waterMarketConfigVO.setTextContent(waterMark);
		waterMarketConfigVO.setFontFamily("宋体");
		waterMarketConfigVO.setFontColor(Color.lightGray);

		return ShapeMore(doc, waterMarketConfigVO, left, top);
	}

	public static Shape ShapeMore(Document doc, WaterMarketConfigVO waterMarketConfig, double left, double top) throws Exception {
		Shape waterShape = new Shape(doc, ShapeType.TEXT_PLAIN_TEXT);
		waterShape.getTextPath().setText(waterMarketConfig.getTextContent());
		waterShape.getTextPath().setFontFamily(StringUtils.isNotBlank(waterMarketConfig.getFontFamily()) ? waterMarketConfig.getFontFamily() : "宋体");
		waterShape.setWidth(waterMarketConfig.getTextContent().length()*14);
		waterShape.setHeight(10);
		waterShape.setRotation(null !=  waterMarketConfig.getRotation() ? waterMarketConfig.getRotation().doubleValue() : -30);
		waterShape.setDistanceLeft(0);
		waterShape.setFilled(true);

		waterShape.getFill().setColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
		waterShape.setStrokeColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
		// 将水印放置在页面中心
		waterShape.setLeft(left);
		waterShape.setTop(top);
		// 设置包装类型
		waterShape.setWrapType(WrapType.NONE);
		return waterShape;
	}

	@Override
	public List<AttachmentVO> queryMyFavoriteList(String userCode, String search) {
		List<AttachmentVO> attachmentVoList = attachmentMapper.queryMyFavoriteList(userCode, search);
		return attachmentVoList;
	}

	@Override
	public List<AttachmentVO> queryRecentList(String userCode, String search) {
		List<AttachmentVO> attachmentVoList = attachmentMapper.queryRecentList(userCode, search);
		return attachmentVoList;
	}

	@Override
	public List<AttachmentVO> queryListByBillType(String billCode, Long tenantId, String search) {
		List<AttachmentVO> attachmentVos = attachmentMapper.queryListByBillType(billCode, tenantId, search);
		return attachmentVos;
	}

	@Override
	public void updateFileCss(String fileId, String extcss) {
		attachmentMapper.updateFileCss(fileId, extcss);
	}

	// 统计字符串中汉字的数目
	public static int countChineseCharacters(String str) {
		int count = 0;
		for (char c : str.toCharArray()) {
			if (isChineseCharacter(c)) {
				count++;
			}
		}
		return count;
	}

	// 判断一个字符是否是汉字
	public static boolean isChineseCharacter(char c) {
		return (c >= '\u4E00' && c <= '\u9FA5');
	}

	// 统计字符串中的英文单词数
	public static int countEnglishWords(String str) {
		String[] words = str.split("\\W+"); // 以非字母或数字字符分割字符串
		return words.length;
	}
	@Override
	public Integer queryPageNumber(Long fileId) {
		Integer pages = 0;
		AttachmentEntity attachmentVo = this.selectById(fileId);
		if (attachmentVo != null) {
			String suffix = com.ejianc.framework.core.util.FileUtils.getFileExt(attachmentVo.getFileName(), false);

			// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
			String bucketName = minioConfiguration.getBucketName();
			BufferedInputStream in = null;
			// 读取文件内容。
			try {
				GetObjectResponse getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachmentVo.getFilePath()).build());
				in = new BufferedInputStream(getObjectResponse);
				if( "docx".equals(suffix)) {
					XWPFDocument document = new XWPFDocument(in);
					pages = document.getProperties().getExtendedProperties().getPages();
				} else if("doc".equals(suffix)) {
					HWPFDocument document = new HWPFDocument(in);
					pages = document.getSummaryInformation().getPageCount();
				} else if("xls".equals(suffix) || "xlsx".equals(suffix)){
					Workbook workbook = new XSSFWorkbook(in);
					Sheet sheet = workbook.getSheetAt(0); // 获取第一个工作表
					for (Row row : sheet) {
						for (Cell cell : row) {
							cell.setCellType(Cell.CELL_TYPE_STRING);
							String cellValue = cell.getStringCellValue(); // 获取单元格中的字符串值
							if (cellValue != null) {
								int chineseCount = countChineseCharacters(cellValue);
								int englishWordCount = countEnglishWords(cellValue);
								pages += (chineseCount + englishWordCount);
							}
						}
					}
					if(pages % 2000 == 0){
						pages = (pages / 2000);
					}else{
						pages = (pages / 2000) + 1;
					}
				} else if("ppt".equals(suffix) || "pptx".equals(suffix)){
					XMLSlideShow ppt = new XMLSlideShow(in);
					pages = ppt.getSlides().length;
				} else if("png".equals(suffix) || "jpg".equals(suffix) || "jpeg".equals(suffix) || "svg".equals(suffix) || "gif".equals(suffix)){
					pages = 1;
				} else if("pdf".equals(suffix)){
					PDDocument document = PDDocument.load(in);
					pages = document.getNumberOfPages();
				}
			} catch (Exception e) {
				logger.error("文件上传失败", e);
				throw new BusinessException("文件上传失败，Msg：" + e.getMessage());
			} finally {
				if (in != null) {
					try {
						in.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		} else {
			throw new BusinessException("未获取到附件信息");
		}
		return pages;
	}

	@Override
	public List<AttachmentVO> uploadByUrl(List<AttachmentVO> vos) {
		for (AttachmentVO vo : vos) {
			Integer fileSize = 0;
			InputStream in = null;
			try{
				// 获取文件大小
				URL url = new URL("https://dev.17elian.com/ejc-file-web/onlinePreview?device=pc&fileId=1008335232726093851");
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				conn.setRequestMethod("HEAD");
				fileSize = conn.getContentLength();
				// 下载文件
				in = new BufferedInputStream(url.openStream());

				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = vo.getFileName();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;

				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(in, in.available(), MinioCommonConts.DEFAULT_PART_SIZE).build());
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					vo.setFilePath(objectName);
					vo.setFileSize(Long.valueOf(fileSize));

					AttachmentEntity entity = BeanMapper.map(vo, AttachmentEntity.class);
					this.saveOrUpdate(entity, false);
					InputStream is = this.getThumbnailPath(entity);
					if(is!=null){
						try {
							is.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
					entity.setOnlinePath(baseHost + "ejc-file-web/attachment/filePreview?filePath=" + objectName);
					vo = BeanMapper.map(entity, AttachmentVO.class);
				}
			}catch (Exception e){
				throw new BusinessException("获取文件失败");
			}
		}
		return vos;
	}

	@Override
	public String queryFileCss(String fileId) {
		String extCss = attachmentMapper.queryFileCss(fileId);
		return extCss;
	}

	@Override
	public List<AttachmentVO> fileToImg(List<AttachmentVO> attaches, String imeType, Integer imgDpi, String imgSourceType) {
		List<AttachmentVO> resp =new ArrayList<>();
		ByteArrayOutputStream out = null;

		GetObjectResponse getObjectResponse = null;

		try {
			if(CollectionUtils.isNotEmpty(attaches)) {
				for(AttachmentVO attach : attaches) {
					//文件格式验证
					if(!attach.getFileName().endsWith(".pdf")) {
						logger.info("**********文件id-{}转图片跳过，文件非PDF格式，当前不支持进行格式转换**********", attach.getId());
						//当前仅支持PDF转图片
						continue;
					}

					try {
						//文件下载
						logger.info("文件id-{}转图片---STAGE----ONE----文件下载------", attach.getId());
						// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
						String bucketName = minioConfiguration.getBucketName();
						out = new ByteArrayOutputStream();
						getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attach.getFilePath()).build());
						IOUtils.copy(getObjectResponse, out);
						logger.info("文件id-{}转图片---STAGE----ONE----文件下载成功------", attach.getId());

						//文件格式转换
						List<byte[]> imgBytesArr = pdfProcessor.convertPdfToImages(out.toByteArray(), imeType, null != imgDpi ? imgDpi : 300);

						String extName  = getImgFileExtName(imeType);
						SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
						InputStream mfInputStream = null;
						AttachmentEntity attachment = null;
						for(int i=0; i<imgBytesArr.size(); i++) {
							//文件上传
							String objectName = attach.getTenantId().toString() + "/" + format.format(new Date())
									+ "/" + IdWorker.getId() + "." + extName;
							mfInputStream = new ByteArrayInputStream(imgBytesArr.get(i));
							ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder()
									.bucket(minioConfiguration.getBucketName()).object(objectName)
									.stream(mfInputStream, mfInputStream.available(), -1).build());

							//转换后的图片保存信息
							if (StringUtils.isNotBlank(objectResponse.etag())) {
								attachment = new AttachmentEntity();

								attachment.setBillType(attach.getBillType());
								attachment.setSourceId(attach.getId());
								attachment.setSourceType(StringUtils.isNotBlank(imgSourceType) ? imgSourceType : attach.getSourceType()+"-printFormatImg");
								attachment.setMark("printFormatImg");
								attachment.setFileName(attach.getFileName().substring(0, attach.getFileName().indexOf(".")) +
										"(" + i + ")."+extName);
								attachment.setFilePath(objectName);
								attachment.setFileSize(imgBytesArr.get(i).length);
								attachment.setUploadUserName(attach.getUploadUserName());
								attachment.setCreateUserCode(attach.getCreateUserCode());
								attachment.setTenantId(attach.getTenantId());
								attachment.setOnlinePath(fileUrl + objectName);

								super.saveOrUpdate(attachment, false);
								resp.add(BeanMapper.map(attachment, AttachmentVO.class));
							}
						}

						if(CollectionUtils.isNotEmpty(resp)) {
							setFileTruePath(resp);
						}
					} catch (Exception e) {
						logger.error("附件id-{}转换为图片异常,", attach.getId());
						logger.error("附件转换为图片异常,", e);
					} finally {
						if (out != null) {
							try {
								out.flush();
								out.close();
							} catch (IOException e) {
								logger.error("附件转换为图片异常,", e);
							}
						}
						if(getObjectResponse != null) {
							getObjectResponse.close();
						}
					}
				}
			}
		} catch (Exception e) {
			logger.error("附件转换为图片异常", e);
		}

		return resp;
	}

	public void setFileTruePath(List<AttachmentVO> list) {
		if (!ListUtil.isEmpty(list)) {
			list.forEach(f -> {
				String filePath = f.getFilePath();
				if(StringUtils.isNotBlank(filePath) && filePath.indexOf("http") != -1) {
					f.setTruePath(filePath);
				}else{
					f.setTruePath(baseHost+"ejc-file-web/attachment/filePreview?fileId="+f.getId());
				}
				if (StringUtils.isNotBlank(f.getFileFormatPathStr())) {
					f.setFileFormatPath((List<Map<String, String>>) JSONArray.parse(f.getFileFormatPathStr()));
				}
				f.setImgServerPath(fileUrl);
				f.setOnlinePath(baseHost+"ejc-file-web/attachment/filePreview?fileId="+f.getId());
			});
		}
	}

	private String getImgFileExtName(String imeType) {
		switch (imeType) {
			case "PNG":
				return "png";
			case "BMP":
				return "bmp";
			default:
				return "jpg"; // 默认为 JPEG
		}
	}
}
