/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import com.aspose.pdf.Document;
import com.aspose.pdf.devices.BmpDevice;
import com.aspose.pdf.devices.ImageDevice;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.PngDevice;
import com.aspose.pdf.devices.Resolution;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class PdfProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PDF_TO_JPEG_IMG = "JEPG";
    public static final String PDF_TO_BMP_IMG = "BMP";
    public static final String PDF_TO_PNG_IMG = "PNG";

    public List<byte[]> splitPdfToPages(byte[] pdfBytes) {
        return this.processAsync(pdfBytes, (doc, pageIndex) -> {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (Document newDoc = new Document();){
                newDoc.getPages().add(doc.getPages().get_Item(pageIndex + 1));
                newDoc.save((OutputStream)output);
                byte[] byArray = output.toByteArray();
                return byArray;
            }
        });
    }

    public List<byte[]> convertPdfToImages(byte[] pdfBytes, String imageFormat, int dpi) {
        return this.processAsync(pdfBytes, (doc, pageIndex) -> {
            ImageDevice device = this.createImageDevice(imageFormat, new Resolution(dpi));
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                device.process(doc.getPages().get_Item(pageIndex + 1), (OutputStream)output);
                byte[] byArray = output.toByteArray();
                return byArray;
            }
        });
    }

    private <T> List<T> processAsync(byte[] pdfBytes, PdfPageProcessor<T> processor) {
        try (Document doc = null;){
            doc = new Document((InputStream)new ByteArrayInputStream(pdfBytes));
            int totalPages = doc.getPages().size();
            ArrayList<CompletableFuture<T>> futures = new ArrayList<CompletableFuture<T>>(totalPages);
            int pageIndex = 0;
            while (pageIndex < totalPages) {
                int currentPageIndex = pageIndex++;
                futures.add(this.processPageAsync(pdfBytes, currentPageIndex, processor));
            }
            ArrayList results = new ArrayList(totalPages);
            for (CompletableFuture completableFuture : futures) {
                results.add(completableFuture.join());
            }
            ArrayList arrayList = results;
            return arrayList;
        }
    }

    @Async(value="pdfTaskExecutor")
    public <T> CompletableFuture<T> processPageAsync(byte[] pdfBytes, int pageIndex, PdfPageProcessor<T> processor) {
        try (Document doc = null;){
            doc = new Document((InputStream)new ByteArrayInputStream(pdfBytes));
            CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(processor.process(doc, pageIndex));
            return completableFuture;
        }
    }

    private ImageDevice createImageDevice(String format, Resolution resolution) {
        switch (format.toUpperCase()) {
            case "PNG": {
                return new PngDevice(resolution);
            }
            case "BMP": {
                return new BmpDevice(resolution);
            }
        }
        return new JpegDevice(resolution);
    }

    @FunctionalInterface
    private static interface PdfPageProcessor<T> {
        public T process(Document var1, int var2) throws IOException;
    }
}

