package com.ejianc.foundation.file.comsumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: caojie
 * @CreateTime:2025-03-19 16:26
 * @Version: 1.0
 */
@Component
public class FileToImgListener  extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static final String FILE_TO_IMG_QUEUE = "fileToImg";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IAttachmentService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待转换为图片的文件：{}", mqMessage.getBody());
        try {

            JSONObject formatJson = JSONObject.parseObject(mqMessage.getBody().toString());
            service.fileToImg(JSONArray.parseArray(formatJson.getString("attaches"), AttachmentVO.class),
                    formatJson.getString("imgFileType"), formatJson.getInteger("imgFileDpi"), formatJson.getString("imgFileSourceType"));
        } catch (Exception e) {
            logger.error("文件转化为图片消息处理异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{FILE_TO_IMG_QUEUE+"_"+profile};
    }

}
