/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import com.alibaba.druid.util.StringUtils;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.model.FileType;
import com.google.common.collect.Lists;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class FileUtils {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    final String REDIS_FILE_PREVIEW_PDF_KEY = "converted-preview-pdf-file";
    final String REDIS_FILE_PREVIEW_IMGS_KEY = "converted-preview-imgs-file";
    String charset = "utf-8";

    public FileType typeFromUrl(String url) {
        String nonPramStr = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (this.listPictureTypes().contains(fileType.toLowerCase())) {
            return FileType.picture;
        }
        if (this.listOfficeTypes().contains(fileType.toLowerCase())) {
            return FileType.office;
        }
        if (this.listSimpleTexts().contains(fileType.toLowerCase())) {
            return FileType.simText;
        }
        if (this.listMedias().contains(fileType.toLowerCase())) {
            return FileType.media;
        }
        if ("pdf".equalsIgnoreCase(fileType)) {
            return FileType.pdf;
        }
        if (this.listExcelTypes().contains(fileType.toLowerCase())) {
            return FileType.excel;
        }
        return FileType.other;
    }

    public String getFileNameFromURL(String url) {
        String noQueryUrl = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = noQueryUrl.substring(noQueryUrl.lastIndexOf("/") + 1);
        return fileName;
    }

    public String getSuffixFromFileName(String fileName) {
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        return suffix;
    }

    public String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public List<String> listMedias() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public List<String> listSimpleTexts() {
        ArrayList list = Lists.newArrayList();
        list.add("txt");
        return list;
    }

    public List<String> listPictureTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("jpg");
        list.add("jpeg");
        list.add("png");
        list.add("gif");
        list.add("bmp");
        list.add("ico");
        list.add("RAW");
        return list;
    }

    public List<String> listArchiveTypes() {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public List<String> listOfficeTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("docx");
        list.add("doc");
        list.add("wps");
        list.add("ppt");
        list.add("pptx");
        return list;
    }

    public List<String> listExcelTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("xls");
        list.add("xlsx");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileEncodeUTFGBK(String path) {
        String enc = Charset.forName("GBK").name();
        File file = new File(path);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] b = new byte[3];
            ((InputStream)in).read(b);
            if (b[0] == -17 && b[1] == -69 && b[2] == -65) {
                enc = Charset.forName("UTF-8").name();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\u4e3a:" + enc);
        return enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActionConvertedFile(String outFilePath) {
        StringBuffer sb = new StringBuffer();
        FileInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = new FileInputStream(outFilePath);
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, this.charset));
            while (null != (line = reader.readLine())) {
                if (line.contains("charset=gb2312")) {
                    line = line.replace("charset=gb2312", "charset=utf-8");
                }
                sb.append(line);
            }
            sb.append("<script src=\"js/jquery-3.0.0.min.js\" type=\"text/javascript\"></script>");
            sb.append("<script src=\"js/excel.header.js\" type=\"text/javascript\"></script>");
            sb.append("<link rel=\"stylesheet\" href=\"http://cdn.static.runoob.com/libs/bootstrap/3.3.7/css/bootstrap.min.css\">");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        try {
            fos = new FileOutputStream(outFilePath);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.charset));
            writer.write(sb.toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream doActionConvertedFile(InputStream is) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is, this.charset));
            while (null != (line = reader.readLine())) {
                if (line.contains("charset=gb2312")) {
                    line = line.replace("charset=gb2312", "charset=utf-8");
                }
                sb.append(line);
            }
            sb.append("<script src=\"js/jquery-3.0.0.min.js\" type=\"text/javascript\"></script>");
            sb.append("<script src=\"js/excel.header.js\" type=\"text/javascript\"></script>");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ByteArrayOutputStream bos = null;
        BufferedWriter writer = null;
        try {
            int ch;
            bos = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                bos.write(ch);
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bos, this.charset));
            writer.write(sb.toString());
            writer.close();
            ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String suffixFromUrl(String url) {
        String nonPramStr = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        return fileType;
    }

    public FileAttribute getFileAttribute(String url) {
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.debug("url\u89e3\u7801\u5931\u8d25");
        }
        FileType type = this.typeFromUrl(url);
        String suffix = this.suffixFromUrl(url);
        String fileName = this.getFileNameFromURL(decodedUrl);
        return new FileAttribute(type, suffix, fileName, url, decodedUrl);
    }

    public GetObjectResponse downloadFileByKeyName(String keyName) {
        try {
            GetObjectResponse getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(keyName)).build());
            return getObjectResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileExt(String filename, Boolean withPoint) {
        if (StringUtils.isEmpty((String)filename) || filename.lastIndexOf(46) == -1) {
            return "";
        }
        if (withPoint == null) {
            withPoint = true;
        }
        int index = -1;
        index = withPoint != false ? filename.lastIndexOf(46) : filename.lastIndexOf(46) + 1;
        String extName = filename.substring(index).toLowerCase();
        return extName;
    }
}

