package com.ejianc.foundation.file.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.util.List;

@Mapper
public interface AttachmentMapper extends BaseCrudMapper<AttachmentEntity> {

	void updateAttachRef(@Param("sourceId") Long sourceId,@Param("attachId") Long attachId);
	
	public AttachmentVO queryByFilePath(@Param("filePath") String filePath);

	void updateOnlinePath(@Param("filePath") String filePath,@Param("onlinePath") String onlinePath);

	void deleteIds(@Param("ids") String ids);

    void updateAttachArchiveStatus(@Param("ids") List<Long> attachIds, @Param("status") String status);

	void deleteFileByParams(@Param("sourceId") Long sourceId,@Param("billType") String billType,@Param("sourceType") String sourceType,@Param("fileName") String fileName);

	void deleteFileByParam(@Param("sourceId") Long sourceId,@Param("billType") String billType,@Param("sourceType") String sourceType);

	List<AttachmentVO> queryMyFavoriteList(@Param("userCode") String userCode, @Param("search") String search);

	List<AttachmentVO> queryRecentList(@Param("userCode") String userCode, @Param("search") String search);

	List<AttachmentVO> queryListByBillType(@Param("billCode") String billCode,@Param("tenantId") Long tenantId,@Param("search") String search);

	void updateFileCss(@Param("fileId") String fileId,@Param("extcss") String extcss);

	String queryFileCss(@Param("fileId") String fileId);
}
