package com.ejianc.foundation.file.service;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.util.FileUtils;

@Service
public class FilePreviewFactory {

	@Autowired
	FileUtils fileUtils;

	@Autowired
	ApplicationContext context;

	public FilePreview get(String url) {
		Map<String, FilePreview> filePreviewMap = context.getBeansOfType(FilePreview.class);
		FileAttribute fileAttribute = fileUtils.getFileAttribute(url);
		return filePreviewMap.get(fileAttribute.getType().getInstanceName());
	}
}
