/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.ejianc.foundation.file.util.ConverterUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfficeToPdf {
    @Autowired
    ConverterUtils converterUtils;

    public boolean openOfficeToPDF(String inputFilePath, String outputFilePath) {
        return this.office2pdf(inputFilePath, outputFilePath);
    }

    public static void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath, DocumentConverter converter) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            converter.convert(inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean converterFile(InputStream inputStream, String sourceSurfix, OutputStream outputStream, String destSurfix) {
        Map<String, Object> resultMap = this.converterUtils.getDocumentConverter();
        DocumentConverter converter = (DocumentConverter)resultMap.get("converter");
        OpenOfficeConnection connection = (OpenOfficeConnection)resultMap.get("openOfficeConnection");
        boolean convertFlag = false;
        try {
            converter.convert(inputStream, new DefaultDocumentFormatRegistry().getFormatByFileExtension(sourceSurfix), outputStream, new DefaultDocumentFormatRegistry().getFormatByFileExtension(destSurfix));
            convertFlag = true;
            Boolean bl = convertFlag;
            return bl;
        }
        catch (Exception e) {
            convertFlag = false;
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
        return convertFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean office2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        OpenOfficeConnection connection = null;
        try {
            Map<String, Object> resultMap = this.converterUtils.getDocumentConverter();
            DocumentConverter converter = (DocumentConverter)resultMap.get("converter");
            connection = (OpenOfficeConnection)resultMap.get("openOfficeConnection");
            if (null != inputFilePath) {
                File inputFile = new File(inputFilePath);
                if (null == outputFilePath) {
                    String outputFilePath_end = OfficeToPdf.getOutputFilePath(inputFilePath);
                    if (inputFile.exists()) {
                        OfficeToPdf.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath, converter);
                        flag = true;
                    }
                } else if (inputFile.exists()) {
                    OfficeToPdf.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath, converter);
                    flag = true;
                }
            } else {
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return flag;
    }

    public static String getOutputFilePath(String inputFilePath) {
        String outputFilePath = inputFilePath.replaceAll("." + OfficeToPdf.getPostfix(inputFilePath), ".pdf");
        return outputFilePath;
    }

    public static String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}

