package com.ejianc.foundation.file.controller.api;

import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.file.util.PdfProcessor;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BASE64DecodedMultipartFile;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.PicRotateUtils;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import sun.misc.BASE64Decoder;

@RestController
@RequestMapping
public class AttachmentRefApi {

	private static Logger logger = LoggerFactory.getLogger(AttachmentRefApi.class);

	@Autowired
	private IAttachmentService attachmentService;

	@Autowired
	private MinioClient minioClient;
	@Autowired
	private MinioConfiguration minioConfiguration;
	@Autowired
	private IEmployeeApi employeeApi;
	@Value("${fileUrl}")
	private String fileUrl;


	/**
	 * PDF转图片
	 * @param params
	 * @return
	 */
	@PostMapping(value = "/api/attachref/fileToImg")
	public CommonResponse<List<AttachmentVO>> pdfFileToImg(@RequestBody JSONObject params) {
		List<AttachmentVO> resp = new ArrayList<>();
		List<Long> sourceIds = new ArrayList<>();
		List<Long> fileIds = new ArrayList<>();
		List<String> sourceTypes = new ArrayList<>();
		List<String> billTypes = new ArrayList<>();
		if(null == params.get("sourceIds") && null == params.get("fileIds")) {
			return CommonResponse.error("操作失败, 参数：sourceIds、fileIds不能同时为空！");
		}

		QueryParam query = new QueryParam();
		if(null != params.get("sourceIds")) {
			query.getParams().put("sourceId", Parameter.getInInstance(Arrays.asList(params.getString("sourceIds").split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList())));
		}
		if(null != params.get("fileIds")) {
			query.getParams().put("id", Parameter.getInInstance(Arrays.asList(params.getString("fileIds").split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList())));
		}
		if(null != params.get("sourceTypes")) {
			query.getParams().put("sourceType", Parameter.getInInstance(Arrays.asList(params.getString("sourceType").split(","))));
		}
		if(null != params.get("billTypes")) {
			query.getParams().put("billTypes", Parameter.getInInstance(Arrays.asList(params.getString("billTypes").split(","))));
		}
		List<AttachmentEntity> attachmentEntities = attachmentService.queryList(query);
		List<String> fileType = Arrays.asList(new String[]{"jpg", "bmp", "png", "jpeg"});
		if(CollectionUtils.isNotEmpty(attachmentEntities)) {
			List<AttachmentEntity> imgFile = new ArrayList<>();
			List<Long> toTransferFileIds = new ArrayList<>();
			attachmentEntities.stream().forEach(file -> {
				if(fileType.contains(FileUtils.getFileExt(file.getFileName(), false))) {
					//若为图片则直接使用
					imgFile.add(file);
				} else if("pdf".equals(FileUtils.getFileExt(file.getFileName(), false))) {
					//若为PDF文件则执行 生成图片文件逻辑
					toTransferFileIds.add(file.getId());
				}
			});
			if(CollectionUtils.isNotEmpty(imgFile)) {
				resp.addAll(BeanMapper.mapList(imgFile, AttachmentVO.class));
			}
			if(CollectionUtils.isNotEmpty(toTransferFileIds)) {
				//查询PDF文件是否存在对应图片文件
				QueryWrapper queryWrapper = new QueryWrapper();
				queryWrapper.in("source_id", toTransferFileIds);
				queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
				List<AttachmentEntity> imgList = attachmentService.list(queryWrapper);
				if(CollectionUtils.isNotEmpty(imgList)) {
					for(AttachmentEntity attach : imgList) {
						resp.add(BeanMapper.map(attach, AttachmentVO.class));
						toTransferFileIds.remove(attach.getSourceId());
					}
				}
				if(CollectionUtils.isNotEmpty(toTransferFileIds)) {
					List<AttachmentEntity> dbList = (List<AttachmentEntity>) attachmentService.listByIds(toTransferFileIds);
					List<AttachmentVO> ismg = attachmentService.fileToImg(BeanMapper.mapList(dbList, AttachmentVO.class), PdfProcessor.PDF_TO_JPEG_IMG, 300, null);
					resp.addAll(ismg.stream().filter(item -> null != item).collect(Collectors.toList()));
				}
			}
		}

		return CommonResponse.success("文件处理成功！", resp);
	}

	@GetMapping(value = "/api/attachref/queryListBySourceId")
	public CommonResponse<List<AttachmentVO>>  queryListBySourceId(@RequestParam(name = "sourceId", required = false) Long sourceId,
																   @RequestParam(name = "billType", required = false) String billType,
																   @RequestParam(name = "sourceType", required = false) String sourceType,
																   @RequestParam(name = "orderType", required = false) String orderType) {
		QueryParam queryParam = new QueryParam();
		if(null == sourceId) {
			return CommonResponse.success("sourceId为空，查询不到匹配的文件信息！");
		}

		if(StringUtils.isBlank(orderType)) {
			orderType = "desc";
		}
		queryParam.getOrderMap().put("createTime", orderType);
		queryParam.getOrderMap().put("id", "desc");
		Map<String, Parameter> params = queryParam.getParams();
		params.put("sourceId", new Parameter("eq",sourceId));
		if(StringUtils.isNotBlank(sourceType)){
			params.put("sourceType", new Parameter("eq",sourceType));
		}
		if(StringUtils.isNotBlank(billType)){
			params.put("billType", new Parameter("eq",billType));
		}

		return queryList(queryParam);
	}

    /**
     * @param paramStr {"sourceIds":[], "orderType":"desc"}
     * @return
     */
	@PostMapping(value = "/api/attachref/queryListBySourceIds")
	public CommonResponse<List<AttachmentVO>> queryAllBySourceIdList(@RequestBody JSONObject paramStr) {
		QueryParam queryParam = new QueryParam();
		List<Long> sourceIdList = JSONArray.parseArray(paramStr.getString("sourceIds"), Long.class);
		List<String> sourceTypeList = new ArrayList<>();
		if(null != paramStr.getString("sourceTypeList")) {
			sourceTypeList.addAll(JSONArray.parseArray(paramStr.getString("sourceTypeList"), String.class));
		}
		String orderType = paramStr.getString("orderType");
		if(CollectionUtils.isEmpty(sourceIdList)) {
			return CommonResponse.success("sourceId列表为空，查询不到匹配的文件信息！");
		}
		if(StringUtils.isBlank(orderType)) {
			orderType = "desc";
		}
		queryParam.getOrderMap().put("createTime", orderType);
		Map<String, Parameter> params = queryParam.getParams();
		params.put("sourceId", new Parameter(QueryParam.IN, sourceIdList));
		if(!sourceTypeList.isEmpty()) {
			params.put("sourceType", new Parameter(QueryParam.IN, sourceTypeList));
		}

		return queryList(queryParam);
	}

	class FileFromNetCallable implements Callable<String> {
		private UploadFileForNetParam param;
		private String filePath;
		private Long fileId;
		private String newFileName;

		public FileFromNetCallable(UploadFileForNetParam param, String filePath) {
			this.param = param;
			this.filePath = filePath;
		}

		public FileFromNetCallable(UploadFileForNetParam param, String filePath, Long newFileId) {
			this.param = param;
			this.filePath = filePath;
			this.fileId = newFileId;
		}

        public FileFromNetCallable(UploadFileForNetParam param, String filePath, Long fileId, String newFileName) {
            this.param = param;
            this.filePath = filePath;
            this.fileId = fileId;
            this.newFileName = newFileName;
        }

        @Override
		public String call() throws Exception {
			String fileName = filePath.split("\\?")[0];
			String fileExt = com.ejianc.framework.core.util.FileUtils.getFileExt(fileName, false);
			if (fileExtInBlackList(fileExt)) {
                logger.error("不允许上传" + fileExt + "格式文件");
                throw new BusinessException("不允许上传" + fileExt + "格式文件");
            }
			
			ByteArrayInputStream bis = null;
			try {
				byte[] fileBytes = HttpTookit.downloadFromNet(filePath);
				if(null == fileBytes) {
					throw new BusinessException("文件下载失败，下载地址：" + filePath );
				}
				bis = new ByteArrayInputStream(fileBytes);
				
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String yearMonth = format.format(new Date());
				String objectFileName = yearMonth  + "-" + IdWorker.getId() + (StringUtils.isNotBlank(fileExt)?("."+fileExt):".png");
				String objectName = param.getTenantId() + "/" + yearMonth + "/" + objectFileName;
				
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(bis, bis.available(), -1).build());
				
				if (StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(param.getBillType());
					attachment.setSourceId(param.getSourceId());
					attachment.setSourceType(param.getSourceType());
					attachment.setFileName(StringUtils.isNotBlank(newFileName) ? newFileName : objectFileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(Long.valueOf(fileBytes.length));
					if(null != fileId) {
						attachment.setId(fileId);
					}
					attachment.setTenantId(param.getTenantId());
					
					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					attachmentService.saveOrUpdate(entity, false);
				}
			}catch(Exception e) {
				logger.error("异步文件【{}】下载异常：", JSONObject.toJSONString(param), e);
			}finally {
					bis.close();
			}
			return "success";
		}
	}
	
	@PostMapping(value = "/no_auth/api/attachref/uploadFileFormNet")
	public CommonResponse<String>  uploadFileFormNet(@RequestBody UploadFileForNetParam param) {
		logger.info("异步文件下载：{}", JSONObject.toJSONString(param));
		if(param.getTenantId() == null) {
			return CommonResponse.error("租户Id不能为空！");
		}
		if(param.getSourceId() == null) {
			return CommonResponse.error("sourceId不能为空！");
		}
		List<String> filePathList = param.getFilePathList();
		int idx = 0;
		Long newFileId = null;
		String newFileName;
		List<Long> newFileIds = CollectionUtils.isEmpty(param.getNewFileIds()) ? new ArrayList<>() : param.getNewFileIds();
		List<String> newFileNames = CollectionUtils.isEmpty(param.getNewFileNames()) ? new ArrayList<>() : param.getNewFileNames();
		if(filePathList != null && filePathList.size() > 0) {
			int threadCount = (filePathList.size() > 5 ? 5 : filePathList.size());
			ExecutorService threadPool = Executors.newFixedThreadPool(threadCount);
			
			List<Future<String>> futureList = new ArrayList<>();
			for(String filePath:filePathList) {
				newFileId = newFileIds.size() > idx ? newFileIds.get(idx) : IdWorker.getId();
                newFileName = newFileNames.size() > idx ? newFileNames.get(idx++) : null;
				futureList.add(threadPool.submit(new FileFromNetCallable(param, filePath, newFileId, newFileName)));
			}
			
			for(Future<String> future:futureList) {
				try {
					logger.info("----result ====="+future.get());
				} catch (Exception e) {}
			}
			
			threadPool.shutdown();
		}
		return CommonResponse.success("上传成功");
	}

	private CommonResponse<List<AttachmentVO>> queryList(QueryParam queryParam) {
		List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);
		setFileTruePath(list);
		return CommonResponse.success(list);
	}

	@PostMapping(value = "/api/attachref/updateAttachArchiveStatus")
	public CommonResponse<String> updateAttachArchiveStatus(@RequestBody String param) {
		JSONObject jsonParam = JSONObject.parseObject(param);
		String status = jsonParam.getString("status");
		List<Long> attachIds = JSONArray.parseArray(jsonParam.getString("attachIds"), Long.class);
		attachmentService.updateAttachArchiveStatus(attachIds, status);

		return CommonResponse.success("操作成功！");
	}

	@GetMapping(value = "/api/attachref/detailById")
	public CommonResponse<AttachmentVO> queryAttachmentDetail(Long fileId) {
		AttachmentEntity attach = attachmentService.selectById(fileId);
		return CommonResponse.success(BeanMapper.map(attach, AttachmentVO.class));
	}

	@PostMapping(value = "/api/attachref/queryAllByIds")
	public CommonResponse<List<AttachmentVO>> queryAllByIds(@RequestBody List<Long> fileIds) {
		List<AttachmentVO> attachs = attachmentService.queryAllByIds(fileIds);
		return CommonResponse.success(attachs);
	}

	@RequestMapping(value = "/api/attachref/update", method=RequestMethod.GET)
	public CommonResponse<String> updateAttachRef(@RequestParam(name = "sourceId") Long sourceId,@RequestParam(name = "attachIds") List<Long> attachIds) {

		attachmentService.updateAttachRef(sourceId,attachIds);
		return CommonResponse.success();
	}

	/**
	 * 删除
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam(name="ids") String ids) {
		return attachmentService.delete(ids);
	}

	/**
	 * 根据参数删除附件
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/deleteFileByParams", method = RequestMethod.GET)
	public CommonResponse<String> deleteFileByParams(@RequestParam(name = "sourceId") Long sourceId,
													 @RequestParam(name = "billType") String billType,
													 @RequestParam(name = "sourceType") String sourceType,
													 @RequestParam(name = "fileNames") List<String> fileNames)  {
		attachmentService.deleteFileByParams(sourceId, billType, sourceType, fileNames);
		return CommonResponse.success();
	}

	/**
	 * 根据参数删除附件
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/deleteFileByParam", method = RequestMethod.GET)
	public CommonResponse<String> deleteFileByParam(@RequestParam(name = "sourceId") Long sourceId,
													@RequestParam(name = "billType") String billType,
													@RequestParam(name = "sourceType") String sourceType)  {
		attachmentService.deleteFileByParam(sourceId, billType, sourceType);
		return CommonResponse.success();
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/9/4 将文件
	 * @Description copyFilesFromSourceBillToTargetBill
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 * @param sourceBillId 从此id单据复制
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 */
	@RequestMapping(value = "/api/attachref/copyFromSourceBillToTargetBill", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> copyFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId,
																	  @RequestParam(name="sourceBillType") String sourceBillType,
																	  @RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
																	  @RequestParam(name="targetBillId") String targetBillId,
																	  @RequestParam(name="targetBillType") String targetBillType,
																	  @RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType) {

		try {
			logger.info("根据参数复制文件，参数：sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}",
					sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType);
			List<AttachmentVO> resp = copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, false, null);
			return CommonResponse.success("文件复制成功！", resp);
		} catch (Exception e) {
			logger.error("根据参数sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}复制文件异常",
					sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, e);
			return CommonResponse.error("文件复制失败！");
		}
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/9/4 将文件
	 * @Description copyFilesFromSourceBillToTargetBill
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 * @param sourceBillId 从此id单据复制
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 */
	@RequestMapping(value = "/api/attachref/copyFilesFromSourceBillToTargetBill", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> copyFilesFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId,
																	  @RequestParam(name="sourceBillType") String sourceBillType,
																	  @RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
																	  @RequestParam(name="targetBillId") String targetBillId,
																	  @RequestParam(name="targetBillType") String targetBillType,
																	  @RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType) {

		try {
			List<AttachmentVO> resp = copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, false, null);
			return CommonResponse.success("文件复制成功！");
		} catch (Exception e) {
			logger.error("根据参数sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}复制文件异常",
					sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, e);
			return CommonResponse.error("文件复制失败！");
		}
	}

	/***
	 * 文件复制
	 *
	 * @param sourceBillId 从此id单据复制
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @param clearTargetFile 复制前是否
	 */
	@RequestMapping(value = "/api/attachref/copyFiles", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> copyFiles(@RequestParam(name="sourceBillId") String sourceBillId,
														@RequestParam(name="sourceBillType", required = false) String sourceBillType,
														@RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
														@RequestParam(name="targetBillId") String targetBillId,
														@RequestParam(name="targetBillType", required = false) String targetBillType,
														@RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType,
														@RequestParam(name = "clearTargetFile") boolean clearTargetFile) {
		try {
			List<AttachmentVO> resp = copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, clearTargetFile, null);
			return CommonResponse.success(resp);
		} catch (Exception e) {
			logger.error("根据参数sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}复制文件异常",
					sourceBillId, sourceBillType, sourceBillSourceType,
					targetBillId, targetBillType, targetBillSourceType, e);
			return CommonResponse.error("文件复制失败！");
		}
	}

	/***
	 * @param sourceFileId  源文件id
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @param clearTargetFile
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/copyFile", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<AttachmentVO> copyFile(@RequestParam(name="sourceFileId") String sourceFileId,
												 @RequestParam(name="targetBillId") String targetBillId,
												 @RequestParam(name="targetBillType") String targetBillType,
												 @RequestParam(name="targetBillSourceType") String targetBillSourceType,
												 @RequestParam(name = "clearTargetFile") boolean clearTargetFile) {
		try {
			List<AttachmentVO> resp = copyFilesNew(null, null, null,
					targetBillId, targetBillType, targetBillSourceType, clearTargetFile, sourceFileId);
			return CommonResponse.success(resp.get(0));
		} catch (Exception e) {
			logger.error("根据参数sourceFileId-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}复制文件异常",
					sourceFileId, targetBillId, targetBillType, targetBillSourceType, e);
			return CommonResponse.error("文件复制失败！");
		}
	}

	/***
	 * 批量复制sourceFileIds文件到指定目标单据
	 *
	 * @param sourceFileIds  源文件id
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/copyFileBeach", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> copyFileBeach(@RequestBody List<String> sourceFileIds,
												 @RequestParam(name="targetBillId") String targetBillId,
												 @RequestParam(name="targetBillType") String targetBillType,
												 @RequestParam(name="targetBillSourceType") String targetBillSourceType) {
		if(ListUtil.isEmpty(sourceFileIds)){
			return CommonResponse.error("参数sourceFileIds不能为空！");
		}
		if(StringUtils.isEmpty(targetBillId)){
			return CommonResponse.error("参数targetBillId不能为空！");
		}
		List<AttachmentVO> resp = new ArrayList<>();
		try {
			QueryParam queryParam = new QueryParam();
			Map<String, Parameter> params = queryParam.getParams();
			params.put("id", new Parameter(QueryParam.IN,sourceFileIds));
			List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);
			if(ListUtil.isEmpty(list)){
				return CommonResponse.error("原始文件不存在！");
			}
			List<AttachmentEntity> entityList = new ArrayList<>();
			for (AttachmentVO file : list) {
				file.setId(IdWorker.getId());
				file.setBillType(StringUtils.isNotBlank(targetBillType) ? targetBillType : file.getBillType());
				file.setSourceType(StringUtils.isNotBlank(targetBillSourceType) ? targetBillSourceType : file.getSourceType());
				file.setSourceId(Long.parseLong(targetBillId));
				file.setVersion(0);
				/** 增加判重逻辑 */
				QueryWrapper<AttachmentEntity> queryRepeat = new QueryWrapper<>();
				queryRepeat.eq("source_id", targetBillId);
				queryRepeat.eq("source_type",  file.getSourceType());
				queryRepeat.eq("bill_type", file.getBillType());
				queryRepeat.eq("file_path", file.getFilePath());
				queryRepeat.eq("dr", BaseVO.DR_UNDELETE);
				List<AttachmentEntity> exist = attachmentService.list(queryRepeat);
				if(ListUtil.isEmpty(exist)){
					AttachmentEntity entity = BeanMapper.map(file, AttachmentEntity.class);
					entityList.add(entity);
				}else {
					logger.info("目标单据已存在该文件：id-{},targetBillType-{}，targetBillSourceType-{}，targetBillId-{},filePath-{}",exist.get(0).getId(),targetBillType,targetBillSourceType,targetBillId,file.getFilePath());
				}
			}
			if(ListUtil.isNotEmpty(entityList)){
				attachmentService.saveOrUpdateBatch(entityList);
				resp = BeanMapper.mapList(entityList, AttachmentVO.class);
			}
		} catch (Exception e) {
			logger.error("根据参数 批量复制 targetBillId-{}, targetBillType-{}, targetBillSourceType-{}复制文件异常",
					 targetBillId, targetBillType, targetBillSourceType, e);
			return CommonResponse.error("文件复制失败！");
		}
		return CommonResponse.success(resp);
	}

	private List<AttachmentVO> copyFilesNew(String sourceBillId, String sourceBillType, String sourceBillSourceType, String targetBillId, String targetBillType,
											String targetBillSourceType, boolean clearTargetFile, String sourceFileId) {
		List<AttachmentVO> resp = new ArrayList<>();

		if(StringUtils.isBlank(sourceBillId) && StringUtils.isBlank(sourceFileId)) {
			throw new BusinessException("参数sourceBillId和sourceFileId不能同时为空！");
		}
		Integer newVersion = -1;

		QueryParam queryParam = new QueryParam();
		Map<String, Parameter> params = queryParam.getParams();
		if(StringUtils.isNotBlank(sourceBillId)) {
			params.put("sourceId", new Parameter("eq",sourceBillId));
		}
		if(StringUtils.isNotBlank(sourceBillSourceType)){
			params.put("sourceType", new Parameter("eq",sourceBillSourceType));
		}
		if(StringUtils.isNotBlank(sourceBillType)){
			params.put("billType", new Parameter("eq",sourceBillType));
		}
		if(StringUtils.isNotBlank(sourceFileId)){
			params.put("id", new Parameter("eq",sourceFileId));

			List<AttachmentVO> oldFiles = attachmentService.findFileList(InvocationInfoProxy.getTenantid(), targetBillId, targetBillSourceType, targetBillType);
			if(CollectionUtils.isNotEmpty(oldFiles)) {
				newVersion = oldFiles.stream().sorted(Comparator.comparing(AttachmentVO::getVersion).reversed()).collect(Collectors.toList()).get(0).getVersion();
			}
		}
		List<AttachmentVO> list = attachmentService.queryListByParams(queryParam);
		List<AttachmentEntity> entityList = null;
		if(ListUtil.isNotEmpty(list)){
			entityList = new ArrayList<>();
			List<AttachmentEntity> finalEntityList = entityList;
			list.forEach(file->{
				file.setId(IdWorker.getId());
				file.setBillType(StringUtils.isNotBlank(targetBillType) ? targetBillType : file.getBillType());
				file.setSourceType(StringUtils.isNotBlank(targetBillSourceType) ? targetBillSourceType : file.getSourceType());
				file.setSourceId(Long.parseLong(targetBillId));
				/** 增加判重逻辑 */
				QueryWrapper<AttachmentEntity> queryRepeat = new QueryWrapper<>();
				queryRepeat.eq("source_id", targetBillId);
				queryRepeat.eq("source_type", StringUtils.isNotBlank(targetBillSourceType) ? targetBillSourceType : file.getSourceType());
				queryRepeat.eq("bill_type", StringUtils.isNotBlank(targetBillType) ? targetBillType : file.getBillType());
				queryRepeat.eq("file_path", file.getFilePath());
				queryRepeat.eq("dr", BaseVO.DR_UNDELETE);
				List<AttachmentEntity> exist = attachmentService.list(queryRepeat);
				if(ListUtil.isEmpty(exist) || clearTargetFile){
					AttachmentEntity entity = BeanMapper.map(file, AttachmentEntity.class);
					finalEntityList.add(entity);
				}else {
					logger.info("目标单据已存在该文件：id-{},targetBillType-{}，targetBillSourceType-{}，targetBillId-{},filePath-{}",exist.get(0).getId(),targetBillType,targetBillSourceType,targetBillId,file.getFilePath());
				}
			});
			if(ListUtil.isNotEmpty(finalEntityList)){
				//对比版本号取最大的一方，WPS文件保存逻辑使用
				if(StringUtils.isNotBlank(sourceFileId)){
					AttachmentEntity tmp = finalEntityList.get(0);
					if(newVersion.compareTo(tmp.getVersion()) > 0) {
						tmp.setVersion(newVersion + 1);
					}
				}

				if(clearTargetFile) {
					logger.info("物理删除文件参数：sourceId-{},billType-{},sourceType-{}",Long.valueOf(targetBillId), targetBillType, targetBillSourceType);
					attachmentService.deleteFileByParam(Long.valueOf(targetBillId), targetBillType, targetBillSourceType);
				}
				attachmentService.saveOrUpdateBatch(finalEntityList);
				resp = BeanMapper.mapList(finalEntityList, AttachmentVO.class);
			}
		}
		return resp;
	}

	/**
	 * base64上传
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/uploadForBase64", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> uploadForBase64(@RequestBody AttachmentRequestVO request) {
		String billType = request.getBillType();
		String sourceId = request.getSourceId();
		String sourceType = request.getSourceType();
//		boolean handleImg = request.getHandleImg();
		if(StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}
		//文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		//文件类型判断
		for (String fileStr : request.getFileList()) {
			MultipartFile mf = base64ToMultipart(fileStr);
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if(mf.getSize()>sizeLimit){
				logger.error("限定大小为："+sizeLimit+"，文件大小为："+mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		InputStream mfInputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				String bucketName = minioConfiguration.getBucketName();
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				
				mfInputStream = mf.getInputStream();
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(mfInputStream, mfInputStream.available(), -1).build());
				if(StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if(StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					Long userId = InvocationInfoProxy.getUserid();
					CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
					if(employeeResponse.isSuccess()) {
						attachment.setUploadUserName(employeeResponse.getData().getName());
					}

					//文件压缩等处理
//					if(handleImg && fileUtils.listPictureTypes().contains(fileUtils.getSuffixFromFileName(fileName).replace(".", "").toLowerCase())) {
//						formatImg(attachment, request);
//					}

					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
//					attachmentService.saveOrUpdate(entity, false);
					entity.setOnlinePath(fileUrl+objectName);
					resultEntity.add(entity);
				}
			}

			if(CollectionUtils.isNotEmpty(resultEntity)) {
				attachmentService.saveOrUpdateFileList(resultEntity, request.getClearBeforeSave());
			}

			List<AttachmentVO> resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
			setFileTruePath(resultList);
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			throw new BusinessException("文件上传失败，Msg："+ex.getMessage());
		}finally{
			if(mfInputStream != null) {
				try {
					mfInputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * base64上传(签名--支持旋转)
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/uploadSignatureForBase64", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> uploadSignatureForBase64(@RequestBody AttachmentRequestVO request) {
		String billType = request.getBillType();
		String sourceId = request.getSourceId();
		String sourceType = request.getSourceType();
		Integer rotate = request.getRotate();
//		boolean handleImg = request.getHandleImg();
		if(StringUtils.isBlank(billType)) {
			return CommonResponse.error("业务类型不能为空，可以传单据类型编号！");
		}
		//文件列表
		List<MultipartFile> fileList = new ArrayList<MultipartFile>();
		//文件类型判断
		for (String fileStr : request.getFileList()) {
			MultipartFile mf = base64ToMultipart(fileStr);
			String originalFilename = mf.getOriginalFilename();
			if (mf.getSize() == 0L) {
				logger.error(mf.getOriginalFilename() + "大小不能为0");
				throw new BusinessException("上传了空文件");
			}
			originalFilename = originalFilename.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFilename.replaceAll("00.", "");
			String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);

			if (fileExtInBlackList(extName)) {
				logger.error("不允许上传" + extName + "格式文件");
				throw new BusinessException("不允许上传" + extName + "格式文件");
			}
			Integer sizeLimit = minioConfiguration.getSizeLimit();
			if(mf.getSize()>sizeLimit){
				logger.error("限定大小为："+sizeLimit+"，文件大小为："+mf.getSize());
				throw new BusinessException("上传了大于限定大小的文件");
			}
			fileList.add(mf);
		}

		InputStream inputStream = null;
		try {
			List<AttachmentEntity> resultEntity = new ArrayList<>();
			for (MultipartFile mf : fileList) {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
				String fileName = mf.getOriginalFilename();
				String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
				originalFilename.replaceAll("00.", "");
				String extName = com.ejianc.framework.core.util.FileUtils.getFileExt(originalFilename, false);
				String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
				if(rotate!=null&&rotate>0){
					BufferedImage src = ImageIO.read(mf.getInputStream());
					BufferedImage des = PicRotateUtils.Rotate(src, rotate);
					
					ByteArrayOutputStream bs = new ByteArrayOutputStream();
					ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
					ImageIO.write(des, "png", imOut);
					inputStream = new ByteArrayInputStream(bs.toByteArray());
					
				}else{
					inputStream = mf.getInputStream();
				}
				
				ObjectWriteResponse objectResponse = minioClient.putObject(PutObjectArgs.builder().bucket(minioConfiguration.getBucketName()).object(objectName).stream(inputStream, inputStream.available(), -1).build());
				if(StringUtils.isNotBlank(objectResponse.etag())) {
					AttachmentVO attachment = new AttachmentVO();
					attachment.setBillType(billType);
					if(StringUtils.isNotBlank(sourceId)) {
						attachment.setSourceId(Long.parseLong(sourceId));
					}
					attachment.setSourceType(sourceType);
					attachment.setFileName(fileName);
					attachment.setFilePath(objectName);
					attachment.setFileSize(mf.getSize());
					Long userId = InvocationInfoProxy.getUserid();
					CommonResponse<EmployeeVO> employeeResponse = employeeApi.queryEmployeByUserId(userId);
					if(employeeResponse.isSuccess()) {
						attachment.setUploadUserName(employeeResponse.getData().getName());
					}

					//文件压缩等处理
//					if(handleImg && fileUtils.listPictureTypes().contains(fileUtils.getSuffixFromFileName(fileName).replace(".", "").toLowerCase())) {
//						formatImg(attachment, request);
//					}

					AttachmentEntity entity = BeanMapper.map(attachment, AttachmentEntity.class);
					attachmentService.saveOrUpdate(entity, false);
					entity.setOnlinePath(fileUrl+objectName);
					resultEntity.add(entity);
				}
			}
			List<AttachmentVO> resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
			setFileTruePath(resultList);
			return CommonResponse.success(resultList);
		} catch (Exception ex) {
			logger.error("文件上传失败", ex);
			throw new BusinessException("文件上传失败，Msg："+ex.getMessage());
		}finally {
			if(inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}


	/**
	 *  base64字符串转成MultipartFile格式
	 * @param base64
	 * @return
	 */
	private MultipartFile base64ToMultipart(String base64) {
		try {
			String[] baseStrs = base64.split(",");

			BASE64Decoder decoder = new BASE64Decoder();
			byte[] b = new byte[0];
			if(baseStrs.length > 1) {
				b = decoder.decodeBuffer(baseStrs[1]);
			}else{
				b = decoder.decodeBuffer(baseStrs[0]);
			}

			for (int i = 0; i < b.length; ++i) {
				if (b[i] < 0) {
					b[i] += 256;
				}
			}
			if(baseStrs.length > 1) {
				return new BASE64DecodedMultipartFile(b, baseStrs[0]);
			}else{
				return new BASE64DecodedMultipartFile(b, "data:image/png;base64");
			}
		} catch (IOException e) {
			logger.error(e.getMessage());
		}
		return null;
	}

	private boolean fileExtInBlackList(String fileExt) {
		String blackFileExt = minioConfiguration.getBlackFileExt();
		if (StringUtils.isNotEmpty(blackFileExt) && fileExt != null) {
			String[] blackFileExtArr = blackFileExt.split(",");
			for (String blackExt : blackFileExtArr) {
				if (fileExt.equals(blackExt)) {
					return true;
				}
			}
		}
		return false;
	}

	public void setFileTruePath(List<AttachmentVO> list){
		if(!ListUtil.isEmpty(list)){
			list.forEach(f-> {
				f.setTruePath(fileUrl + f.getFilePath());
				if(StringUtils.isNotBlank(f.getFileFormatPathStr())) {
					f.setFileFormatPath((List<Map<String, String>>) JSONArray.parse(f.getFileFormatPathStr()));
				}
				f.setImgServerPath(fileUrl);
			});
		}
	}
	
	
	@GetMapping(value = "/no_auth/api/attachref/queryListBySourceId")
	public CommonResponse<List<AttachmentVO>>  queryNoAuthListBySourceId(@RequestParam(name = "sourceId", required = false) Long sourceId,
																   @RequestParam(name = "billType", required = false) String billType,
																   @RequestParam(name = "sourceType", required = false) String sourceType,
																   @RequestParam(name = "orderType", required = false) String orderType) {
		QueryParam queryParam = new QueryParam();
		if(null == sourceId) {
			return CommonResponse.success("sourceId为空，查询不到匹配的文件信息！");
		}

		if(StringUtils.isBlank(orderType)) {

			orderType = "desc";
		}
		queryParam.getOrderMap().put("createTime", orderType);
		queryParam.getOrderMap().put("id", "desc");
		Map<String, Parameter> params = queryParam.getParams();
		params.put("sourceId", new Parameter("eq",sourceId));
		if(StringUtils.isNotBlank(sourceType)){
			params.put("sourceType", new Parameter("eq",sourceType));
		}
		if(StringUtils.isNotBlank(billType)){
			params.put("billType", new Parameter("eq",billType));
		}

		return queryList(queryParam);
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/6/3 查询附件详情
	 * @Description queryDetail
	 * @Param [id]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.file.vo.AttachmentVO>
	 */
	@RequestMapping(value = "/api/attachref/queryDetail", method = RequestMethod.GET)
	public CommonResponse<AttachmentVO> queryDetail(@RequestParam(name="id") String id){
		AttachmentVO attachmentVO = attachmentService.selectById(id);
		if (attachmentVO==null){
			return CommonResponse.success(null);
		}
		attachmentVO.setTruePath(fileUrl + attachmentVO.getFilePath());
		if(StringUtils.isNotBlank(attachmentVO.getFileFormatPathStr())) {
			attachmentVO.setFileFormatPath((List<Map<String, String>>) JSONArray.parse(attachmentVO.getFileFormatPathStr()));
		}
		attachmentVO.setImgServerPath(fileUrl);
		return CommonResponse.success(attachmentVO);
	}

	/**
	 * 新增附件关联信息
	 *
	 * @Author liyongjia
	 * @Description 只保存关系,不会上传附件到服务器
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/insertBatch", method=RequestMethod.POST)
	public CommonResponse<String> insertBatch(@RequestBody List<AttachmentVO> AttachmentVOs) {
		if(AttachmentVOs!=null&&AttachmentVOs.size()>0){
			attachmentService.saveOrUpdateBatch(BeanMapper.mapList(AttachmentVOs, AttachmentEntity.class), AttachmentVOs.size(), false);
		}else{
			return CommonResponse.error("缺少附件信息");
		}
		return CommonResponse.success("新增成功");
	}

	/**
	 * 根据文件Id下载指定文件
	 *
	 * @param fileId
	 * @param resp
	 * @return
	 */
	@GetMapping(value = "/api/attachref/downloadFileById")
	public void downloadFileById(@RequestParam(value = "fileId") Long fileId, HttpServletResponse response) {
		AttachmentEntity attachment = attachmentService.selectById(fileId);
		if(attachment != null) {
			// ossObject包含文件所在的存储空间名称、文件名称、文件元信息以及一个输入流。
			String bucketName = minioConfiguration.getBucketName();

			BufferedOutputStream out = null;
			GetObjectResponse getObjectResponse = null;
			// 读取文件内容。
			try {
				response.setContentType("application/octet-stream");
				response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attachment.getFileName(), "UTF-8"));
				getObjectResponse = minioClient.getObject(GetObjectArgs.builder().bucket(bucketName).object(attachment.getFilePath()).build());

				out = new BufferedOutputStream(response.getOutputStream());
				IOUtils.copy(getObjectResponse, out);
			} catch (Exception e) {
				logger.error("文件下载失败", e);
				throw new BusinessException("文件下载失败，Msg："+e.getMessage());
			} finally {
				if (out != null) {
					try {
						out.flush();
						out.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
				if(getObjectResponse != null) {
					try {
						getObjectResponse.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}else{
			throw new BusinessException("参数fileId不合法，未查询到对应的附件信息");
		}
	}
	
	@RequestMapping(value = "/api/attachref/makeWatermarkToFile", method = RequestMethod.GET)
	public CommonResponse<String> makeWatermarkToFile(@RequestParam(value = "fileId") Long fileId,
			@RequestParam(value = "watermarkText") String watermarkText,
			@RequestParam(value = "waterWay") String waterWay) {
    	String onlineFilePath = attachmentService.makeWatermarkToFile(fileId, watermarkText, waterWay);
    	return CommonResponse.success(onlineFilePath);
    }


	/**
	 * 全量更新文件信息
	 * ！！！！！注意，是全量更新，请自行查询到vo，修改相关字段后再调用该接口！！！！
	 * */
	@RequestMapping(value = "/api/attachref/updateFileInfo", method = RequestMethod.POST)
	public CommonResponse<String> updateFileInfo(@RequestBody AttachmentVO vo) {
		AttachmentEntity entity = attachmentService.selectById(vo.getId());
		if(entity == null){
			return CommonResponse.error("指定文件不存在！");
		}
		entity = BeanMapper.map(vo,AttachmentEntity.class);
    	attachmentService.saveOrUpdate(entity,false);
    	return CommonResponse.success("修改成功！");
    }

	@PostMapping("/api/attachref/addMakeWatermark")
	public CommonResponse<AttachmentVO> addMakeWatermark(@RequestBody WaterMarketConfigVO waterMarketConfig) {
		logger.info("添加水印参数：{}", JSONObject.toJSONString(waterMarketConfig));
		AttachmentVO resp = attachmentService.addWaterMarket(waterMarketConfig);
		if(resp != null) {
			return CommonResponse.success(resp);
		}
		return CommonResponse.error("生成水印文件失败！");
	}

	/**
	 * 查询文件数量
	 * */
	@GetMapping(value = "/api/attachref/queryNumberBySourceId")
	public CommonResponse<Map<Long, Integer>>  queryNumberBySourceId(@RequestParam(name = "sourceIds", required = false) List<Long> sourceIds,
																	 @RequestParam(name = "billType", required = false) String billType,@RequestParam(name = "sourceType", required = false) String sourceType) {
		Map<Long, Integer> countNum = new HashMap<>();
		for(Long sourceId : sourceIds){
			QueryWrapper<AttachmentEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("source_id",sourceId);
			if(StringUtils.isNotBlank(sourceType)){
				queryWrapper.eq("source_type",sourceType);
			}
			if(StringUtils.isNotBlank(billType)){
				queryWrapper.eq("bill_type",billType);
			}
			queryWrapper.eq("source_id",sourceId);
			Integer num = attachmentService.count(queryWrapper);
			countNum.put(sourceId, num);
		}
		return CommonResponse.success(countNum);
	}

	/**
	 * 获取文件页数
	 * */
	@GetMapping(value = "/api/attachref/queryPageNumber")
	public CommonResponse<Integer>  queryPageNumber(@RequestParam(name = "fileId", required = false) Long fileId) {
		Integer pages = attachmentService.queryPageNumber(fileId);
		return CommonResponse.success(pages);
	}

}
