package com.ejianc.foundation.file.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.file.bean.NetStoreCategoryEntity;
import com.ejianc.foundation.support.vo.ModuleVO;

public class NetStoreAsTree {
	
	public static List<FolderParam> createTreeDataVO(List<NetStoreCategoryEntity> list) {
		List<FolderParam> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, FolderParam> listMap = new HashMap<>();
		for(NetStoreCategoryEntity categoryEntity:list) {
			FolderParam folderParam = new FolderParam();
			folderParam.setId(categoryEntity.getId());
			folderParam.setParentId(categoryEntity.getParentId());
			folderParam.setType("folder");
			folderParam.setValue(categoryEntity.getCategoryName());
			folderParam.setLabel(1);
			listMap.put(categoryEntity.getId().toString(), folderParam);
		}
        
        for(int i =0; i<list.size(); i++) {
        	NetStoreCategoryEntity netStoreCategoryEntity = list.get(i);
        	String parentId = (netStoreCategoryEntity.getParentId() != null && netStoreCategoryEntity.getParentId() > 0) ? netStoreCategoryEntity.getParentId().toString():"";
        	FolderParam parent = listMap.get(parentId);
        	if(parent != null) {
        		List<FolderParam> child = parent.getData();
        		if(child != null) {
        			FolderParam folderParam = listMap.get(netStoreCategoryEntity.getId()+"");
        			child.add(folderParam);
        		}else{
        			List<FolderParam> data = new ArrayList<FolderParam>();
        			FolderParam folderParam = listMap.get(netStoreCategoryEntity.getId()+"");
        			data.add(folderParam);
        			parent.setData(data);
        		}
        	} else {
        		rootItems.add(netStoreCategoryEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	public static List<FolderParam> createModuleTreeDataVO(List<ModuleVO> list) {
		List<FolderParam> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, FolderParam> listMap = new HashMap<>();
		for(ModuleVO moduleVo:list) {
			FolderParam folderParam = new FolderParam();
			folderParam.setId(moduleVo.getId());
			folderParam.setParentId(moduleVo.getParentId());
			folderParam.setType("folder");
			folderParam.setValue(moduleVo.getModuleName());
			folderParam.setLabel(2);
			listMap.put(moduleVo.getId().toString(), folderParam);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ModuleVO moduleVo = list.get(i);
        	String parentId = (moduleVo.getParentId() != null && moduleVo.getParentId() > 0) ? moduleVo.getParentId().toString():"";
        	FolderParam parent = listMap.get(parentId);
        	if(parent != null) {
        		List<FolderParam> child = parent.getData();
        		if(child != null) {
        			FolderParam folderParam = listMap.get(moduleVo.getId()+"");
        			child.add(folderParam);
        		}else{
        			List<FolderParam> data = new ArrayList<FolderParam>();
        			FolderParam folderParam = listMap.get(moduleVo.getId()+"");
        			data.add(folderParam);
        			parent.setData(data);
        		}
        	} else {
        		rootItems.add(moduleVo.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
