package com.ejianc.business.filesystem.file.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.filesystem.file.vo.FileBorrowDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 文件借阅
 * 
 * @author generator
 * 
 */
public class FileBorrowVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long borrowUserId; // 借阅人id
    private String borrowUserName; // 借阅人姓名
    private String borrowReson; // 借阅用途
    private Integer borrowFileKind; // 借阅单元（1卷，2文件）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date borrowStartTime; // 借阅开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date borrowEndTime; // 预计借阅结束时间
    private String isReturn; // 是否归还(0:否-1:是)
    
    private List<FileBorrowDetailVO> fileBorrowDetailList = new ArrayList<>(); // 文件借阅明细
    private Integer borrowType; // 借阅类别(1纸质档,2电子档)

    public Integer getBorrowType() {
        return borrowType;
    }

    public void setBorrowType(Integer borrowType) {
        this.borrowType = borrowType;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getBorrowUserId() {
        return borrowUserId;
    }

    public void setBorrowUserId(Long borrowUserId) {
        this.borrowUserId = borrowUserId;
    }
    public String getBorrowUserName() {
        return borrowUserName;
    }

    public void setBorrowUserName(String borrowUserName) {
        this.borrowUserName = borrowUserName;
    }
    public String getBorrowReson() {
        return borrowReson;
    }

    public void setBorrowReson(String borrowReson) {
        this.borrowReson = borrowReson;
    }
    public Integer getBorrowFileKind() {
        return borrowFileKind;
    }

    public void setBorrowFileKind(Integer borrowFileKind) {
        this.borrowFileKind = borrowFileKind;
    }
    public Date getBorrowStartTime() {
        return borrowStartTime;
    }

    public void setBorrowStartTime(Date borrowStartTime) {
        this.borrowStartTime = borrowStartTime;
    }
    public Date getBorrowEndTime() {
        return borrowEndTime;
    }

    public void setBorrowEndTime(Date borrowEndTime) {
        this.borrowEndTime = borrowEndTime;
    }
    public String getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(String isReturn) {
        this.isReturn = isReturn;
    }
    
     public List<FileBorrowDetailVO> getFileBorrowDetailList() {
        return fileBorrowDetailList;
     }

     public void setFileBorrowDetailList(List<FileBorrowDetailVO> fileBorrowDetailList) {
        this.fileBorrowDetailList = fileBorrowDetailList;
     }
}
