package com.ejianc.business.filesystem.file.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.filesystem.file.bean.FileReturnDetailEntity;
/**
 * 文件归还
 * 
 * @author generator
 * 
 */
 @TableName("ejc_filesystem_file_return")
public class FileReturnEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="return_user_id")
    private Long returnUserId; // 归还人id
    @TableField(value="return_user_name")
    private String returnUserName; // 归还人姓名
    @TableField(value="return_time")
    private Date returnTime; // 归还日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="fileReturnDetailService")
    private List<FileReturnDetailEntity> fileReturnDetailList = new ArrayList<>(); // 文件归还明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getReturnUserId() {
        return returnUserId;
    }

    public void setReturnUserId(Long returnUserId) {
        this.returnUserId = returnUserId;
    }
    public String getReturnUserName() {
        return returnUserName;
    }

    public void setReturnUserName(String returnUserName) {
        this.returnUserName = returnUserName;
    }
    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }
    

    public List<FileReturnDetailEntity> getFileReturnDetailList() {
        return fileReturnDetailList;
    }

    public void setFileReturnDetailList(List<FileReturnDetailEntity> fileReturnDetailList) {
        this.fileReturnDetailList = fileReturnDetailList;
    }
}
