package com.ejianc.business.filesystem.file.controller;

import java.io.FileOutputStream;
import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.filesystem.common.MinioUtils;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.bean.FileTypeEntity;
import com.ejianc.business.filesystem.file.dto.FileBtnDTO;
import com.ejianc.business.filesystem.file.dto.FileResponseDTO;
import com.ejianc.business.filesystem.file.dto.HashBtnDTO;
import com.ejianc.business.filesystem.file.mapper.FileBorrowDetailMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.*;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.vo.FileMetafileVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 元文件
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileMetafile")
public class FileMetafileController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private static final String BILL_CODE_R = "QIYEZHENGZHAO";//此处需要根据实际修改

    @Autowired
    private IFileMetafileService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IFileRecordService recordService;
    @Autowired
    private MinioUtils utils;

    @Value("${ejc.roleid}")
	private Long roleId;

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IFileCaseService caseService;

    @Autowired
    private IFileTypeService fileTypeService;

    @Autowired
    private FileBorrowDetailMapper borrowDetailMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileMetafileVO> saveOrUpdate(@RequestBody FileMetafileVO saveOrUpdateVO) {
    	FileMetafileEntity entity = BeanMapper.map(saveOrUpdateVO, FileMetafileEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际
                // 设置创建人姓名
                entity.setCreateUserId(userContextCache.getUserId());
                entity.setCreateUserName(userContextCache.getUserName());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            //证照的reference自动生成
            if (entity.getParentId().equals(970647966287237210L)){
                CommonResponse<String> reference = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_R, InvocationInfoProxy.getTenantid());
                if(billCode.isSuccess()) {
                    entity.setReference(reference.getData());//此处需要根据实际
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }

        FileCaseEntity fileCaseEntity = caseService.selectById(entity.getParentId());
        //分类信息
        if (entity.getFileTypeId() == null) {
            entity.setFileTypeId(fileCaseEntity.getFileTypeId());
            entity.setFileTypeName(fileCaseEntity.getFileTypeName());
        }
        if (fileCaseEntity != null && fileCaseEntity.getProjectId() != null){
            entity.setProjectId(fileCaseEntity.getProjectId());
            entity.setProjectName(fileCaseEntity.getProjectName());
        }
        //归档状态
        entity.setFilingState("未归档");


    	service.saveOrUpdate(entity, false);

        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getFileIds()) ){
            for (Long fileId : saveOrUpdateVO.getFileIds()) {
                FileRecordEntity fileRecordEntity = recordService.selectById(fileId);
                if (fileRecordEntity.getBillId() == -1L){
                    fileRecordEntity.setBillId(entity.getId());
                    recordService.saveOrUpdate(fileRecordEntity);
                }
            }
        }
    	FileMetafileVO vo = BeanMapper.map(entity, FileMetafileVO.class);


        QueryWrapper<FileRecordEntity> ae = new QueryWrapper<>();
        ae.eq("bill_id",entity.getId() );
        ae.eq("dr",0);
        List<FileRecordEntity> list = recordService.list(ae);
        if (CollectionUtils.isNotEmpty(list)){
            List<FileBtnDTO> fileList  = new ArrayList<>();

            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();

                String objectUrl = utils.getObjectUrl(fileRecordEntity.getFilePath());

                fileBtnDTO.setUid(fileRecordEntity.getId()+"");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                fileBtnDTO.setUrl(objectUrl);

                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                fileResponseDTO.setUrl(objectUrl);
                fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                fileResponseDTO.setFileId(fileRecordEntity.getId()+"");
                fileBtnDTO.setResponse(fileResponseDTO);

                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
            entity.setFileUploadNum(list.size());
        }else {
            entity.setFileUploadNum(0);
        }

        service.saveOrUpdate(entity);
        vo.setFileUploadNum(entity.getFileUploadNum());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileMetafileVO> queryDetail(Long id) {
    	FileMetafileEntity entity = service.selectById(id);
    	FileMetafileVO vo = BeanMapper.map(entity, FileMetafileVO.class);

    	/**
		 *  判断当前人员是否拥有查看附件的权限 1.制单人 2.管理员 3.借阅人
		 */
    	boolean viewFlag = false;
        UserContext userContextCache = sessionManager.getUserContext();
		List<Long> roleIds = new ArrayList<>();
		roleIds.add(roleId);
		CommonResponse<List<RoleUserRelationVO>> roleResp = roleApi.getRoleUser(roleIds, null);
		if(!roleResp.isSuccess()){
			throw new BusinessException("网络异常，获取发送信息角色， 请稍后再试");
		}
		List<RoleUserRelationVO> relationVOS = roleResp.getData();
		List<String> userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());

        //logger.info("管理员:{}",JSONObject.toJSONString(relationVOS));

        if (userIds.contains(userContextCache.getUserId().toString())){
            viewFlag = true;
        }

        //1制单人
        if (vo.getCreateUserId().equals(userContextCache.getUserId())) {
            viewFlag = true;
        }

        //3借阅人
        //当前表单的id==借阅单子表fileBillId 且 借阅单主表审批通过 且 借阅单子表未归还
        Integer borrowDetailByBillIdAndUserId = borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getId(), userContextCache.getUserId());
        Integer borrowDetailByBillIdAndUserId1 = borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getParentId(), userContextCache.getUserId());
        if (borrowDetailByBillIdAndUserId > 0 || borrowDetailByBillIdAndUserId1 > 0){
            viewFlag = true;
        }

        logger.info("当前浏览文件的人员:{},文档id:{},是否有权限:{}",userContextCache.getUserName(),id,viewFlag);

        QueryWrapper<FileRecordEntity> ae = new QueryWrapper<>();
        ae.eq("bill_id",entity.getId() );
        ae.eq("dr",0);
        List<FileRecordEntity> list = recordService.list(ae);
        if (CollectionUtils.isNotEmpty(list)){
            List<FileBtnDTO> fileList  = new ArrayList<>();

            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();

                String objectUrl = utils.getObjectUrl(fileRecordEntity.getFilePath());

                fileBtnDTO.setUid(fileRecordEntity.getId()+"");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                if (viewFlag) {
                    fileBtnDTO.setUrl(objectUrl);

                }
                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                if (viewFlag) {
                    fileResponseDTO.setUrl(objectUrl);
                    fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                }
                fileResponseDTO.setFileId(fileRecordEntity.getId()+"");
                fileBtnDTO.setResponse(fileResponseDTO);

                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileMetafileVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileMetafileVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileMetafileVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        fuzzyFields.add("ryProjectName");

        //按序号升序
        param.getOrderMap().put("metafileNum","asc");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryFilingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryFilingList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        fuzzyFields.add("ryProjectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"已归档"));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReplenishList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryReplenishList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        fuzzyFields.add("ryProjectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表散文件
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryHashList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryHashList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));


        param.getParams().put("parentId", new Parameter(QueryParam.SQL,"parent_id is null"));


        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileMetafileEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafile-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFileMetafileHashData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> refFileMetafileHashData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        param.getParams().put("parentId", new Parameter(QueryParam.SQL,"parent_id is null"));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (_con.containsKey("fileTypeId")) {
                param.getParams().put("fileTypeId", new Parameter(QueryParam.EQ,_con.getString("fileTypeId")));
            }
        }

        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFileMetafileData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> refFileMetafileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList("1","3")));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("filingState")) {
                param.getParams().put("filingState", new Parameter(QueryParam.EQ,_con.getString("filingState")));
            }

            if (_con.containsKey("fileTypeId")) {
                param.getParams().put("fileTypeId", new Parameter(QueryParam.EQ,_con.getString("fileTypeId")));
            }

            if (_con.containsKey("borrowState")) {
                param.getParams().put("borrowState", new Parameter(QueryParam.EQ,_con.getString("borrowState")));
            }

            //metafileType 电子档、纸质档
            if (_con.containsKey("metafileType")) {
                param.getParams().put("metafileType", new Parameter(QueryParam.IN,Arrays.asList(_con.getString("metafileType").split(","))));
            }


            //档案借阅专用  1为文书档案和工程档案 2为荣誉档案
            if (_con.containsKey("fileType")) {
                QueryParam param1 = new QueryParam();
                if (_con.getString("fileType").equals("1")){
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList("877940299152830497","877940557538734178")));
                }else {
                    param1.getParams().put("lastTypeId",new Parameter(QueryParam.IN,Arrays.asList("894547059074502668","877940557538734179")));
                }
                param1.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList("1","3")));
                List<FileTypeEntity> fileTypeEntities = fileTypeService.queryList(param1);
                List<Long> collect = fileTypeEntities.stream().map(FileTypeEntity::getId).collect(Collectors.toList());
                QueryParam param2 = new QueryParam();
                param2.getParams().put("fileTypeId",new Parameter(QueryParam.IN,collect));
                param2.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList("1","3")));
                List<FileCaseEntity> fileCaseEntities = caseService.queryList(param2);
                List<Long> collect1 = fileCaseEntities.stream().map(FileCaseEntity::getId).collect(Collectors.toList());

                param.getParams().put("parentId", new Parameter(QueryParam.IN,collect1));
            }
        }

        param.getParams().put("", new Parameter(QueryParam.SQL,"(yxzt is null or yxzt = '有效')"));


        IPage<FileMetafileEntity> page = service.queryPage(param,false);
        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/selectHashFiles", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> selectHashFiles(@RequestBody HashBtnDTO param) {
        List<FileMetafileVO> vos = param.getVos();
        if(CollectionUtils.isNotEmpty(vos)){
            for (FileMetafileVO vo : vos) {
                FileMetafileEntity fileMetafileEntity = service.selectById(vo.getId());
                fileMetafileEntity.setParentId(param.getParentId());
                fileMetafileEntity.setParentCode(param.getParentCode());
                service.saveOrUpdate(fileMetafileEntity);
            }
        }

        return CommonResponse.success("添加散文件成功！");
    }

    /**
     * @Description delete 恢复为散文件
     * @Param [ids]
     */
    @RequestMapping(value = "/delParentId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delParentId(@RequestBody List<String> ids) {

        if(CollectionUtils.isNotEmpty(ids)){
            LambdaUpdateWrapper<FileMetafileEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(FileMetafileEntity::getParentId, null);
            updateWrapper.in(FileMetafileEntity::getId, ids);
            service.update(updateWrapper);
        }
        return CommonResponse.success("添加散文件成功！");
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo", method = RequestMethod.GET)
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response,@RequestParam Long parentId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (parentId != null) {
            param.getParams().put("parent_id", new Parameter(QueryParam.EQ, parentId));
        }else {
            throw new BusinessException("parentId不可以为空！");
        }
        List<FileMetafileEntity> list = service.queryList(param);

        for (FileMetafileEntity fileMetafileEntity : list) {
            fileMetafileEntity.setRemark(fileMetafileEntity.getId()+"");
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafile-export.xlsx", beans, response);
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<FileMetafileVO> successList = new ArrayList<>();
        List<FileMetafileVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {

                //给每行赋值
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    FileMetafileVO fileMetafileVO = new FileMetafileVO();

                    //id
                    try {
                        String id = datas.get(0);
                        if(StringUtils.isNotBlank(id)) {
                            FileMetafileEntity fileMetafileEntity = service.selectById(id);


                            //序号
                            try {
                                String metafileNum = datas.get(1);
                                if(StringUtils.isNotBlank(metafileNum)) {
                                    fileMetafileVO.setMetafileNum(Integer.parseInt(metafileNum));
                                    fileMetafileEntity.setMetafileNum(Integer.parseInt(metafileNum));
                                    fileMetafileEntity.setReference(fileMetafileEntity.getParentCode()+"-"+metafileNum);//档号


                                }else {
                                    throw new Exception("序号不能为空！");
                                }
                            } catch (Exception e) {
                                fileMetafileVO.setErrorMsg("序号错误！");
                                errorList.add(fileMetafileVO);
                                continue;
                            }


                            //题名
                            try {
                                String metafileNum = datas.get(3);
                                if(StringUtils.isNotBlank(metafileNum)) {
                                    fileMetafileVO.setTitle(metafileNum);
                                    fileMetafileEntity.setTitle(metafileNum);
                                }else {
                                    throw new Exception("题名不能为空！");
                                }
                            } catch (Exception e) {
                                fileMetafileVO.setErrorMsg("题名错误！");
                                errorList.add(fileMetafileVO);
                                continue;
                            }


                            fileMetafileVO.setTotalPageNum(Integer.parseInt(datas.get(4)));
                            fileMetafileEntity.setTotalPageNum(Integer.parseInt(datas.get(4)));

                            fileMetafileVO.setKeyword(datas.get(5));
                            fileMetafileEntity.setKeyword(datas.get(5));

                            service.saveOrUpdate(fileMetafileEntity);
                        }else {
                            throw new Exception("id不能为空！");
                        }
                    } catch (Exception e) {
                        fileMetafileVO.setErrorMsg("id错误！");
                        errorList.add(fileMetafileVO);
                        continue;
                    }




                    fileMetafileVO.setRowState("add");
                    successList.add(fileMetafileVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
//

        return CommonResponse.success(json);
    }

    /**
     * @Description queryListRy 荣誉档案查阅清单
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListRy", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryListRy(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        fuzzyFields.add("ryProjectName");

        //按序号升序
        //param.getOrderMap().put("metafileNum","asc");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileTypeId", new Parameter(QueryParam.IN, Arrays.asList(
                895340334396051474L,898575810083000414L,898575365717463080L,898575273094647864L,898575642839322678L
                )));

        //param.getParams().put("filingState", new Parameter(QueryParam.EQ,"未归档"));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<FileMetafileEntity> page = service.queryPage(param,false);

//        for (FileMetafileEntity record : page.getRecords()) {
//            record.setBillCode(record.getTitle());
//        }

        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryListZz 证照查阅清单
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListZz", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryListZz(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        fuzzyFields.add("ryProjectName");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("fileTypeId", new Parameter(QueryParam.IN, Arrays.asList(
                970654971034963987L)));//970654971034963988


        IPage<FileMetafileEntity> page = service.queryPage(param,false);


        IPage<FileMetafileVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FileMetafileVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description updateYxzt 修改有效状态
     * @param id
     */
    @RequestMapping(value = "/updateYxzt", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateYxzt(Long id) {
        FileMetafileEntity entity = service.selectById(id);
        if (entity.getYxzt() != null) {
            if (entity.getYxzt().equals("有效")) {
                entity.setYxzt("无效");
            }else {
                entity.setYxzt("有效");
            }

        }else {
            entity.setYxzt("有效");
        }
        service.saveOrUpdate(entity);
        return CommonResponse.success("修改成功！");
    }
}
