package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.dto.FileSearchDTO;
import com.ejianc.business.filesystem.file.mapper.FileSearchMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileProjectService;
import com.ejianc.business.filesystem.file.vo.FileCaseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 案卷(文书、工程)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileSearch")
public class FileSearchController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IFileCaseService caseService;

    @Autowired
    private IFileMetafileService metafileService;

    @Autowired
    private IFileProjectService projectService;

    @Autowired
    private FileSearchMapper mapper;

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileSearchDTO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("info");
        /** 租户隔离 */
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        String reference = null;
        String projectCode = null;
        String title = null;
        String keyword = null;
        String memo = null;
        String remark = null;
        //按照字段过滤
        if (param.getParams().containsKey("searchKey")){
            if (param.getSearchText() != null) {
                String searchKey = param.getParams().get("searchKey").getValue().toString();
                if (searchKey.indexOf("0") > -1) {
                    reference =param.getSearchText();
                }
                if (searchKey.indexOf("1") > -1) {
                    projectCode =param.getSearchText();
                }
                if (searchKey.indexOf("2") > -1) {
                    title =param.getSearchText();
                }
                if (searchKey.indexOf("3") > -1) {
                    keyword =param.getSearchText();
                }
                if (searchKey.indexOf("4") > -1) {
                    memo =param.getSearchText();
                }
                if (searchKey.indexOf("5") > -1) {
                    remark =param.getSearchText();
                }

                param.setSearchText(null);
            }

            param.getParams().remove("searchKey");
        }

        Page<FileSearchDTO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        //自定义查询，拼接查询语句
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        //自定义查询，写xml
        List<FileSearchDTO>  list = mapper.queryFileList(page, wrapper,reference,projectCode,title,keyword,memo,remark);
        IPage<FileSearchDTO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(list);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }






}
