package com.ejianc.business.filesystem.file.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.filesystem.file.bean.FileTypeEntity;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileTypeVO;

/**
 * 文件分类
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileType")
public class FileTypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFileTypeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileTypeVO> saveOrUpdate(@RequestBody FileTypeVO saveOrUpdateVO) {
    	FileTypeEntity entity = BeanMapper.map(saveOrUpdateVO, FileTypeEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际
                // 设置创建人姓名
                entity.setCreateUserName(userContextCache.getUserName());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);

        /**
         * 内码生成
         */
        if (entity.getLastTypeId() != null) {
            FileTypeEntity pEntity = service.selectById(entity.getLastTypeId());
            String innerCode = pEntity.getInnerCode();
            String innerName = pEntity.getInnerName();
            entity.setInnerCode(innerCode + "-" + entity.getId().toString());
            entity.setInnerName(innerName + "-" + entity.getWorkTypeName());

        } else {
            entity.setInnerCode(entity.getId().toString());
            entity.setInnerName(entity.getWorkTypeName());
        }
        service.saveOrUpdate(entity);
    	FileTypeVO vo = BeanMapper.map(entity, FileTypeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileTypeVO> queryDetail(Long id) {
    	FileTypeEntity entity = service.selectById(id);
    	FileTypeVO vo = BeanMapper.map(entity, FileTypeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileTypeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileTypeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileTypeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileTypeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<FileTypeEntity> fileTypeEntities = service.queryList(param);
        List<FileTypeVO> fileTypeVOS = BeanMapper.mapList(fileTypeEntities, FileTypeVO.class);
        /**
         * 树形显示
         */
        List<FileTypeVO> parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (FileTypeVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
        }

        IPage<FileTypeVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), parentWorkType.size());
        pageData.setRecords(parentWorkType);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 递归放入
     */
    private List<FileTypeVO> getWorkTypeTree(Long parentNodeId, List<FileTypeVO> records) {
        List<FileTypeVO> resultList = new ArrayList<>();
        List<FileTypeVO> childrenList = records.stream().filter(s -> parentNodeId.equals(s.getLastTypeId())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(childrenList)) {
            for (FileTypeVO child : childrenList) {
                child.setChildren(getWorkTypeTree(child.getId(), records));
                resultList.add(child);
            }
        }
        if (ListUtil.isNotEmpty(resultList)) {
            return resultList;
        } else {
            return null;
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FileTypeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileType-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refFileTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileTypeVO>> refFileTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("fileTypeId")) {
                param.getParams().put("inner_code", new Parameter(QueryParam.LIKE,_con.getString("fileTypeId")));
            }
        }

        List<FileTypeEntity> list = service.queryList(param,false);

        List<FileTypeVO> fileTypeVOS = BeanMapper.mapList(list, FileTypeVO.class);
        /**
         * 树形显示
         */
        List<FileTypeVO> parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentWorkType)){
            parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId().equals(877939990976344129L)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(parentWorkType)){
            parentWorkType = fileTypeVOS;
        }

        for (FileTypeVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
        }

        IPage<FileTypeVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), parentWorkType.size());
        pageData.setRecords(parentWorkType);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description queryList 查询列表
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<FileTypeVO>> queryListTree(@RequestParam(required = false) Long id,@RequestParam(required = false) Long lastTypeId) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        Parameter orgIdValue = param.getParams().get("orgId");
//        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (id != null){
            param.getParams().put("id", new Parameter(QueryParam.EQ, id));
        }
        if (lastTypeId != null){
            param.getParams().put("lastTypeId", new Parameter(QueryParam.EQ, lastTypeId));
        }
        List<FileTypeEntity> fileTypeEntities = service.queryList(param);
        List<FileTypeVO> fileTypeVOS = BeanMapper.mapList(fileTypeEntities, FileTypeVO.class);
        /**
         * 树形显示
         */
        List<FileTypeVO> parentWorkType = null;
        if (lastTypeId != null){//已归档补充文件
            parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId().equals( 877940557538734178L)).collect(Collectors.toList());
            for (FileTypeVO fileTypeVO : parentWorkType) {
                fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
            }
        }else {
            parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
            for (FileTypeVO fileTypeVO : parentWorkType) {
                //荣誉、证照不赋值子节点
                if ((!fileTypeVO.getId().equals(894547059074502668L)) && (!fileTypeVO.getId().equals(877940557538734179L))  ) {//荣誉档案不赋值子节点
                    fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
                }
            }
        }

        return CommonResponse.success("查询列表数据成功！",parentWorkType);
    }

}
