package com.ejianc.business.filesystem.file.service.impl;

import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.filesystem.file.mapper.FileRecordMapper;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 文件记录表
 * 
 * @author generator
 * 
 */
@Service("fileRecordService")
public class FileRecordServiceImpl extends BaseServiceImpl<FileRecordMapper, FileRecordEntity> implements IFileRecordService{

    @Override
    public List<FileRecordEntity> getFileListById(Long billId, String fileType) {
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(-1);

        if (billId != null){
            param.getParams().put("billId",new Parameter(QueryParam.EQ, billId));
        }else {
            throw new BusinessException("文件的单据id不可以为空！");
        }

        if (fileType != null){
            param.getParams().put("fileType",new Parameter(QueryParam.EQ, fileType));
        }

        List<FileRecordEntity> list = this.queryList(param);
        return list;
    }
}
