package com.ejianc.business.filesystem.common;

import com.ejianc.business.filesystem.config.MinioConfiguration;
import com.ejianc.business.filesystem.utils.FontGenerater;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.*;
import io.minio.*;
import lombok.Data;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.ByteArrayInputStream;
import io.minio.http.Method;
import io.minio.messages.Item;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;





/**
 * minio操作类
 * @Author sunxy
 * @Date 24/8/2 15:34:07
 */
@Component
public class MinioUtils {

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MinioClient client;
    @Autowired
    private MinioConfiguration minioConfiguration;
    /**
     * 创建桶
     *
     * @param bucketName 桶名称
     */
    @SneakyThrows
    public void createBucket(String bucketName) {
        boolean found =
                client.bucketExists(BucketExistsArgs.builder().bucket(bucketName).build());
        if (!found) {
            client.makeBucket(
                    MakeBucketArgs.builder()
                            .bucket(bucketName)
                            .region("cn-beijing")
                            .build());
        }
    }

    /**
     * 删除桶
     *
     * @param bucketName 桶名称
     */
    @SneakyThrows
    public void removeBucket(String bucketName) {
        client.removeBucket(RemoveBucketArgs.builder().bucket(bucketName).build());
    }

    /**
     * 获取文件信息
     *
     *
     * @param objectName 文件名称
     * @return
     */
    @SneakyThrows
    public ObjectStat getObjectInfo( String objectName) {
        String bucketName = minioConfiguration.getBucketName();
        ObjectStat objectStat = client.statObject(StatObjectArgs.builder().bucket(bucketName).object(objectName).build());
        return objectStat;
    }
    /**
     * 获取文件流
     *
     *
     * @param objectName 文件名称
     * @return
     */
    @SneakyThrows
    public InputStream getObjectInputStream( String objectName) {
        String bucketName = minioConfiguration.getBucketName();
        InputStream object = client.getObject(GetObjectArgs.builder().bucket(bucketName).object(objectName).build());
        return object;
    }
    /**
     * 下载文件
     *
     *
     * @return
     */
    @SneakyThrows
    public HttpServletResponse downloadFile( String originalName,String userName,String orgName, HttpServletResponse response) {
//        Date data = new Date();
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        if(orgName.length()>8){
//            orgName = orgName.substring(0,7)+"..";
//        }
        String bucketName = minioConfiguration.getBucketName();
        InputStream file = client.getObject(GetObjectArgs.builder().bucket(bucketName).object(originalName).build());
        String filename = new String(originalName.getBytes("ISO8859-1"), StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank(originalName)) {
            filename = originalName;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);

        int dotIndex = filename.lastIndexOf('.');
        if (dotIndex > 0  && ("pdf".equals(filename.substring(dotIndex + 1)) || "PDF".equals(filename.substring(dotIndex + 1)))) {

            // 读取原始 PDF 文件
                PdfReader reader = new PdfReader(file);
                PdfStamper stamper = new PdfStamper(reader, response.getOutputStream());
                // 获取 PDF 中的页数
                int pageCount = reader.getNumberOfPages();
                // 添加水印 --未调试完成，先注释掉2025-01-17
//                for (int i = 1; i <= pageCount; i++) {
//                    PdfContentByte waterMar = stamper.getOverContent(i); // 或者 getOverContent()
//                    waterMar.beginText();
//
//                    PdfGState gs = new PdfGState();
//                    // 设置填充字体不透明度为0.4f
//                    gs.setFillOpacity(0.2f);
//                    waterMar.setFontAndSize(FontGenerater.getFont(FontGenerater.FONT_SONTI_NAME), 15);
//                    // 设置透明度
//                    waterMar.setGState(gs);
//                    // 设置水印对齐方式 水印内容 X坐标 Y坐标 旋转角度
//                    for (int x = 0; x <= 700; x += 200) {
//                        for (int y = 0; y <= 800; y += 200) {
//                            waterMar.showTextAligned(Element.ALIGN_RIGHT,
//                                    userName+"-"+orgName+"_"+sdf.format(data), x, y, 35);
//                        }
//                    }
//
//                    // 设置水印颜色
//                    waterMar.setColorFill(BaseColor.GRAY);
//
//                    //结束加载文本
//                    waterMar.endText();
//
//                }

                // 保存修改后的 PDF 文件并关闭文件流
                stamper.close();
                reader.close();

                file.close();
            }else {
                ServletOutputStream servletOutputStream = response.getOutputStream();
                int len;
                byte[] buffer = new byte[1024];
                while ((len = file.read(buffer)) > 0) {
                    servletOutputStream.write(buffer, 0, len);
                }
                servletOutputStream.flush();
                file.close();
                servletOutputStream.close();
            }


        return response;
    }

    //不加水印直接下载
    @SneakyThrows
    public HttpServletResponse downloadFileOld( String originalName, HttpServletResponse response) {
        String bucketName = minioConfiguration.getBucketName();
        InputStream file = client.getObject(GetObjectArgs.builder().bucket(bucketName).object(originalName).build());
        String filename = new String(originalName.getBytes("ISO8859-1"), StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank(originalName)) {
            filename = originalName;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        ServletOutputStream servletOutputStream = response.getOutputStream();

        int len;
        byte[] buffer = new byte[1024];
        while ((len = file.read(buffer)) > 0) {
            servletOutputStream.write(buffer, 0, len);
        }
        servletOutputStream.flush();
        file.close();
        servletOutputStream.close();
        return response;
    }

    /**
     * 上传文件
     *
     *
     * @param objectName 文件名
     * @param stream     流
     * @param fileSize   文件大小
     * @param type       文件类型
     * @throws Exception
     */
    public void putObject(String objectName, InputStream stream, Long fileSize, String type) throws Exception {
        String bucketName = minioConfiguration.getBucketName();
        client.putObject(
                PutObjectArgs.builder().bucket(bucketName).object(objectName).stream(
                        stream, fileSize, -1)
                        .contentType(type)
                        .build());
    }

    /**
     * 上传文件
     *
     *
     * @throws Exception
     */
    public String minioUpload(MultipartFile file, String fileName) throws Exception{
        String bucketName = minioConfiguration.getBucketName();
        // fileName为空，说明要使用源文件名上传
        if (fileName == null) {
            fileName = file.getOriginalFilename();
            fileName = fileName.replaceAll(" ", "_");
        }
        InputStream inputStream = file.getInputStream();
        PutObjectArgs objectArgs = PutObjectArgs.builder().bucket(bucketName).object(fileName)
                .stream(inputStream, file.getSize(), -1).contentType(file.getContentType()).build();
        //文件名称相同会覆盖
        ObjectWriteResponse objectWriteResponse = client.putObject(objectArgs);
        String etag = objectWriteResponse.etag();
        return etag;
    }
    /**
     * 判断文件夹是否存在
     *
     * @param prefix     文件夹名字
     * @return
     */
    @SneakyThrows
    public Boolean folderExists(String prefix) {
        String bucketName = minioConfiguration.getBucketName();
        Iterable<Result<Item>> results = client.listObjects(ListObjectsArgs.builder().bucket(bucketName)
                .prefix(prefix).recursive(false).build());
        for (Result<Item> result:results){
            Item item = result.get();
            if (item.isDir()){
                return true;
            }
        }
        return false;
    }

    /**
     * 创建文件夹
     * @param path 路径
     */
    @SneakyThrows
    public void createFolder(String path) {
        String bucketName = minioConfiguration.getBucketName();
        client.putObject(PutObjectArgs.builder().bucket(bucketName).object(path+"/")
                .stream(new ByteArrayInputStream(new byte[]{}),0,-1).build());
    }

    /**
     * 获取文件在minio在服务器上的外链
     * @param objectName 文件名
     * @return
     */
    @SneakyThrows
    public String getObjectUrl(String objectName){

        String bucketName = minioConfiguration.getBucketName();
        return client.getPresignedObjectUrl(
                GetPresignedObjectUrlArgs.builder()
                        .method(Method.GET)
                        .bucket(bucketName)
                        .object(objectName)
                        .build());
    }




}
