package com.ejianc.business.filesystem.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.business.filesystem.file.vo.FileRecordVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import io.minio.*;

/**
 * @Author sunxy
 * @Date 24/8/2 16:34:20
 */
@RestController
@RequestMapping("myFile")
public class MyFileController {
    @Autowired
    private IFileRecordService service;
    @Autowired
    private MinioUtils utils;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 创建文件夹
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<String> queryDetail() {
        utils.createFolder("123321/");
        return CommonResponse.success();
    }
    /**
     * 判断文件夹是否存在
     */
    @RequestMapping(value = "/queryDetail2", method = RequestMethod.GET)
    public CommonResponse<String> queryDetail2() {
        Boolean xixixi = utils.folderExists("123321");
        return CommonResponse.success();
    }

    /**
     * 文件下载
     */
    @RequestMapping(value = "/noAuth/getObjectInfo", method = RequestMethod.GET)
    public void getObjectInfo(String name, HttpServletResponse response) {
        UserContext userContextCache = sessionManager.getUserContext();
        response = utils.downloadFile(name,userContextCache.getUserName(),userContextCache.getOrgName(), response);
    }

    /**
     * 获取下载地址
     */
    @RequestMapping(value = "/getObjectUrl", method = RequestMethod.GET)
    public String getObjectUrl(String name) {

        return utils.getObjectUrl(name);
    }

    /**
     * 上传文件
     * @param file
     * @return
     */
    @PostMapping("/noAuth/uploadFile")
    public JSONObject uploadFile(@RequestBody MultipartFile file,Long billId) {
        JSONObject jsonObject = new JSONObject();
        try {
            //存储的文件夹为 年-月/日/文件
            Calendar calendar = Calendar.getInstance();
            // 获取当前年-月
            String yearMonth = calendar.get(Calendar.YEAR) +"-"+(calendar.get(Calendar.MONTH) + 1);
            // 获取当前日
            String day = calendar.get(Calendar.DATE)+"";

            //先判断是否存在 年-月的文件夹
            Boolean yearMonth1 = utils.folderExists(yearMonth+"/"+day);
            if (!yearMonth1){
                //再判断是否存在 日的文件夹
                utils.createFolder(yearMonth+"/"+day);
            }

            //minIO中存储文件
            String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
            String s = utils.minioUpload(file,yearMonth+"/"+day+"/"+fileName );

            //返回给前端上传状态，文件地址
            String objectUrl = utils.getObjectUrl(yearMonth+"/"+day+"/"+fileName);
            jsonObject.put("code",0);
            jsonObject.put("msg","success");
            jsonObject.put("url",objectUrl);
            jsonObject.put("filePath",yearMonth+"/"+day+"/"+fileName);
            jsonObject.put("fileName",fileName);

            //存储到文件记录表中
            FileRecordEntity entity = new FileRecordEntity();
            if (billId == null) {
                entity.setBillId(-1L);
            }else {
                entity.setBillId(billId);
            }
            entity.setFileName(file.getOriginalFilename());
            entity.setFilePath(yearMonth+"/"+day+"/"+fileName);
            entity.setTenantId(999999L);
            entity.setIsCopy(0);

            service.saveOrUpdate(entity, false);

            jsonObject.put("fileId",entity.getId());
            return jsonObject;

        } catch (Exception e) {
            e.printStackTrace();

            jsonObject.put("code",1);
            jsonObject.put("msg","上传失败！");
            return jsonObject;
        }

    }

    /**
     * @Description delete 删除文件
     * @Param [ids]
     */
    @RequestMapping(value = "/noAuth/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(String fileName) {
        HashMap<String, Object> stringStringHashMap = new HashMap<>();
        stringStringHashMap.put("file_path",fileName);
        boolean b = service.removeByMap(stringStringHashMap);
        return CommonResponse.success("删除成功！");
    }
}
