package com.ejianc.business.filesystem.file.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
/**
 * 文件借阅
 * 
 * @author generator
 * 
 */
 @TableName("ejc_filesystem_file_borrow")
public class FileBorrowEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="borrow_user_id")
    private Long borrowUserId; // 借阅人id
    @TableField(value="borrow_user_name")
    private String borrowUserName; // 借阅人姓名
    @TableField(value="borrow_reson")
    private String borrowReson; // 借阅用途
    @TableField(value="borrow_file_kind")
    private Integer borrowFileKind; // 借阅单元（1卷，2文件）
    @TableField(value="borrow_start_time")
    private Date borrowStartTime; // 借阅开始时间
    @TableField(value="borrow_end_time")
    private Date borrowEndTime; // 预计借阅结束时间
    @TableField(value="is_return")
    private String isReturn; // 是否归还(0:否-1:是)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="fileBorrowDetailService")
    private List<FileBorrowDetailEntity> fileBorrowDetailList = new ArrayList<>(); // 文件借阅明细

    @TableField(value="borrow_type")
    private Integer borrowType; // 借阅类别(1纸质档,2电子档)

    public Integer getBorrowType() {
        return borrowType;
    }

    public void setBorrowType(Integer borrowType) {
        this.borrowType = borrowType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getBorrowUserId() {
        return borrowUserId;
    }

    public void setBorrowUserId(Long borrowUserId) {
        this.borrowUserId = borrowUserId;
    }
    public String getBorrowUserName() {
        return borrowUserName;
    }

    public void setBorrowUserName(String borrowUserName) {
        this.borrowUserName = borrowUserName;
    }
    public String getBorrowReson() {
        return borrowReson;
    }

    public void setBorrowReson(String borrowReson) {
        this.borrowReson = borrowReson;
    }
    public Integer getBorrowFileKind() {
        return borrowFileKind;
    }

    public void setBorrowFileKind(Integer borrowFileKind) {
        this.borrowFileKind = borrowFileKind;
    }
    public Date getBorrowStartTime() {
        return borrowStartTime;
    }

    public void setBorrowStartTime(Date borrowStartTime) {
        this.borrowStartTime = borrowStartTime;
    }
    public Date getBorrowEndTime() {
        return borrowEndTime;
    }

    public void setBorrowEndTime(Date borrowEndTime) {
        this.borrowEndTime = borrowEndTime;
    }
    public String getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(String isReturn) {
        this.isReturn = isReturn;
    }
    

    public List<FileBorrowDetailEntity> getFileBorrowDetailList() {
        return fileBorrowDetailList;
    }

    public void setFileBorrowDetailList(List<FileBorrowDetailEntity> fileBorrowDetailList) {
        this.fileBorrowDetailList = fileBorrowDetailList;
    }
}
