package com.ejianc.business.filesystem.file.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 案卷(文书、工程)
 * 
 * @author generator
 * 
 */
 @TableName("ejc_filesystem_file_case")
public class FileCaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="case_code")
    private String caseCode; // 案卷号
    @TableField(value="reference")
    private String reference; // 档号
    @TableField(value="status")
    private Integer status; // 状态（）
    @TableField(value="attr")
    private Integer attr; // 记录属性
    @TableField(value="attrex")
    private Integer attrex; // 扩展属性
    @TableField(value="org_id")
    private Long orgId; // 立卷单位id
    @TableField(value="org_name")
    private String orgName; // 立卷单位名称
    @TableField(value="dept_id")
    private Long deptId; // 立卷部门id
    @TableField(value="dept_name")
    private String deptName; // 立卷部门名称
    @TableField(value="project_id")
    private Long projectId; // 立卷项目id
    @TableField(value="project_name")
    private String projectName; // 立卷项目名称
    @TableField(value="file_type_id")
    private Long fileTypeId; // 分类id
    @TableField(value="file_type_name")
    private String fileTypeName; // 分类名称
    @TableField(value="parent_id")
    private Long parentId; // 上级id
    @TableField(value="title")
    private String title; // 题名
    @TableField(value="filing_num")
    private Integer filingNum; // 归档份数
    @TableField(value="person_filing_id")
    private Long personFilingId; // 归档人id
    @TableField(value="person_filing_name")
    private String personFilingName; // 归档人名称
    @TableField(value="case_create_user_id")
    private Long caseCreateUserId; // 立卷人id
    @TableField(value="case_create_user_name")
    private String caseCreateUserName; // 立卷人名称
    @TableField(value="person_responsible_id")
    private Long personResponsibleId; // 责任人id
    @TableField(value="person_responsible_name")
    private String personResponsibleName; // 责任人名称
    @TableField(value="person_check_id")
    private Long personCheckId; // 检查人id
    @TableField(value="person_check_name")
    private String personCheckName; // 检查人名称
    @TableField(value="year")
    private Integer year; // 年度
    @TableField(value="check_date")
    private Date checkDate; // 检查日期
    @TableField(value="case_date")
    private Date caseDate; // 立卷日期
    @TableField(value="start_date")
    private Date startDate; // 开始日期
    @TableField(value="end_date")
    private Date endDate; // 结束日期
    @TableField(value="total_page_num")
    private Integer totalPageNum; // 总页数
    @TableField(value="file_num")
    private Integer fileNum; // 文件件数
    @TableField(value="case_memo")
    private String caseMemo; // 立卷说明
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="keyword")
    private String keyword; // 主题词
    @TableField(value="storeroom")
    private String storeroom; // 库房位置
    @TableField(value="model_case")
    private String modelCase; // 模板卷
    @TableField(value="retention_period")
    private Integer retentionPeriod; // 保管期限(0:短期1:长期2:永久)
    @TableField(value="classification")
    private Integer classification; // 密级(0:普通1:秘密2:工作秘密3:商业秘密4:机密5:绝密)
    @TableField(value="filing_state")
    private String filingState; // 归档状态
    @TableField(value="borrow_state")
    private String borrowState; // 借阅状态（在库、借出）
    @TableField(value="create_user_id")
    private Long createUserId; // 创建人id
    @TableField(value="detail_id")
    private Long detailId; // 批id
    @TableField(value="detail_code")
    private String detailCode; // 批号
    @TableField(value="detaile_name")
    private String detaileName; // 档案批名
    @TableField(value="storeroom_id")
    private Long storeroomId; // 库房id
    @TableField(value="storeroom_code")
    private String storeroomCode; // 库房编号

    @TableField(exist=false)
    @SubEntity(serviceName="fileCaseDetailService")
    private List<FileCaseDetailEntity> fileCaseDetailList = new ArrayList<>(); // 案卷-工程档案规范


    public Long getStoreroomId() {
        return storeroomId;
    }

    public void setStoreroomId(Long storeroomId) {
        this.storeroomId = storeroomId;
    }

    public String getStoreroomCode() {
        return storeroomCode;
    }

    public void setStoreroomCode(String storeroomCode) {
        this.storeroomCode = storeroomCode;
    }

    public List<FileCaseDetailEntity> getFileCaseDetailList() {
        return fileCaseDetailList;
    }

    public void setFileCaseDetailList(List<FileCaseDetailEntity> fileCaseDetailList) {
        this.fileCaseDetailList = fileCaseDetailList;
    }

    public Long getDetailId() {
        return detailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetaileName() {
        return detaileName;
    }

    public void setDetaileName(String detaileName) {
        this.detaileName = detaileName;
    }

    public String getBorrowState() {
        return borrowState;
    }

    public void setBorrowState(String borrowState) {
        this.borrowState = borrowState;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getFilingState() {
        return filingState;
    }

    public void setFilingState(String filingState) {
        this.filingState = filingState;
    }
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Integer getAttr() {
        return attr;
    }

    public void setAttr(Integer attr) {
        this.attr = attr;
    }
    public Integer getAttrex() {
        return attrex;
    }

    public void setAttrex(Integer attrex) {
        this.attrex = attrex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getFileTypeId() {
        return fileTypeId;
    }

    public void setFileTypeId(Long fileTypeId) {
        this.fileTypeId = fileTypeId;
    }
    public String getFileTypeName() {
        return fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public Integer getFilingNum() {
        return filingNum;
    }

    public void setFilingNum(Integer filingNum) {
        this.filingNum = filingNum;
    }
    public Long getPersonFilingId() {
        return personFilingId;
    }

    public void setPersonFilingId(Long personFilingId) {
        this.personFilingId = personFilingId;
    }
    public String getPersonFilingName() {
        return personFilingName;
    }

    public void setPersonFilingName(String personFilingName) {
        this.personFilingName = personFilingName;
    }
    public Long getCaseCreateUserId() {
        return caseCreateUserId;
    }

    public void setCaseCreateUserId(Long caseCreateUserId) {
        this.caseCreateUserId = caseCreateUserId;
    }
    public String getCaseCreateUserName() {
        return caseCreateUserName;
    }

    public void setCaseCreateUserName(String caseCreateUserName) {
        this.caseCreateUserName = caseCreateUserName;
    }
    public Long getPersonResponsibleId() {
        return personResponsibleId;
    }

    public void setPersonResponsibleId(Long personResponsibleId) {
        this.personResponsibleId = personResponsibleId;
    }
    public String getPersonResponsibleName() {
        return personResponsibleName;
    }

    public void setPersonResponsibleName(String personResponsibleName) {
        this.personResponsibleName = personResponsibleName;
    }
    public Long getPersonCheckId() {
        return personCheckId;
    }

    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getCaseDate() {
        return caseDate;
    }

    public void setCaseDate(Date caseDate) {
        this.caseDate = caseDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getTotalPageNum() {
        return totalPageNum;
    }

    public void setTotalPageNum(Integer totalPageNum) {
        this.totalPageNum = totalPageNum;
    }
    public Integer getFileNum() {
        return fileNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }
    public String getCaseMemo() {
        return caseMemo;
    }

    public void setCaseMemo(String caseMemo) {
        this.caseMemo = caseMemo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }
    public String getStoreroom() {
        return storeroom;
    }

    public void setStoreroom(String storeroom) {
        this.storeroom = storeroom;
    }
    public String getModelCase() {
        return modelCase;
    }

    public void setModelCase(String modelCase) {
        this.modelCase = modelCase;
    }
    public Integer getRetentionPeriod() {
        return retentionPeriod;
    }

    public void setRetentionPeriod(Integer retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }
    public Integer getClassification() {
        return classification;
    }

    public void setClassification(Integer classification) {
        this.classification = classification;
    }
    
}
