package com.ejianc.business.filesystem.file.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 文件分类
 * 
 * @author generator
 * 
 */
 @TableName("ejc_filesystem_file_type")
public class FileTypeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="work_type_name")
    private String workTypeName; // 文件类型
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="enable")
    private String enable; // 是否启用(0:未启用-1:启用)
    @TableField(value="last_type_id")
    private Long lastTypeId; // 上级节点id
    @TableField(value="last_type_name")
    private String lastTypeName; // 上级节点名称
    @TableField(value="sort_index")
    private Integer sortIndex; // 排序索引
    @TableField(value="inner_code")
    private String innerCode; // 内码
    @TableField(value="inner_name")
    private String innerName; // 内码名称
    @TableField(value="doc_prefix")
    private String docPrefix; // 档号前缀
    @TableField(value="doc_memo")
    private String docMemo; // 档号规范说明
    @TableField(value="is_doc")
    private String isDoc; // 是否档案

    @TableField(exist=false)
    @SubEntity(serviceName="fileTypeDetailService")
    private List<FileTypeDetailEntity> fileTypeDetailList = new ArrayList<>(); // 工程案卷规范


    public List<FileTypeDetailEntity> getFileTypeDetailList() {
        return fileTypeDetailList;
    }

    public void setFileTypeDetailList(List<FileTypeDetailEntity> fileTypeDetailList) {
        this.fileTypeDetailList = fileTypeDetailList;
    }

    public String getDocPrefix() {
        return docPrefix;
    }

    public void setDocPrefix(String docPrefix) {
        this.docPrefix = docPrefix;
    }

    public String getDocMemo() {
        return docMemo;
    }

    public void setDocMemo(String docMemo) {
        this.docMemo = docMemo;
    }

    public String getIsDoc() {
        return isDoc;
    }

    public void setIsDoc(String isDoc) {
        this.isDoc = isDoc;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getEnable() {
        return enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }
    public Long getLastTypeId() {
        return lastTypeId;
    }

    public void setLastTypeId(Long lastTypeId) {
        this.lastTypeId = lastTypeId;
    }
    public String getLastTypeName() {
        return lastTypeName;
    }

    public void setLastTypeName(String lastTypeName) {
        this.lastTypeName = lastTypeName;
    }
    public Integer getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(Integer sortIndex) {
        this.sortIndex = sortIndex;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public String getInnerName() {
        return innerName;
    }

    public void setInnerName(String innerName) {
        this.innerName = innerName;
    }
    
}
