package com.ejianc.business.filesystem.file.mapper;

import com.ejianc.business.filesystem.file.vo.FileBorrowDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.filesystem.file.bean.FileBorrowDetailEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 文件借阅明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface FileBorrowDetailMapper extends BaseCrudMapper<FileBorrowDetailEntity> {
    @Select("SELECT detail.* FROM `ejc_filesystem_file_borrow_detail` as detail\n" +
            "left Join ejc_filesystem_file_borrow as zhu on zhu.id = detail.pid\n" +
            "where detail.is_return = 0 and detail.file_bill_id = #{billId} and zhu.bill_state in (1,3) and detail.dr = 0 ")
    List<FileBorrowDetailEntity> getBorrowDetailByBillId(Long billId);

    @Select("SELECT COUNT(*) num FROM `ejc_filesystem_file_borrow_detail` as detail\n" +
            "left Join ejc_filesystem_file_borrow as zhu on zhu.id = detail.pid\n" +
            "where detail.is_return = 0 and detail.file_bill_id = #{billId}  and detail.borrow_user_id = #{userId} and zhu.bill_state in (1,3) and detail.dr = 0 ")
    Integer getBorrowDetailByBillIdAndUserId(Long billId,Long userId);


    @Select("SELECT detail.*,zhu.borrow_reson,zhu.borrow_start_time as start_time,zhu.borrow_end_time as end_time" +
            " FROM `ejc_filesystem_file_borrow_detail` as detail\n" +
            "left Join ejc_filesystem_file_borrow as zhu on zhu.id = detail.pid\n" +
            "where detail.is_return = 0 and detail.file_bill_id = #{billId} and zhu.bill_state in (1,3) and detail.dr = 0 ")
    List<FileBorrowDetailVO> getBorrowDetailListByBillId(Long billId);
}
