package com.ejianc.business.filesystem.file.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileReplenishEntity;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.service.IFileMetafileReplenishService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("fileMetafileReplenish") 
public class FileMetafileReplenishBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IFileMetafileReplenishService service;

	@Autowired
	private IFileMetafileService fileMetafileService;

	@Autowired
	private IFileRecordService recordService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//
		FileMetafileReplenishEntity fileMetafileReplenishEntity = service.selectById(billId);
		FileMetafileEntity fileMetafile = fileMetafileService.selectById(fileMetafileReplenishEntity.getOldMetafileId());
		//字段更新
		FileMetafileEntity map = BeanMapper.map(fileMetafileReplenishEntity, FileMetafileEntity.class);
		map.setId(fileMetafile.getId());
		map.setBillCode(fileMetafile.getBillCode());
		map.setBillState(fileMetafile.getBillState());
		map.setCreateUserCode(fileMetafile.getCreateUserCode());
		map.setCreateTime(fileMetafile.getCreateTime());
		map.setCreateUserName(fileMetafile.getCreateUserName());
		map.setFilingState(fileMetafile.getFilingState());

		fileMetafileService.saveOrUpdate(map);

		//附件更新
		QueryWrapper<FileRecordEntity> ae = new QueryWrapper<>();
		ae.eq("bill_id",billId );
		ae.eq("dr",0);
		ae.eq("is_copy",0);
		List<FileRecordEntity> list = recordService.list(ae);
		if (CollectionUtils.isNotEmpty(list)){
			for (FileRecordEntity fileRecordEntity : list) {
				fileRecordEntity.setId(null);
				fileRecordEntity.setBillId(fileMetafile.getId());
				fileRecordEntity.setIsCopy(0);
				recordService.saveOrUpdate(fileRecordEntity);
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//
		return CommonResponse.error("补录数据已经更新到原始文件中，无法退回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
