/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.common.MinioUtils;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileReplenishEntity;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.dto.FileBtnDTO;
import com.ejianc.business.filesystem.file.dto.FileResponseDTO;
import com.ejianc.business.filesystem.file.mapper.FileBorrowDetailMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileReplenishService;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileMetafileReplenishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileMetafileReplenish"})
public class FileMetafileReplenishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFileMetafileReplenishService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFileRecordService recordService;
    @Autowired
    private MinioUtils utils;
    @Value(value="${ejc.roleid}")
    private Long roleId;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IFileCaseService caseService;
    @Autowired
    private IFileTypeService fileTypeService;
    @Autowired
    private FileBorrowDetailMapper borrowDetailMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileMetafileReplenishVO> saveOrUpdate(@RequestBody FileMetafileReplenishVO saveOrUpdateVO) {
        FileMetafileReplenishEntity entity = (FileMetafileReplenishEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileMetafileReplenishEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserId(userContextCache.getUserId());
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        FileCaseEntity fileCaseEntity = (FileCaseEntity)((Object)this.caseService.selectById(entity.getParentId()));
        if (entity.getFileTypeId() == null) {
            entity.setFileTypeId(fileCaseEntity.getFileTypeId());
            entity.setFileTypeName(fileCaseEntity.getFileTypeName());
        }
        if (fileCaseEntity != null && fileCaseEntity.getProjectId() != null) {
            entity.setProjectId(fileCaseEntity.getProjectId());
            entity.setProjectName(fileCaseEntity.getProjectName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getFileIds())) {
            for (Long fileId : saveOrUpdateVO.getFileIds()) {
                FileRecordEntity fileRecordEntity = (FileRecordEntity)((Object)this.recordService.selectById(fileId));
                if (fileRecordEntity.getBillId() != -1L) continue;
                fileRecordEntity.setBillId(entity.getId());
                this.recordService.saveOrUpdate((Object)fileRecordEntity);
            }
        }
        FileMetafileReplenishVO vo = (FileMetafileReplenishVO)BeanMapper.map((Object)((Object)entity), FileMetafileReplenishVO.class);
        QueryWrapper ae = new QueryWrapper();
        ae.eq((Object)"bill_id", (Object)entity.getId());
        ae.eq((Object)"dr", (Object)0);
        List list = this.recordService.list((Wrapper)ae);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<FileBtnDTO> fileList = new ArrayList<FileBtnDTO>();
            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();
                String objectUrl = this.utils.getObjectUrl(fileRecordEntity.getFilePath());
                fileBtnDTO.setUid(fileRecordEntity.getId() + "");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                fileBtnDTO.setUrl(objectUrl);
                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                fileResponseDTO.setUrl(objectUrl);
                fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                fileResponseDTO.setFileId(fileRecordEntity.getId() + "");
                fileBtnDTO.setResponse(fileResponseDTO);
                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
            entity.setFileUploadNum(list.size());
        } else {
            entity.setFileUploadNum(0);
        }
        this.service.saveOrUpdate((Object)entity);
        vo.setFileUploadNum(entity.getFileUploadNum());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileMetafileReplenishVO> queryDetail(Long id) {
        FileMetafileReplenishEntity entity = (FileMetafileReplenishEntity)((Object)this.service.selectById(id));
        FileMetafileReplenishVO vo = (FileMetafileReplenishVO)BeanMapper.map((Object)((Object)entity), FileMetafileReplenishVO.class);
        boolean viewFlag = false;
        UserContext userContextCache = this.sessionManager.getUserContext();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(this.roleId);
        CommonResponse roleResp = this.roleApi.getRoleUser(roleIds, null);
        if (!roleResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u89d2\u8272\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List relationVOS = (List)roleResp.getData();
        List userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());
        if (userIds.contains(userContextCache.getUserId().toString())) {
            viewFlag = true;
        }
        if (vo.getCreateUserId().equals(userContextCache.getUserId())) {
            viewFlag = true;
        }
        Integer borrowDetailByBillIdAndUserId = this.borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getId(), userContextCache.getUserId());
        Integer borrowDetailByBillIdAndUserId1 = this.borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getParentId(), userContextCache.getUserId());
        if (borrowDetailByBillIdAndUserId > 0 || borrowDetailByBillIdAndUserId1 > 0) {
            viewFlag = true;
        }
        this.logger.info("\u5f53\u524d\u6d4f\u89c8\u6587\u4ef6\u7684\u4eba\u5458:{},\u6587\u6863id:{},\u662f\u5426\u6709\u6743\u9650:{}", new Object[]{userContextCache.getUserName(), id, viewFlag});
        QueryWrapper ae = new QueryWrapper();
        ae.eq((Object)"bill_id", (Object)entity.getId());
        ae.eq((Object)"dr", (Object)0);
        List list = this.recordService.list((Wrapper)ae);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<FileBtnDTO> fileList = new ArrayList<FileBtnDTO>();
            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();
                String objectUrl = this.utils.getObjectUrl(fileRecordEntity.getFilePath());
                fileBtnDTO.setUid(fileRecordEntity.getId() + "");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                if (viewFlag) {
                    fileBtnDTO.setUrl(objectUrl);
                }
                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                if (viewFlag) {
                    fileResponseDTO.setUrl(objectUrl);
                    fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                }
                fileResponseDTO.setFileId(fileRecordEntity.getId() + "");
                fileBtnDTO.setResponse(fileResponseDTO);
                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileMetafileReplenishVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileMetafileReplenishVO fileMetafileReplenishVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileReplenishVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileReplenishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafileReplenish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileMetafileReplenishData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileReplenishVO>> refFileMetafileReplenishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileReplenishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

