/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BillTypeCodeEnum {
    \u5206\u5305\u5408\u540c("\u5206\u5305\u5408\u540c", "BT200529000000001"),
    \u8bbe\u5907\u91c7\u8d2d\u5408\u540c("\u8bbe\u5907\u91c7\u8d2d\u5408\u540c", "BT200528000000001"),
    \u8bbe\u5907\u79df\u8d41\u5408\u540c("\u8bbe\u5907\u79df\u8d41\u5408\u540c", "BT200528000000003"),
    \u7269\u8d44\u91c7\u8d2d\u5408\u540c("\u7269\u8d44\u91c7\u8d2d\u5408\u540c", "BT200608000000001"),
    \u7269\u8d44\u79df\u8d41\u5408\u540c("\u7269\u8d44\u79df\u8d41\u5408\u540c", "BT200608000000001"),
    \u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c", "BT210615000000001"),
    \u5176\u4ed6\u652f\u51fa\u5408\u540c("\u5176\u4ed6\u652f\u51fa\u5408\u540c", "BT210916000000001"),
    \u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97("\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97", "BT240611000000002"),
    \u5206\u5305\u5b8c\u5de5\u7ed3\u7b97("\u5206\u5305\u5b8c\u5de5\u7ed3\u7b97", "BT200630000000002"),
    \u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97("\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97", "BT200604000000002"),
    \u8bbe\u5907\u79df\u8d41\u7ed3\u7b97("\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97", "BT200610000000002"),
    \u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97("\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97", "BT200610000000004"),
    \u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97("\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97", "BT210615000000003"),
    \u5176\u4ed6\u652f\u51fa\u5408\u540c\u7ed3\u7b97("\u5176\u4ed6\u652f\u51fa\u7ed3\u7b97", "BT210923000000001"),
    \u7269\u8d44\u79df\u8d41\u7ed3\u7b97("\u7269\u8d44\u79df\u8d41\u7ed3\u7b97", "BT200610000000004"),
    \u7a0e\u52a1\u6536\u7968("\u7a0e\u52a1\u6536\u7968", "BT210817000000004"),
    \u7a0e\u52a1\u5f00\u7968("\u7a0e\u52a1\u5f00\u7968", "BT210817000000003"),
    \u7269\u8d44\u5165\u5e93("\u7269\u8d44\u5165\u5e93", "BT200611000000015"),
    \u65bd\u5de5\u5408\u540c("\u65bd\u5de5\u5408\u540c", "BT200528000000002");

    private static final String[] CONTRACT_BILL_TYPE;
    private static final String[] SETTLE_BILL_TYPE;
    private final String billTypeName;
    private final String billTypeCode;
    private static Map<String, BillTypeCodeEnum> enumMap;

    private BillTypeCodeEnum(String billTypeName, String billTypeCode) {
        this.billTypeName = billTypeName;
        this.billTypeCode = billTypeCode;
    }

    public String getBillTypeName() {
        return this.billTypeName;
    }

    public String getBillTypeCode() {
        return this.billTypeCode;
    }

    public static String getContractBillTypeCode(Long contractType) {
        String billTypeName = CONTRACT_BILL_TYPE[contractType.intValue() - 1];
        String billTypeCode = BillTypeCodeEnum.getEnumByName(billTypeName).getBillTypeCode();
        return billTypeCode;
    }

    public static String getSettleBillTypeCode(Long contractType) {
        String billTypeName = SETTLE_BILL_TYPE[contractType.intValue() - 1];
        String billTypeCode = BillTypeCodeEnum.getEnumByName(billTypeName).getBillTypeCode();
        return billTypeCode;
    }

    public static BillTypeCodeEnum getEnumByName(String billTypeName) {
        return enumMap.get(billTypeName);
    }

    static {
        CONTRACT_BILL_TYPE = new String[]{"\u5206\u5305\u5408\u540c", "\u8bbe\u5907\u91c7\u8d2d\u5408\u540c", "\u8bbe\u5907\u79df\u8d41\u5408\u540c", "\u7269\u8d44\u91c7\u8d2d\u5408\u540c", "\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c", "\u5176\u4ed6\u652f\u51fa\u5408\u540c", "\u7269\u8d44\u79df\u8d41\u5408\u540c"};
        SETTLE_BILL_TYPE = new String[]{"\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97", "\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97", "\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97", "\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97", "\u5468\u8f6c\u6750\u79df\u8d41\u7ed3\u7b97", "\u5176\u4ed6\u652f\u51fa\u7ed3\u7b97", "\u7269\u8d44\u79df\u8d41\u7ed3\u7b97"};
        enumMap = new HashMap<String, BillTypeCodeEnum>();
        enumMap = EnumSet.allOf(BillTypeCodeEnum.class).stream().collect(Collectors.toMap(BillTypeCodeEnum::getBillTypeName, Function.identity(), (k1, k2) -> k2));
    }
}

