package com.ejianc.business.bank.vo;

import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 账户收支流水
 *
 * @author generator
 *
 */
public class BankFlowVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 交易日期
    private Integer inOutFlag; // 收支方向1收入2支出
    private Long sourceId; // 来源单据ID
    private Integer sourceFlag; // 数据来源
    private String sourceName; // 数据来源，大类来源不唯一
    private String sourceExtName; // 数据来源,具体明细来源，唯一
    private Long billId; // 联查单据ID
    private BigDecimal receiveMoney; // 收款金额
    private BigDecimal payMoney; // 付款金额
    private String billCode; // 单据编号
    private Long orgId; // 业务组织
    private String orgName; // 业务组织
    private Long accountOrgId; // 账户所属公司
    private String accountOrgName; // 账户所属公司
    private Long accountId; // 账户ID
    private String accountName; // 账户名称
    private String accountBank; // 开户行
    private String accountNum; // 账号
    private Long tradeOrgId; // 往来单位
    private String tradeOrgName; // 往来单位
    private Long tradeAccountId; // 对方账户
    private String tradeAccountName; // 对方账户
    private String tradeAccountBank; // 对方开户行
    private String tradeAccountNum; // 对方账号
    private String memo; // 备注


    public static BankFlowVO instanceVOBySourceType(BankFlowSourceType sourceType) {
        BankFlowVO bankFlowVO = new BankFlowVO();
        bankFlowVO.setSourceFlag(sourceType.getCode());
        bankFlowVO.setSourceName(sourceType.getName());
        bankFlowVO.setInOutFlag(sourceType.getCode() <= 20 ? 1 : 2);
        return bankFlowVO;
    }

    public static BankFlowVO instanceVOBySourceType(BankFlowSourceType sourceType, String sourceExtName) {
        BankFlowVO bankFlowVO = instanceVOBySourceType(sourceType);
        bankFlowVO.setSourceExtName(sourceExtName);
        return bankFlowVO;
    }

    public String getSourceExtName() {
        return sourceExtName;
    }

    public void setSourceExtName(String sourceExtName) {
        this.sourceExtName = sourceExtName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public BigDecimal getReceiveMoney() {
        return receiveMoney;
    }

    public void setReceiveMoney(BigDecimal receiveMoney) {
        this.receiveMoney = receiveMoney;
    }

    public BigDecimal getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getAccountOrgId() {
        return accountOrgId;
    }

    public void setAccountOrgId(Long accountOrgId) {
        this.accountOrgId = accountOrgId;
    }

    public String getAccountOrgName() {
        return accountOrgName;
    }

    public void setAccountOrgName(String accountOrgName) {
        this.accountOrgName = accountOrgName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public Long getTradeOrgId() {
        return tradeOrgId;
    }

    public void setTradeOrgId(Long tradeOrgId) {
        this.tradeOrgId = tradeOrgId;
    }

    public String getTradeOrgName() {
        return tradeOrgName;
    }

    public void setTradeOrgName(String tradeOrgName) {
        this.tradeOrgName = tradeOrgName;
    }

    public Long getTradeAccountId() {
        return tradeAccountId;
    }

    public void setTradeAccountId(Long tradeAccountId) {
        this.tradeAccountId = tradeAccountId;
    }

    public String getTradeAccountName() {
        return tradeAccountName;
    }

    public void setTradeAccountName(String tradeAccountName) {
        this.tradeAccountName = tradeAccountName;
    }

    public String getTradeAccountBank() {
        return tradeAccountBank;
    }

    public void setTradeAccountBank(String tradeAccountBank) {
        this.tradeAccountBank = tradeAccountBank;
    }

    public String getTradeAccountNum() {
        return tradeAccountNum;
    }

    public void setTradeAccountNum(String tradeAccountNum) {
        this.tradeAccountNum = tradeAccountNum;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
