package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *  累计付款金额与付款详情
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class SumPayMnyVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;


    /**
     * 截止上期已申请=查合同+组织下已生效的申请单申请金额累计；
     */
    private BigDecimal sumApplyMny;

    /**
     * 累计预付款金额
     * 根据参数（PREPAY_PARAM = "P-zu6b9071"）取支付金额还是所有状态申请金额
     *  P-zu6b9071
     *  所有支出类结算单预付款抵扣功能中的预付款取数方式
     *  1：取该合同的预付款支付金额；
     *  2：取该合同的预付款申请金额(所有状态的付款申请单)；
     */
    private BigDecimal sumPrePayMny;

    /**
     * 累计扣款金额
     */
    private BigDecimal sumDeductionMny;


    /**
     * 付款详情子表
     */
    private List<PayContractVO> contractVOList;


    public BigDecimal getSumDeductionMny() {
        return sumDeductionMny;
    }

    public void setSumDeductionMny(BigDecimal sumDeductionMny) {
        this.sumDeductionMny = sumDeductionMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public List<PayContractVO> getContractVOList() {
        return contractVOList;
    }

    public void setContractVOList(List<PayContractVO> contractVOList) {
        this.contractVOList = contractVOList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrePayMny() {
        return sumPrePayMny;
    }

    public void setSumPrePayMny(BigDecimal sumPrePayMny) {
        this.sumPrePayMny = sumPrePayMny;
    }
}
