package com.ejianc.business.finance.vo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目付款申请金额统计
 * 统计包含合同付款、零星、报销（注意：不包含押金）的已支付金额，累计申请金额
 */
public class ProjectFinanceVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String projectType;


    private java.math.BigDecimal proContractMny; // 收入合同金额
    private java.math.BigDecimal proOutputMny; // 完成产值
    private java.math.BigDecimal proDateProgress; // 日期进度
    private java.math.BigDecimal proOutputProgress; // 产值进度
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    private java.math.BigDecimal proReceiveMny; // 累计收款
    private java.math.BigDecimal proPayMny; // 累计付款
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private java.math.BigDecimal proLoanBalance; // 借款结余
    private java.math.BigDecimal proLoanInterest; // 借款利息
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额
    private java.math.BigDecimal proPettyCash; // 备用金结余
    private java.math.BigDecimal proManageScale; // 管理费比例
    private java.math.BigDecimal proManageFee; // 管理费
    private java.math.BigDecimal proAmerce; // 罚款
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    public ProjectFinanceVO() {
    }

    public ProjectFinanceVO(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

}
