package com.ejianc.business.bank.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 账户余额调整
 * 
 * @author generator
 * 
 */
public class BankFinanceAdjustVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String title; // 标题
    private Long accountId; // 调整账户
    private String accountName; // 调整账户名称
    private String accountBank; // 开户行
    private String accountNum; // 账号
    private Integer adjustTrend; // 调整方向(1:调增，2：调减)
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private String billCode; // 单据编号
    private BigDecimal adjustMny; // 调整金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date adjustDate; // 调整日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门
    private String departmentName; // 经办人部门
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String adjustTrendName; // 单据状态


    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public Integer getAdjustTrend() {
        return adjustTrend;
    }

    public void setAdjustTrend(Integer adjustTrend) {
        this.adjustTrend = adjustTrend;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getAdjustMny() {
        return adjustMny;
    }

    public void setAdjustMny(BigDecimal adjustMny) {
        this.adjustMny = adjustMny;
    }
    public Date getAdjustDate() {
        return adjustDate;
    }

    public String getAdjustTrendName() {
        return adjustTrendName;
    }

    public void setAdjustTrendName(String adjustTrendName) {
        this.adjustTrendName = adjustTrendName;
    }

    public void setAdjustDate(Date adjustDate) {
        this.adjustDate = adjustDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
