package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.BudgetControlHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback = BudgetControlHystrix.class)
public interface IBudgetControlApi {

    /**
     * 根据项目id统计费用报销、备用金报销、零星付款申请
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/budgetControl/budgetControlTotal")
    public CommonResponse<BigDecimal> budgetControlTotal(@RequestParam(value = "projectId", required = true)Long projectId);
}
