package com.ejianc.business.finance.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeCodeEnum {

    // 合同
    分包合同("分包合同", "BT200529000000001"),
    设备采购合同("设备采购合同", "BT200528000000001"),
    设备租赁合同("设备租赁合同", "BT200528000000003"),
    物资采购合同("物资采购合同", "BT200608000000001"),
    物资租赁合同("物资租赁合同", "BT200608000000001"),
    周转材租赁合同("周转材租赁合同","BT210615000000001"),
    其他支出合同("其他支出合同","BT210916000000001"),
    // 结算
    分包过程结算("分包过程结算", "BT240611000000002"),
    分包完工结算("分包完工结算", "BT200630000000002"),
    设备采购结算("设备采购结算", "BT200604000000002"),
    设备租赁结算("设备租赁结算", "BT200610000000002"),
    物资采购结算("物资采购结算", "BT200610000000004"),
    周转材租赁结算("周转材租赁结算", "BT210615000000003"),
    其他支出合同结算("其他支出结算", "BT210923000000001"),
    物资租赁结算("物资租赁结算", "BT200610000000004"),
    // 发票
    税务收票("税务收票", "BT210817000000004"),
    税务开票("税务开票", "BT210817000000003"),
    // 入库
    物资入库("物资入库", "BT200611000000015"),
    // 施工合同
    施工合同("施工合同", "BT200528000000002"),
    ;

    private final static String[] CONTRACT_BILL_TYPE = {
            "分包合同",
            "设备采购合同",
            "设备租赁合同",
            "物资采购合同",
            "周转材租赁合同",
            "其他支出合同",
            "物资租赁合同",
    };

    private final static String[] SETTLE_BILL_TYPE = {
            "分包过程结算",
            "设备采购结算",
            "设备租赁结算",
            "物资采购结算",
            "周转材租赁结算",
            "其他支出结算",
            "物资租赁结算",
    };

    private final String billTypeName;
    private final String billTypeCode;
    private static Map<String, BillTypeCodeEnum> enumMap = new HashMap();

    private BillTypeCodeEnum(String billTypeName, String billTypeCode) {
        this.billTypeName = billTypeName;
        this.billTypeCode = billTypeCode;
    }

    public String getBillTypeName() {
        return this.billTypeName;
    }

    public String getBillTypeCode() {
        return this.billTypeCode;
    }

    public static String getContractBillTypeCode(Long contractType){
        String billTypeName = CONTRACT_BILL_TYPE[contractType.intValue() - 1];
        String billTypeCode = getEnumByName(billTypeName).getBillTypeCode();
        return billTypeCode;
    };

    public static String getSettleBillTypeCode(Long contractType){
        String billTypeName = SETTLE_BILL_TYPE[contractType.intValue() - 1];
        String billTypeCode = getEnumByName(billTypeName).getBillTypeCode();
        return billTypeCode;
    };

    public static BillTypeCodeEnum getEnumByName(String billTypeName) {
        return (BillTypeCodeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeCodeEnum.class).stream().collect(Collectors.toMap(BillTypeCodeEnum::getBillTypeName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
