package com.ejianc.business.finance.vo;

import com.ejianc.business.prjfinance.vo.OperationCostVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: ProjectLedgerVO
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/5/26 15:50
 */
public class ProjectLedgerVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 累计收款
     */
    private BigDecimal sumReceiveMny;

    /**
     * 累计支出
     */
    private BigDecimal sumPayMny;

    /**
     * 账面资金
     */
    private BigDecimal bookFunds;

    /**
     * 支出明细
     */
    private List<ExpenditureVO> expenditureList;

    /**
     * 收入明细
     */
    private List<IncomeVO> incomeList;

    /**
     * 累计申请金额--生效态
     */
    private BigDecimal sumEffectiveApplyMny;;

    /**
     * 累计申请金额--未生效态
     */
    private BigDecimal sumFreeApplyMny;

    /**
     * 联营费用明细
     */
    private List<OperationCostVO> operationList;

    /**
     * 联营费用
     */
    private BigDecimal operationCostMny;


    /**
     * 项目垫资结余
     */
    private BigDecimal xiangMuDianZiJieYuMny;


    public BigDecimal getXiangMuDianZiJieYuMny() {
        return xiangMuDianZiJieYuMny;
    }

    public void setXiangMuDianZiJieYuMny(BigDecimal xiangMuDianZiJieYuMny) {
        this.xiangMuDianZiJieYuMny = xiangMuDianZiJieYuMny;
    }

    public BigDecimal getSumEffectiveApplyMny() {
        return sumEffectiveApplyMny;
    }

    public void setSumEffectiveApplyMny(BigDecimal sumEffectiveApplyMny) {
        this.sumEffectiveApplyMny = sumEffectiveApplyMny;
    }

    public BigDecimal getSumFreeApplyMny() {
        return sumFreeApplyMny;
    }

    public void setSumFreeApplyMny(BigDecimal sumFreeApplyMny) {
        this.sumFreeApplyMny = sumFreeApplyMny;
    }

    public List<OperationCostVO> getOperationList() {
        return operationList;
    }

    public void setOperationList(List<OperationCostVO> operationList) {
        this.operationList = operationList;
    }

    public BigDecimal getOperationCostMny() {
        return operationCostMny;
    }

    public void setOperationCostMny(BigDecimal operationCostMny) {
        this.operationCostMny = operationCostMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getBookFunds() {
        return bookFunds;
    }

    public void setBookFunds(BigDecimal bookFunds) {
        this.bookFunds = bookFunds;
    }

    public List<ExpenditureVO> getExpenditureList() {
        return expenditureList;
    }

    public void setExpenditureList(List<ExpenditureVO> expenditureList) {
        this.expenditureList = expenditureList;
    }

    public List<IncomeVO> getIncomeList() {
        return incomeList;
    }

    public void setIncomeList(List<IncomeVO> incomeList) {
        this.incomeList = incomeList;
    }
}
