package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标保证金申请子表
 *
 * @author generator
 *
 */
public class BidBondDealVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long bondId; // 保证金主键
    private String billCode; // 保证函编号
    private Long payType;
    private String payTypeName; // 缴纳方式类型
    private BigDecimal bondMny; // 保证金金额
    private Date beginDate; // 开始时间
    private Date endDate; // 有效期至
    private String accountName; // 账户名
    private String bankAccount; // 银行账号
    private String bankName; // 开户行
    private String memo; // 备注
    private String dealStatus; // 办理状态:1-生效，2-已作废
    private Long employeeId; // 经办人
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date dealTime; // 办理时间
    private String employeeName; // 经办人
    private BigDecimal invoiceMny; // 开票金额
    private String payAccountName; // 账户名
    private String payAccountNum; // 银行账号
    private String payAccountBank; // 开户行
    private Long payAccountId; // 账户名
    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayType() {
        return payType;
    }
    @ReferDeserialTransfer
    public void setPayType(Long payType) {
        this.payType = payType;
    }

    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }

    public BigDecimal getBondMny() {
        return bondMny;
    }

    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }
    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getPayAccountId() {
        return payAccountId;
    }
    @ReferDeserialTransfer
    public void setPayAccountId(Long payAccountId) {
        this.payAccountId = payAccountId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
}
