package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金统计
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
public class BondReportVO extends BaseVO {
    /**
     * 申请金额
     */
    private BigDecimal upApplyMny = BigDecimal.ZERO;

    /**
     * 已支付金额
     */
    private BigDecimal upPayMny = BigDecimal.ZERO;

    /**
     * 已退还金额
     */
    private BigDecimal upBackMny = BigDecimal.ZERO;

    /**
     * 到期未还
     */
    private BigDecimal upUnPayMny = BigDecimal.ZERO;

    /**
     * 申请金额
     */
    private BigDecimal downApplyMny = BigDecimal.ZERO;

    /**
     * 已支付金额
     */
    private BigDecimal downPayMny = BigDecimal.ZERO;

    /**
     * 已退还金额
     */
    private BigDecimal downBackMny = BigDecimal.ZERO;

    /**
     * 到期未还
     */
    private BigDecimal downUnPayMny = BigDecimal.ZERO;

    /**
     * 期限结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getUpApplyMny() {
        return upApplyMny;
    }

    public void setUpApplyMny(BigDecimal upApplyMny) {
        this.upApplyMny = upApplyMny;
    }

    public BigDecimal getUpPayMny() {
        return upPayMny;
    }

    public void setUpPayMny(BigDecimal upPayMny) {
        this.upPayMny = upPayMny;
    }

    public BigDecimal getUpBackMny() {
        return upBackMny;
    }

    public void setUpBackMny(BigDecimal upBackMny) {
        this.upBackMny = upBackMny;
    }

    public BigDecimal getUpUnPayMny() {
        return upUnPayMny;
    }

    public void setUpUnPayMny(BigDecimal upUnPayMny) {
        this.upUnPayMny = upUnPayMny;
    }

    public BigDecimal getDownApplyMny() {
        return downApplyMny;
    }

    public void setDownApplyMny(BigDecimal downApplyMny) {
        this.downApplyMny = downApplyMny;
    }

    public BigDecimal getDownPayMny() {
        return downPayMny;
    }

    public void setDownPayMny(BigDecimal downPayMny) {
        this.downPayMny = downPayMny;
    }

    public BigDecimal getDownBackMny() {
        return downBackMny;
    }

    public void setDownBackMny(BigDecimal downBackMny) {
        this.downBackMny = downBackMny;
    }

    public BigDecimal getDownUnPayMny() {
        return downUnPayMny;
    }

    public void setDownUnPayMny(BigDecimal downUnPayMny) {
        this.downUnPayMny = downUnPayMny;
    }
}
