package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_up_back")
public class BondUpBackVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    private Long bondId;

    /**
     * 退还编号
     */
    private String billCode;

    /**
     * 退还金额
     */
    private BigDecimal backMny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 经办人
     */
    private Long employeeId;
    private String employeeName;

    private String accountName; // 账户名
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private Long accountId; // 账户名
    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    private String bondCode; //保证金编号 1

    private String contractName;// 合同名称 1

    private String contractId;//合同ID 1

    private Long orgId; // 组织 1

    private String orgName; // 组织名称 1

    private Long projectId; // 项目 1

    private String projectName; // 项目名称 1

    private Long supplierId; // 申请人id 1

    private String supplierName; // 申请人名字 1

    private BigDecimal bondPayMny;//保证金金额 1

    private BigDecimal returnPayMny;//已退还金额 1

    private Integer billState; // 单据状态1

    private Long customerId; // 客户id

    private String customerName; // 客户名称
    private String billStateName;
    private String createTimeName;

    public String getCreateTimeName() {
        return createTimeName;
    }

    public void setCreateTimeName(String createTimeName) {
        this.createTimeName = createTimeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }


    @ReferSerialTransfer(referCode="bondUpRef")
    public Long getBondId() {
        return bondId;
    }
    @ReferDeserialTransfer
    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }

    public String getBondCode() {
        return bondCode;
    }

    public void setBondCode(String bondCode) {
        this.bondCode = bondCode;
    }

    public BigDecimal getReturnPayMny() {
        return returnPayMny;
    }

    public void setReturnPayMny(BigDecimal returnPayMny) {
        this.returnPayMny = returnPayMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getBondPayMny() {
        return bondPayMny;
    }

    public void setBondPayMny(BigDecimal bondPayMny) {
        this.bondPayMny = bondPayMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
