package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_back")
public class BondDownBackVO extends BaseVO {

    private static final long serialVersionUID = 1L;


    private Long bondId;//保证金主键

    private String billCode;//退还编号

    private String memo;//退还说明

    private Long employeeId;//申请人

    private String employeeName;//申请人 名称

    private BigDecimal backMny;//退还金额 0

    private String bondCode; //保证金编号 1

    private String contractName;// 合同名称 1

    private String contractId;//合同ID 1

    private Long orgId; // 组织 1

    private String orgName; // 组织名称 1

    private Long projectId; // 项目 1

    private String projectName; // 项目名称 1

    private Long supplierId; // 供应商id 1

    private String supplierName; // 供应商名字 1

    private BigDecimal bondPayMny;//保证金支付金额 1

    private BigDecimal returnPayMny;//已退还金额 1

    private BigDecimal residueMny;//剩余可退还金额 1

    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime; // 退还日期 1

    private String accountName; // 账户名 1

    private String bankAccount; // 银行账号 1

    private String bankName; // 开户行 1

    private Integer billState; // 单据状态1

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;
    private String billStateName;
    private String createTimeName;
    private String payAccountName; // 账户名
    private String payAccountNum; // 银行账号
    private String payAccountBank; // 开户行
    private Long payAccountId; // 账户名
    public String getCreateTimeName() {
        return createTimeName;
    }

    public void setCreateTimeName(String createTimeName) {
        this.createTimeName = createTimeName;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBondCode() {
        return bondCode;
    }

    public void setBondCode(String bondCode) {
        this.bondCode = bondCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getBondPayMny() {
        return bondPayMny;
    }

    public void setBondPayMny(BigDecimal bondPayMny) {
        this.bondPayMny = bondPayMny;
    }

    public BigDecimal getReturnPayMny() {
        return returnPayMny;
    }

    public void setReturnPayMny(BigDecimal returnPayMny) {
        this.returnPayMny = returnPayMny;
    }

    public BigDecimal getResidueMny() {
        return residueMny;
    }

    public void setResidueMny(BigDecimal residueMny) {
        this.residueMny = residueMny;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    @ReferSerialTransfer(referCode = "finance-bank-acct")
    public Long getPayAccountId() {
        return payAccountId;
    }
    @ReferDeserialTransfer
    public void setPayAccountId(Long payAccountId) {
        this.payAccountId = payAccountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="bondDownRef")
    public Long getBondId() {
        return bondId;
    }
    @ReferDeserialTransfer
    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

}
