package com.ejianc.business.finance.vo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目付款申请金额统计
 * 按项目统计申请合计，支付合计
 */
public class ProjectFinancePayVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 累计申请金额(包含自由态)
     */
    private BigDecimal sumApplyMny;

    /**
     * 已支付金额
     */
    private BigDecimal sumPayMny;

    /**
     * 累计申请金额--生效态
     */
    private BigDecimal sumEffectiveApplyMny;

    public BigDecimal getSumEffectiveApplyMny() {
        return sumEffectiveApplyMny;
    }

    public void setSumEffectiveApplyMny(BigDecimal sumEffectiveApplyMny) {
        this.sumEffectiveApplyMny = sumEffectiveApplyMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
}
