package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *  累计付款金额与付款详情
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class SumPayMnyVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 累计付款金额
     */
    private BigDecimal sumPayMny;


    /**
     * 截止上期已申请=查合同+组织下已生效的申请单申请金额累计；
     */
    private BigDecimal sumApplyMny;

    /**
     * 累计预付款金额
     */
    private BigDecimal sumPrePayMny;

    /**
     * 付款详情子表
     */
    private List<PayContractVO> contractVOList;


    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public List<PayContractVO> getContractVOList() {
        return contractVOList;
    }

    public void setContractVOList(List<PayContractVO> contractVOList) {
        this.contractVOList = contractVOList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumPrePayMny() {
        return sumPrePayMny;
    }

    public void setSumPrePayMny(BigDecimal sumPrePayMny) {
        this.sumPrePayMny = sumPrePayMny;
    }
}
